/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import java.util.function.Function;

public class VncKeyword
extends VncString
implements Function<VncList, VncVal> {
    public VncKeyword(String v) {
        super(v.startsWith(":") ? v.substring(1) : v);
    }

    @Override
    public VncVal apply(VncList args) {
        FunctionsUtil.assertArity("keyword", args, 1);
        if (args.first() == Constants.Nil) {
            return Constants.Nil;
        }
        VncMap map = Coerce.toVncMap(args.first());
        return map.get(this);
    }

    @Override
    public VncKeyword copy() {
        VncKeyword v = new VncKeyword(this.getValue());
        v.setMeta(this.getMeta());
        return v;
    }

    @Override
    public VncSymbol toSymbol() {
        return new VncSymbol(this.getValue());
    }

    @Override
    public int compareTo(VncVal o) {
        return Types.isVncKeyword(o) ? this.getValue().compareTo(((VncKeyword)o).getValue()) : 0;
    }

    @Override
    public String toString() {
        return ":" + this.getValue();
    }

    @Override
    public String toString(boolean print_readably) {
        return this.toString();
    }
}

