/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class StreamUtil {
    public static byte[] copyIStoByteArray(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int n;
            byte[] buffer = new byte[16384];
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String copyIStoString(InputStream is, String encoding) throws IOException {
        return is == null ? null : new String(StreamUtil.copyIStoByteArray(is), encoding == null ? Charset.defaultCharset().name() : encoding);
    }

    public static void copyByteArrayToOS(byte[] data, OutputStream os) throws IOException {
        if (os == null || data == null) {
            return;
        }
        os.write(data);
    }

    public static void copyFileToOS(File file, OutputStream os) throws IOException {
        if (os == null || file == null) {
            return;
        }
        try (FileInputStream is = new FileInputStream(file);){
            StreamUtil.copy(is, os);
        }
    }

    public static void copyStringToOS(String data, OutputStream os, String encoding) throws IOException {
        if (os == null || data == null) {
            return;
        }
        os.write(encoding == null ? data.getBytes(Charset.defaultCharset()) : data.getBytes(encoding));
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = is.read(buf)) != -1) {
            os.write(buf, 0, len);
        }
        os.flush();
    }
}

