/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class DynamicInvocationHandler
implements InvocationHandler {
    final Map<String, VncFunction> methods;

    public DynamicInvocationHandler(Map<String, VncFunction> methods) {
        this.methods = methods;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        VncFunction fn = this.methods.get(method.getName());
        if (fn != null) {
            VncList vncArgs = new VncList(new VncVal[0]);
            if (args != null) {
                for (Object arg : args) {
                    vncArgs.addAtEnd(JavaInteropUtil.convertToVncVal(arg));
                }
            }
            return JavaInteropUtil.convertToJavaObject((VncVal)fn.apply(vncArgs));
        }
        throw new UnsupportedOperationException(String.format("ProxyMethod %s", method.getName()));
    }

    public static Object proxify(Class<?> clazz, Map<String, VncFunction> handlers) {
        return Proxy.newProxyInstance(DynamicInvocationHandler.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new DynamicInvocationHandler(handlers));
    }

    public static Object proxify(Class<?> clazz, VncMap handlers) {
        HashMap<String, VncFunction> handlerMap = new HashMap<String, VncFunction>();
        for (Map.Entry<VncVal, VncVal> entry : handlers.entries()) {
            handlerMap.put(Types.isVncKeyword(entry.getKey()) ? Coerce.toVncKeyword(entry.getKey()).getValue() : Coerce.toVncString(entry.getKey()).getValue(), Coerce.toVncFunction(entry.getValue()));
        }
        return Proxy.newProxyInstance(DynamicInvocationHandler.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new DynamicInvocationHandler(handlerMap));
    }
}

