/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Readline;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.FileUtil;
import com.github.jlangch.venice.util.CommandLineArgs;
import java.io.File;
import java.io.PrintStream;

public class REPL {
    private static final String PROMPT = "venice> ";

    public static void main(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        if (cli.switchPresent("-file") || cli.switchPresent("-script")) {
            REPL.exec(cli);
        } else {
            REPL.repl(args);
        }
    }

    private static void repl(String[] args) {
        VeniceInterpreter venice = new VeniceInterpreter();
        Env env = venice.createEnv(new PrintStream(System.out));
        VncList argv = new VncList(new VncVal[0]);
        for (int ii = 1; ii < args.length; ++ii) {
            argv.addAtEnd(new VncString(args[ii]));
        }
        env.set(new VncSymbol("*ARGV*"), argv);
        while (true) {
            String line;
            try {
                while ((line = Readline.readline(PROMPT)) == null) {
                }
            }
            catch (EofException e) {
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
            try {
                System.out.println("=> " + venice.PRINT(venice.RE(line, "repl", env)));
            }
            catch (ContinueException e) {
            }
            catch (ValueException e) {
                System.out.println("Error: " + Printer._pr_str(e.getValue(), false));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void exec(CommandLineArgs cli) {
        VncList argv = new VncList(new VncVal[0]);
        for (int ii = 0; ii < cli.args().length; ++ii) {
            argv.addAtEnd(new VncString(cli.args()[ii]));
        }
        if (cli.switchPresent("-file")) {
            String file = cli.switchValue("-file");
            String script = new String(FileUtil.load(new File(file)));
            VeniceInterpreter venice = new VeniceInterpreter();
            Env env = venice.createEnv(new PrintStream(System.out));
            env.set(new VncSymbol("*ARGV*"), argv);
            System.out.println(venice.PRINT(venice.RE(script, new File(file).getName(), env)));
        } else if (cli.switchPresent("-script")) {
            String script = cli.switchValue("-script");
            VeniceInterpreter venice = new VeniceInterpreter();
            Env env = venice.createEnv(new PrintStream(System.out));
            env.set(new VncSymbol("*ARGV*"), argv);
            System.out.println(venice.PRINT(venice.RE(script, "script", env)));
        }
    }
}

