/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.examples;

import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import com.github.jlangch.venice.javainterop.SandboxRules;

public class SandboxExample {
    public static void main(String[] args) {
        try {
            SandboxExample.sandboxing_strict();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            SandboxExample.sandboxing_java_calls_with_safe_venice_func();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void sandboxing_strict() {
        SandboxInterceptor interceptor = new SandboxInterceptor(new SandboxRules().rejectAllVeniceIoFunctions());
        Venice venice = new Venice(interceptor);
        venice.eval("(println 100)");
    }

    private static void sandboxing_java_calls_with_safe_venice_func() {
        SandboxInterceptor interceptor = new SandboxInterceptor(new SandboxRules().rejectAllVeniceIoFunctions().withClasses("java.lang.Long", "java.lang.Boolean", "java.lang.Math:min", "java.lang.Math:max", "java.time.ZonedDateTime:*", "java.util.ArrayList:new", "java.util.ArrayList:add"));
        Venice venice = new Venice(interceptor);
        venice.eval("(. :java.lang.Math :min 20 30)");
        venice.eval("(. :java.lang.Math :max 20 30)");
        venice.eval("(. (. :java.time.ZonedDateTime :now) :plusDays 5))");
        venice.eval("(. :java.util.ArrayList :new)");
        venice.eval("(doto (. :java.util.ArrayList :new)  \t   (. :add 1)                     \t   (. :add 2))                    ");
        venice.eval("(. :java.lang.System :exit 0)");
    }
}

