/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

public class Token {
    private final String token;
    private final String file;
    private final int line;
    private final int col;

    public Token(String token, String file, int line, int col) {
        this.token = token;
        this.file = file == null || file.isEmpty() ? "unknown" : file;
        this.line = line;
        this.col = col;
    }

    public String getToken() {
        return this.token;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public char charAt(int index) {
        return this.token.charAt(index);
    }

    public boolean equals(String str) {
        return this.token.equals(str);
    }

    public String toString() {
        return String.format("%s (file: %s, line %d, column %d)", this.token, this.file, this.line, this.col);
    }
}

