/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Numeric {
    public static VncLong toLong(VncVal val) {
        if (Types.isVncLong(val)) {
            return (VncLong)val;
        }
        if (Types.isVncDouble(val)) {
            return new VncLong(((VncDouble)val).getValue().longValue());
        }
        if (Types.isVncBigDecimal(val)) {
            return new VncLong(((VncBigDecimal)val).getValue().longValue());
        }
        throw new VncException(String.format("Cannot convert value of type %s to long. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncDouble toDouble(VncVal val) {
        if (Types.isVncLong(val)) {
            return new VncDouble(((VncLong)val).getValue().doubleValue());
        }
        if (Types.isVncDouble(val)) {
            return (VncDouble)val;
        }
        if (Types.isVncBigDecimal(val)) {
            return new VncDouble(((VncBigDecimal)val).getValue().doubleValue());
        }
        throw new VncException(String.format("Cannot convert value of type %s to double. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncBigDecimal toDecimal(VncVal val) {
        if (Types.isVncLong(val)) {
            return new VncBigDecimal(new BigDecimal(((VncLong)val).getValue()));
        }
        if (Types.isVncDouble(val)) {
            return new VncBigDecimal(new BigDecimal(((VncDouble)val).getValue()));
        }
        if (Types.isVncBigDecimal(val)) {
            return (VncBigDecimal)val;
        }
        throw new VncException(String.format("Cannot convert value of type %s to decimal. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncVal add(VncVal op1, VncVal op2) {
        return Numeric.calc('+', op1, op2);
    }

    public static VncVal sub(VncVal op1, VncVal op2) {
        return Numeric.calc('-', op1, op2);
    }

    public static VncVal mul(VncVal op1, VncVal op2) {
        return Numeric.calc('*', op1, op2);
    }

    public static VncVal div(VncVal op1, VncVal op2) {
        return Numeric.calc('/', op1, op2);
    }

    private static VncVal calc(char op, VncVal op1, VncVal op2) {
        Numeric.validateNumericTypes("" + op, op1, op2);
        if (Types.isVncLong(op1)) {
            if (Types.isVncLong(op2)) {
                return Numeric.calc(op, (VncLong)op1, (VncLong)op2);
            }
            if (Types.isVncDouble(op2)) {
                return Numeric.calc(op, Numeric.toDouble(op1), (VncDouble)op2);
            }
            if (Types.isVncBigDecimal(op2)) {
                return Numeric.calc(op, Numeric.toDecimal(op1), (VncBigDecimal)op2);
            }
        } else if (Types.isVncDouble(op1)) {
            if (Types.isVncLong(op2)) {
                return Numeric.calc(op, (VncDouble)op1, Numeric.toDouble(op2));
            }
            if (Types.isVncDouble(op2)) {
                return Numeric.calc(op, (VncDouble)op1, (VncDouble)op2);
            }
            if (Types.isVncBigDecimal(op2)) {
                return Numeric.calc(op, Numeric.toDecimal(op1), (VncBigDecimal)op2);
            }
        } else if (Types.isVncBigDecimal(op1)) {
            if (Types.isVncLong(op2)) {
                return Numeric.calc(op, (VncBigDecimal)op1, Numeric.toDecimal(op2));
            }
            if (Types.isVncDouble(op2)) {
                return Numeric.calc(op, (VncBigDecimal)op1, Numeric.toDecimal(op2));
            }
            if (Types.isVncBigDecimal(op2)) {
                return Numeric.calc(op, (VncBigDecimal)op1, (VncBigDecimal)op2);
            }
        }
        throw new RuntimeException("Unexpected outcome");
    }

    private static VncVal calc(char op, VncLong op1, VncLong op2) {
        switch (op) {
            case '+': {
                return new VncLong(op1.getValue() + op2.getValue());
            }
            case '-': {
                return new VncLong(op1.getValue() - op2.getValue());
            }
            case '*': {
                return new VncLong(op1.getValue() * op2.getValue());
            }
            case '/': {
                return new VncLong(op1.getValue() / op2.getValue());
            }
        }
        throw new RuntimeException("Invalid operation");
    }

    private static VncVal calc(char op, VncDouble op1, VncDouble op2) {
        switch (op) {
            case '+': {
                return new VncDouble(op1.getValue() + op2.getValue());
            }
            case '-': {
                return new VncDouble(op1.getValue() - op2.getValue());
            }
            case '*': {
                return new VncDouble(op1.getValue() * op2.getValue());
            }
            case '/': {
                return new VncDouble(op1.getValue() / op2.getValue());
            }
        }
        throw new RuntimeException("Invalid operation");
    }

    private static VncVal calc(char op, VncBigDecimal op1, VncBigDecimal op2) {
        switch (op) {
            case '+': {
                return new VncBigDecimal(op1.getValue().add(op2.getValue()));
            }
            case '-': {
                return new VncBigDecimal(op1.getValue().subtract(op2.getValue()));
            }
            case '*': {
                return new VncBigDecimal(op1.getValue().multiply(op2.getValue()));
            }
            case '/': {
                return new VncBigDecimal(op1.getValue().divide(op2.getValue(), 16, RoundingMode.HALF_UP));
            }
        }
        throw new RuntimeException("Invalid operation");
    }

    private static void validateNumericTypes(String fn, VncVal op1, VncVal op2) {
        if (!Types.isVncNumber(op1)) {
            throw new VncException(String.format("Function '%s' operand 1 (%s) is not a numeric type", fn, Types.getClassName(op1)));
        }
        if (!Types.isVncNumber(op2)) {
            throw new VncException(String.format("Function '%s' operand 2 (%s) is not a numeric type", fn, Types.getClassName(op2)));
        }
    }
}

