/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.Map;
import java.util.UUID;

public class SystemFunctions {
    public static VncFunction version = new VncFunction("version"){
        {
            this.setArgLists("(version)");
            this.setDoc("Returns the version.");
            this.setExamples("(version )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("version", args, 0);
            return new VncString("0.9.10");
        }
    };
    public static VncFunction uuid = new VncFunction("uuid"){
        {
            this.setArgLists("(uuid)");
            this.setDoc("Generates a UUID.");
            this.setExamples("(uuid )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("uuid", args, 0);
            return new VncString(UUID.randomUUID().toString());
        }
    };
    public static VncFunction current_time_millis = new VncFunction("current-time-millis"){
        {
            this.setArgLists("(current-time-millis)");
            this.setDoc("Returns the current time in milliseconds.");
            this.setExamples("(current-time-millis)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("current-time-millis", args, 0);
            return new VncLong(System.currentTimeMillis());
        }
    };
    public static VncFunction nano_time = new VncFunction("nano-time"){
        {
            this.setArgLists("(nano-time)");
            this.setDoc("Returns the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds.");
            this.setExamples("(nano-time)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nano-time", args, 0);
            return new VncLong(System.nanoTime());
        }
    };
    public static VncFunction sleep = new VncFunction("sleep"){
        {
            this.setArgLists("(sleep n)");
            this.setDoc("Sleep for n milliseconds.");
            this.setExamples("(sleep 30)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sleep", args, 1);
            try {
                Thread.sleep(Coerce.toVncLong(args.first()).getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Constants.Nil;
        }
    };
    public static VncFunction os = new VncFunction("os"){
        {
            this.setArgLists("(os)");
            this.setDoc("Returns the OS type");
            this.setExamples("(os)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("os", args, 0);
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                return new VncKeyword("windows");
            }
            if (osName.startsWith("Mac OS X")) {
                return new VncKeyword("mac-osx");
            }
            if (osName.startsWith("LINUX")) {
                return new VncKeyword("linux");
            }
            return new VncKeyword("unknown");
        }
    };
    public static VncFunction os_Q = new VncFunction("os?"){
        {
            this.setArgLists("(os? type)");
            this.setDoc("Returns true if the OS id of the type otherwise false. Type is one of :windows, :mac-osx, or :linux");
            this.setExamples("(os? :mac-osx)", "(os? :windows)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("os?", args, 1);
            String type = Coerce.toVncKeyword(args.first()).getValue();
            String osName = System.getProperty("os.name");
            switch (type) {
                case "windows": {
                    return osName.startsWith("Windows") ? Constants.True : Constants.False;
                }
                case "mac-osx": {
                    return osName.startsWith("Mac OS X") ? Constants.True : Constants.False;
                }
                case "linux": {
                    return osName.startsWith("LINUX") ? Constants.True : Constants.False;
                }
            }
            return Constants.False;
        }
    };
    public static VncFunction sandboxed_Q = new VncFunction("sandboxed?"){
        {
            this.setArgLists("(sandboxed? )");
            this.setDoc("Returns true if there is a sandbox otherwise false");
            this.setExamples("(sandboxed? )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sandboxed?", args, 0);
            return JavaInterop.isSandboxed() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction system_prop = new VncFunction("system-prop"){
        {
            this.setArgLists("(system-prop name default-val)");
            this.setDoc("Returns the system property with the given name. Returns the default-val if the property does not exist or it's value is nil");
            this.setExamples("(system-prop :os.name)", "(system-prop :foo.org \"abc\")", "(system-prop \"os.name\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("system-prop", args, 1, 2);
            VncString key = Coerce.toVncString((VncVal)CoreFunctions.name.apply(new VncList(args.first())));
            VncVal defaultVal = args.size() == 2 ? args.second() : Constants.Nil;
            String val = JavaInterop.getInterceptor().onReadSystemProperty(key.getValue());
            return val == null ? defaultVal : new VncString(val);
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("uuid", (VncVal)uuid).put("current-time-millis", (VncVal)current_time_millis).put("nano-time", (VncVal)nano_time).put("sandboxed?", (VncVal)sandboxed_Q).put("sleep", (VncVal)sleep).put("os", (VncVal)os).put("os?", (VncVal)os_Q).put("version", (VncVal)version).put("system-prop", (VncVal)system_prop).toMap();
}

