/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.nio.ByteBuffer;

public class VncByteBuffer
extends VncVal {
    private final ByteBuffer value;

    public VncByteBuffer(byte[] v) {
        this(ByteBuffer.wrap(v));
    }

    public VncByteBuffer(ByteBuffer v) {
        this.value = v;
    }

    @Override
    public VncByteBuffer copy() {
        VncByteBuffer v = new VncByteBuffer(this.value);
        v.setMeta(this.getMeta());
        return v;
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    public int size() {
        return this.value.capacity();
    }

    public VncList toVncList() {
        VncList list = new VncList(new VncVal[0]);
        byte[] buf = this.value.array();
        for (int ii = 0; ii < buf.length; ++ii) {
            list.addAtEnd(new VncLong(buf[ii] & 0xFF));
        }
        return list;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncByteBuffer(o)) {
            return this.getValue().compareTo(((VncByteBuffer)o).getValue());
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncByteBuffer other = (VncByteBuffer)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        byte[] arr = this.value.array();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int ii = 0; ii < 100 && ii < arr.length; ++ii) {
            if (ii > 0) {
                sb.append(" ");
            }
            sb.append((long)arr[ii] & 0xFFL);
        }
        if (arr.length > 100) {
            sb.append(" ...");
        }
        sb.append("]");
        return sb.toString();
    }
}

