/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.IInvoker;

public abstract class Interceptor
implements IInterceptor {
    @Override
    public Object onInvokeInstanceMethod(IInvoker invoker, Object receiver, String method, Object ... args) throws SecurityException {
        return invoker.callInstanceMethod(receiver, method, args);
    }

    @Override
    public Object onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        return invoker.callStaticMethod(receiver, method, args);
    }

    @Override
    public Object onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        return invoker.callConstructor(receiver, args);
    }

    @Override
    public Object onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        return invoker.getBeanProperty(receiver, property);
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        invoker.setBeanProperty(receiver, property, value);
    }

    @Override
    public Object onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        return invoker.getStaticField(receiver, fieldName);
    }

    @Override
    public Object onGetInstanceField(IInvoker invoker, Object receiver, String fieldName) throws SecurityException {
        return invoker.getInstanceField(receiver, fieldName);
    }

    @Override
    public byte[] onLoadClassPathResource(String resourceName) throws SecurityException {
        return StringUtil.isBlank(resourceName) ? null : new ClassPathResource(resourceName).getResourceAsBinary();
    }

    @Override
    public String onReadSystemProperty(String propertyName) throws SecurityException {
        return StringUtil.isBlank(propertyName) ? null : System.getProperty(propertyName);
    }

    @Override
    public void validateBlackListedVeniceFunction(String funcName, VncList args) throws SecurityException {
    }
}

