/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.ThreadPoolUtil;
import com.github.jlangch.venice.javainterop.DynamicInvocationHandler;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrencyFunctions {
    public static VncFunction deref = new VncFunction("deref"){
        {
            this.setArgLists("(deref ref)", "(deref ref timeout-ms timeout-val)");
            this.setDoc("Dereferences an atom or a Future object. When applied to an atom, returns its current state. When applied to a future, will block if computation not complete. The variant taking a timeout can be used for futures and will return timeout-val if the timeout (in milliseconds) is reached before a value is available. \nAlso reader macro: @atom/@future/@promise.");
            this.setExamples("(do                             \n   (def counter (atom 0))       \n   (deref counter))               ", "(do                             \n   (def counter (atom 0))       \n   @counter)                      ", "(do                             \n   (def task (fn [] 100))       \n   (let [f (future task)]       \n        (deref f)))               ", "(do                             \n   (def task (fn [] 100))       \n   (let [f (future task)]       \n        @f))                      ", "(do                             \n   (def task (fn [] 100))       \n   (let [f (future task)]       \n        (deref f 300 :timeout)))  ");
        }

        @Override
        public VncVal apply(VncList args) {
            Object delegate;
            FunctionsUtil.assertArity("deref", args, 1, 3);
            if (Types.isVncAtom(args.first())) {
                VncAtom atm = (VncAtom)args.first();
                return atm.deref();
            }
            if (Types.isVncJavaObject(args.first()) && (delegate = ((VncJavaObject)args.first()).getDelegate()) instanceof Future) {
                try {
                    Future future = (Future)((VncJavaObject)args.first()).getDelegate();
                    if (args.size() == 1) {
                        return JavaInteropUtil.convertToVncVal(future.get());
                    }
                    long timeout = Coerce.toVncLong(args.nth(1)).getValue();
                    try {
                        return JavaInteropUtil.convertToVncVal(future.get(timeout, TimeUnit.MILLISECONDS));
                    }
                    catch (TimeoutException ex) {
                        return args.nth(2);
                    }
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() != null && ex.getCause() instanceof SecurityException) {
                        throw (SecurityException)ex.getCause();
                    }
                }
                catch (Exception ex) {
                    throw new VncException("Failed to deref future", ex);
                }
            }
            throw new VncException(String.format("Function 'deref' does not allow type %s as parameter. %s", Types.getClassName(args.first()), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction new_atom = new VncFunction("atom"){
        {
            this.setArgLists("(atom x)");
            this.setDoc("Creates an atom with the initial value x");
            this.setExamples("(do\n   (def counter (atom 0))\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("atom", args, 1);
            return new VncAtom(args.nth(0));
        }
    };
    public static VncFunction atom_Q = new VncFunction("atom?"){
        {
            this.setArgLists("(atom? x)");
            this.setDoc("Returns true if x is an atom, otherwise false");
            this.setExamples("(do\n   (def counter (atom 0))\n   (atom? counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("atom?", args, 1);
            return Types.isVncAtom(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction reset_BANG = new VncFunction("reset!"){
        {
            this.setArgLists("(reset! atom newval)");
            this.setDoc("Sets the value of atom to newval without regard for the current value. Returns newval.");
            this.setExamples("(do\n   (def counter (atom 0))\n   (reset! counter 99)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reset!", args, 2);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.reset(args.nth(1));
        }
    };
    public static VncFunction swap_BANG = new VncFunction("swap!"){
        {
            this.setArgLists("(swap! atom f & args)");
            this.setDoc("Atomically swaps the value of atom to be: (apply f current-value-of-atom args). Note that f may be called multiple times, and thus should be free of side effects.  Returns the value that was swapped in.");
            this.setExamples("(do\n   (def counter (atom 0))\n   (swap! counter inc)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("swap!", args, 2);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            VncFunction fn = Coerce.toVncFunction(args.nth(1));
            VncList swapArgs = args.slice(2);
            return atm.swap(fn, swapArgs);
        }
    };
    public static VncFunction compare_and_set_BANG = new VncFunction("compare-and-set!"){
        {
            this.setArgLists("(compare-and-set! atom oldval newval)");
            this.setDoc("Atomically sets the value of atom to newval if and only if the current value of the atom is identical to oldval. Returns true if set happened, else false");
            this.setExamples("(do\n   (def counter (atom 2))\n   (compare-and-set! counter 2 4)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("compare-and-set!", args, 3);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.compare_and_set(args.nth(1), args.nth(2));
        }
    };
    public static VncFunction deliver = new VncFunction("deliver"){
        {
            this.setArgLists("(deliver ref value)");
            this.setDoc("Delivers the supplied value to the promise, releasing any pending derefs. A subsequent call to deliver on a promise will have no effect.");
            this.setExamples("(do                   \n   (def p (promise))  \n   (deliver p 123))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("deliver", args);
            FunctionsUtil.assertArity("deliver", args, 2);
            Object promise = Coerce.toVncJavaObject(args.first()).getDelegate();
            VncVal value = args.second();
            if (promise instanceof CompletableFuture) {
                ((CompletableFuture)promise).complete(value);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'deliver' does not allow type %s as parameter. %s", Types.getClassName(args.first()), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction promise = new VncFunction("promise"){
        {
            this.setArgLists("(promise)");
            this.setDoc("Returns a promise object that can be read with deref, and set, once only, with deliver. Calls to deref prior to delivery will block, unless the variant of deref with timeout is used. All subsequent derefs will return the same delivered value without blocking.");
            this.setExamples("(do                                        \n   (def p (promise))                       \n   (def task (fn []                        \n                 (do                       \n                    (sleep 500)            \n                    (deliver p 123))))     \n                                           \n   (future task)                           \n   (deref p))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("promise", args);
            FunctionsUtil.assertArity("promise", args, 0);
            return new VncJavaObject(new CompletableFuture());
        }
    };
    public static VncFunction promise_Q = new VncFunction("promise?"){
        {
            this.setArgLists("(promise? p)");
            this.setDoc("Returns true if f is a Promise otherwise false");
            this.setExamples("(promise? (promise)))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("promise?", args);
            FunctionsUtil.assertArity("promise?", args, 1);
            return Types.isVncJavaObject(args.first()) && ((VncJavaObject)args.first()).getDelegate() instanceof CompletableFuture ? Constants.True : Constants.False;
        }
    };
    public static VncFunction future = new VncFunction("future"){
        {
            this.setArgLists("(future fn)");
            this.setDoc("Takes a function and yields a future object that will invoke the function in another thread, and will cache the result and return it on all subsequent calls to deref. If the computation has not yet finished, calls to deref will block, unless the variant of deref with timeout is used.");
            this.setExamples("(do                                         \n   (def wait (fn [] (do (sleep 500) 100)))  \n                                            \n   (let [f (future wait)]                   \n        (deref f))                          \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future", args);
            FunctionsUtil.assertArity("future", args, 1);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            VncFunction wrapped = new VncFunction(){

                @Override
                public VncVal apply(VncList args) {
                    return new VncJavaObject(fn.apply(args));
                }
            };
            Callable task = (Callable)DynamicInvocationHandler.proxify(Callable.class, new VncHashMap(new VncKeyword("call"), wrapped));
            IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            Callable<Object> taskWrapper = () -> {
                try {
                    JavaInterop.register(parentInterceptor);
                    Object v = task.call();
                    return v;
                }
                finally {
                    ThreadLocalMap.remove();
                    JavaInterop.unregister();
                }
            };
            Future<Object> future = executor.submit(taskWrapper);
            return new VncJavaObject(future);
        }
    };
    public static VncFunction future_Q = new VncFunction("future?"){
        {
            this.setArgLists("(future? f)");
            this.setDoc("Returns true if f is a Future otherwise false");
            this.setExamples("(future? (future (fn [] 100)))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future?", args);
            FunctionsUtil.assertArity("future?", args, 1);
            return Types.isVncJavaObject(args.first()) && ((VncJavaObject)args.first()).getDelegate() instanceof Future ? Constants.True : Constants.False;
        }
    };
    public static VncFunction future_done_Q = new VncFunction("future-done?"){
        {
            this.setArgLists("(future-done? f)");
            this.setDoc("Returns true if f is a Future is done otherwise false");
            this.setExamples("(future-done? (future (fn [] 100)))");
        }

        @Override
        public VncVal apply(VncList args) {
            Object delegate;
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future-done?", args);
            FunctionsUtil.assertArity("future-done?", args, 1);
            if (Types.isVncJavaObject(args.first()) && (delegate = ((VncJavaObject)args.first()).getDelegate()) instanceof Future) {
                try {
                    Future future = (Future)((VncJavaObject)args.first()).getDelegate();
                    return future.isDone() ? Constants.True : Constants.False;
                }
                catch (Exception ex) {
                    throw new VncException("Failed to check if future is done", ex);
                }
            }
            throw new VncException(String.format("Function 'future-done?' does not allow type %s as parameter. %s", Types.getClassName(args.first()), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction future_cancel = new VncFunction("future-cancel"){
        {
            this.setArgLists("(future-cancel f)");
            this.setDoc("Cancels the future");
            this.setExamples("(future-cancel (future (fn [] 100)))");
        }

        @Override
        public VncVal apply(VncList args) {
            Object delegate;
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future-cancel", args);
            FunctionsUtil.assertArity("future-cancel", args, 1);
            if (Types.isVncJavaObject(args.first()) && (delegate = ((VncJavaObject)args.first()).getDelegate()) instanceof Future) {
                try {
                    Future future = (Future)((VncJavaObject)args.first()).getDelegate();
                    future.cancel(true);
                    return args.first();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to cancel future", ex);
                }
            }
            throw new VncException(String.format("Function 'future-cancel' does not allow type %s as parameter. %s", Types.getClassName(args.first()), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction future_cancelled_Q = new VncFunction("future-cancelled?"){
        {
            this.setArgLists("(future-cancelled? f)");
            this.setDoc("Returns true if f is a Future is cancelled otherwise false");
            this.setExamples("(future-cancelled? (future (fn [] 100)))");
        }

        @Override
        public VncVal apply(VncList args) {
            Object delegate;
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future-cancelled?", args);
            FunctionsUtil.assertArity("future-cancelled?", args, 1);
            if (Types.isVncJavaObject(args.first()) && (delegate = ((VncJavaObject)args.first()).getDelegate()) instanceof Future) {
                try {
                    Future future = (Future)((VncJavaObject)args.first()).getDelegate();
                    return future.isCancelled() ? Constants.True : Constants.False;
                }
                catch (Exception ex) {
                    throw new VncException("Failed to check if future is cancelled", ex);
                }
            }
            throw new VncException(String.format("Function 'future-cancelled?' does not allow type %s as parameter. %s", Types.getClassName(args.first()), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction new_thread_local = new VncFunction("thread-local"){
        {
            this.setArgLists("(thread-local)");
            this.setDoc("Creates a new thread-local accessor");
            this.setExamples("(thread-local :a 1 :b 2)", "(thread-local { :a 1 :b 2 })", "(do \n   (thread-local-clear) \n   (assoc (thread-local) :a 1 :b 2) \n   (dissoc (thread-local) :a) \n   (get (thread-local) :b 100) \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncThreadLocal(((VncMap)args.nth(0)).getMap());
            }
            return new VncThreadLocal(args);
        }
    };
    public static VncFunction thread_local_Q = new VncFunction("thread-local?"){
        {
            this.setArgLists("(thread-local? x)");
            this.setDoc("Returns true if x is a thread-local, otherwise false");
            this.setExamples("(do\n   (def x (thread-local))\n   (thread-local? x))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local?", args, 1);
            return Types.isVncThreadLocal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction thread_local_clear = new VncFunction("thread-local-clear"){
        {
            this.setArgLists("(thread-local-clear)");
            this.setDoc("Removes all thread local vars");
            this.setExamples("(thread-local-clear)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local-clear", args, 0);
            new VncThreadLocal().clear();
            return this;
        }
    };
    public static VncFunction thread_id = new VncFunction("thread-id"){
        {
            this.setArgLists("(thread-id)");
            this.setDoc("Returns the identifier of this Thread. The thread ID is a positive number generated when this thread was created. The thread ID  is unique and remains unchanged during its lifetime. When a thread is terminated, this thread ID may be reused.");
            this.setExamples("(thread-id)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-id", args, 0);
            return new VncLong(Thread.currentThread().getId());
        }
    };
    public static VncFunction thread_name = new VncFunction("thread-name"){
        {
            this.setArgLists("(thread-name)");
            this.setDoc("Returns this thread's name.");
            this.setExamples("(thread-name)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-name", args, 0);
            return new VncString(Thread.currentThread().getName());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("deref", (VncVal)deref).put("atom", (VncVal)new_atom).put("atom?", (VncVal)atom_Q).put("reset!", (VncVal)reset_BANG).put("swap!", (VncVal)swap_BANG).put("compare-and-set!", (VncVal)compare_and_set_BANG).put("promise", (VncVal)promise).put("promise?", (VncVal)promise_Q).put("deliver", (VncVal)deliver).put("future", (VncVal)future).put("future?", (VncVal)future_Q).put("future-done?", (VncVal)future_done_Q).put("future-cancel", (VncVal)future_cancel).put("future-cancelled?", (VncVal)future_cancelled_Q).put("thread-id", (VncVal)thread_id).put("thread-name", (VncVal)thread_name).put("thread-local", (VncVal)new_thread_local).put("thread-local?", (VncVal)thread_local_Q).put("thread-local-clear", (VncVal)thread_local_clear).toMap();
    private static final AtomicLong futureThreadPoolCounter = new AtomicLong(0L);
    private static final ExecutorService executor = Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory("venice-future-pool-%d", futureThreadPoolCounter, true));

    public static void shutdown() {
        executor.shutdown();
    }

    public static void shutdownNow() {
        executor.shutdownNow();
    }
}

