/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.IOStreamUtil;
import com.github.jlangch.venice.impl.util.MimeTypes;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class IOFunctions {
    public static VncFunction io_file = new VncFunction("io/file"){
        {
            this.setArgLists("(io/file path) (io/file parent child)");
            this.setDoc("Returns a java.io.File. path, parent, and child can be a string or java.io.File");
            this.setExamples("(io/file \"/temp/test.txt\")", "(io/file \"/temp\" \"test.txt\")", "(io/file (io/file \"/temp\") \"test.txt\")");
        }

        @Override
        public VncVal apply(VncList args) {
            File parentFile;
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/file", args);
            FunctionsUtil.assertArity("io/file", args, 1, 2);
            if (args.size() == 1) {
                VncVal path = args.nth(0);
                if (Types.isVncString(path)) {
                    return new VncJavaObject(new File(((VncString)path).getValue()));
                }
                if (FunctionsUtil.isJavaIoFile(path)) {
                    return path;
                }
                throw new VncException(String.format("Function 'io/file' does not allow %s as path. %s", Types.getClassName(path), ErrorMessage.buildErrLocation(args)));
            }
            VncVal parent = args.nth(0);
            VncVal child = args.nth(1);
            if (Types.isVncString(parent)) {
                parentFile = new File(((VncString)parent).getValue());
            } else if (FunctionsUtil.isJavaIoFile(parent)) {
                parentFile = (File)((VncJavaObject)parent).getDelegate();
            } else {
                throw new VncException(String.format("Function 'io/file' does not allow %s as parent. %s", Types.getClassName(parent), ErrorMessage.buildErrLocation(args)));
            }
            if (Types.isVncString(child)) {
                return new VncJavaObject(new File(parentFile, ((VncString)child).getValue()));
            }
            throw new VncException(String.format("Function 'io/file' does not allow %s as child. %s", Types.getClassName(child), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction io_file_size = new VncFunction("io/file-size"){
        {
            this.setArgLists("(io/file-size f)");
            this.setDoc("Returns the size of the file f. f must be a java.io.File.");
            this.setExamples("(io/file-size (io/file \"/bin/sh\"))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/file-size", args);
            FunctionsUtil.assertArity("io/file-size", args, 1);
            if (!FunctionsUtil.isJavaIoFile(args.first())) {
                throw new VncException(String.format("Function 'io/file-size' does not allow %s as f. %s", Types.getClassName(args.first()), ErrorMessage.buildErrLocation(args)));
            }
            File file = (File)((VncJavaObject)args.first()).getDelegate();
            return new VncLong(file.length());
        }
    };
    public static VncFunction io_file_Q = new VncFunction("io/file?"){
        {
            this.setArgLists("(io/file? x)");
            this.setDoc("Returns true if x is a java.io.File.");
            this.setExamples("(io/file? (io/file \"/temp/test.txt\"))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/file?", args);
            FunctionsUtil.assertArity("io/file?", args, 1);
            VncVal path = args.nth(0);
            return FunctionsUtil.isJavaIoFile(path) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction io_exists_file_Q = new VncFunction("io/exists-file?"){
        {
            this.setArgLists("(io/exists-file? x)");
            this.setDoc("Returns true if the file x exists. x must be a java.io.File.");
            this.setExamples("(io/exists-file? (io/file \"/temp/test.txt\"))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/exists-file?", args);
            FunctionsUtil.assertArity("io/exists-file?", args, 1);
            if (!FunctionsUtil.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/exists-file?' does not allow %s as x. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            File file = (File)((VncJavaObject)args.nth(0)).getDelegate();
            return file.isFile() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction io_exists_dir_Q = new VncFunction("io/exists-dir?"){
        {
            this.setArgLists("(io/exists-dir? x)");
            this.setDoc("Returns true if the file x exists and is a directory. x must be a java.io.File.");
            this.setExamples("(io/exists-dir? (io/file \"/temp\"))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/exists-dir?", args);
            FunctionsUtil.assertArity("io/exists-dir?", args, 1);
            if (!FunctionsUtil.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/exists-dir?' does not allow %s as x. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            File file = (File)((VncJavaObject)args.nth(0)).getDelegate();
            return file.isDirectory() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction io_delete_file = new VncFunction("io/delete-file"){
        {
            this.setArgLists("(io/delete-file f & files)");
            this.setDoc("Deletes one or multiple files. f must be a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/delete-file", args);
            FunctionsUtil.assertMinArity("io/delete-file", args, 1);
            args.forEach(f -> {
                if (!FunctionsUtil.isJavaIoFile(f)) {
                    throw new VncException(String.format("Function 'io/delete-file' does not allow %s as f. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
                }
                File file = (File)((VncJavaObject)f).getDelegate();
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to delete file %s", file.getPath()), ex);
                }
            });
            return Constants.Nil;
        }
    };
    public static VncFunction io_delete_file_on_exit = new VncFunction("io/delete-file-on-exit"){
        {
            this.setArgLists("(io/delete-file-on-exit x)");
            this.setDoc("Deletes a file on JVM exit. x must be a string or java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            File file;
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/delete-file-on-exit", args);
            FunctionsUtil.assertArity("io/delete-file-on-exit", args, 1);
            if (Types.isVncString(args.nth(0))) {
                file = new File(((VncString)args.nth(0)).getValue());
            } else if (FunctionsUtil.isJavaIoFile(args.nth(0))) {
                file = (File)((VncJavaObject)args.nth(0)).getDelegate();
            } else {
                throw new VncException(String.format("Function 'io/delete-file-on-exit' does not allow %s as x. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            try {
                file.deleteOnExit();
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to marke file %s to delete on exit", file.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_list_files = new VncFunction("io/list-files"){
        {
            this.setArgLists("(io/list-files dir filterFn?)");
            this.setDoc("Lists files in a directory. dir must be a java.io.File. filterFn is an optional filter that filters the files found");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/list-files", args);
            FunctionsUtil.assertArity("io/list-files", args, 1, 2);
            if (!FunctionsUtil.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/list-files' does not allow %s as x. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            File file = (File)((VncJavaObject)args.nth(0)).getDelegate();
            try {
                VncFunction filterFn = args.size() == 2 ? Coerce.toVncFunction(args.nth(1)) : null;
                VncList files = new VncList(new VncVal[0]);
                for (File f : file.listFiles()) {
                    VncConstant result;
                    VncVal vncVal = result = filterFn == null ? Constants.True : (VncVal)filterFn.apply(new VncList(new VncJavaObject(f)));
                    if (result != Constants.True) continue;
                    files.addAtEnd(new VncJavaObject(f));
                }
                return files;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files %s. %s", file.getPath(), ErrorMessage.buildErrLocation(args)), ex);
            }
        }
    };
    public static VncFunction io_copy_file = new VncFunction("io/copy-file"){
        {
            this.setArgLists("(io/copy-file input output)");
            this.setDoc("Copies input to output. Returns nil or throws IOException. Input and output must be a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/copy-file", args);
            FunctionsUtil.assertArity("io/copy-file", args, 2);
            if (!FunctionsUtil.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/copy-file' does not allow %s as input. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!FunctionsUtil.isJavaIoFile(args.nth(1))) {
                throw new VncException(String.format("Function 'io/copy-file' does not allow %s as output. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            File from = (File)((VncJavaObject)args.nth(0)).getDelegate();
            File to = (File)((VncJavaObject)args.nth(1)).getDelegate();
            try {
                Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to copy file %s to %s. %s", from.getPath(), to.getPath(), ErrorMessage.buildErrLocation(args)), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_move_file = new VncFunction("io/move-file"){
        {
            this.setArgLists("(io/move-file source target)");
            this.setDoc("Moves source to target. Returns nil or throws IOException. Source and target must be a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/move-file", args);
            FunctionsUtil.assertArity("io/move-file", args, 2);
            if (!FunctionsUtil.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/move-file' does not allow %s as source. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!FunctionsUtil.isJavaIoFile(args.nth(1))) {
                throw new VncException(String.format("Function 'io/move-file' does not allow %s as target. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            File from = (File)((VncJavaObject)args.nth(0)).getDelegate();
            File to = (File)((VncJavaObject)args.nth(1)).getDelegate();
            try {
                Files.move(from.toPath(), to.toPath(), new CopyOption[0]);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to move file %s to %s. %s", from.getPath(), to.getPath(), ErrorMessage.buildErrLocation(args)), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_tmp_dir = new VncFunction("io/tmp-dir"){
        {
            this.setArgLists("(io/tmp-dir)");
            this.setDoc("Returns the tmp dir as a java.io.File.");
            this.setExamples("(io/tmp-dir )");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/tmp-dir", args);
            FunctionsUtil.assertArity("io/tmp-dir", args, 0);
            return new VncJavaObject(new File(System.getProperty("java.io.tmpdir")));
        }
    };
    public static VncFunction io_user_dir = new VncFunction("io/user-dir"){
        {
            this.setArgLists("(io/user-dir)");
            this.setDoc("Returns the user dir (current working dir) as a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/user-dir", args);
            FunctionsUtil.assertArity("io/user-dir", args, 0);
            return new VncJavaObject(new File(System.getProperty("user.dir")));
        }
    };
    public static VncFunction io_slurp = new VncFunction("io/slurp"){
        {
            this.setArgLists("(io/slurp file & options)");
            this.setDoc("Returns the file's content as text (string) or binary (bytebuf). \nDefaults to binary=false and encoding=UTF-8. \nOptions: :encoding \"UTF-8\" :binary true/false.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/slurp", args);
            FunctionsUtil.assertMinArity("io/slurp", args, 1);
            try {
                File file;
                if (Types.isVncString(args.nth(0))) {
                    file = new File(((VncString)args.nth(0)).getValue());
                } else if (FunctionsUtil.isJavaIoFile(args.nth(0))) {
                    file = (File)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                } else {
                    throw new VncException(String.format("Function 'io/slurp' does not allow %s as f. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
                }
                VncHashMap options = new VncHashMap(args.slice(1));
                VncVal binary = options.get(new VncKeyword("binary"));
                if (binary == Constants.True) {
                    byte[] data = Files.readAllBytes(file.toPath());
                    return new VncByteBuffer(ByteBuffer.wrap(data));
                }
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String encoding = encVal == Constants.Nil ? "UTF-8" : Coerce.toVncString(encVal).getValue();
                byte[] data = Files.readAllBytes(file.toPath());
                return new VncString(new String(data, encoding));
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_spit = new VncFunction("io/spit"){
        {
            this.setArgLists("(io/spit f content & options)");
            this.setDoc("Opens f, writes content, and then closes f. \nOptions default to append=true and encoding=UTF-8. \nOptions: :append true/false, :encoding \"UTF-8\"");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/spit", args);
            FunctionsUtil.assertMinArity("io/spit", args, 2);
            try {
                byte[] data;
                String encoding;
                File file;
                if (Types.isVncString(args.nth(0))) {
                    file = new File(((VncString)args.nth(0)).getValue());
                } else if (FunctionsUtil.isJavaIoFile(args.nth(0))) {
                    file = (File)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                } else {
                    throw new VncException(String.format("Function 'io/spit' does not allow %s as f. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
                }
                VncVal content = args.nth(1);
                VncHashMap options = new VncHashMap(args.slice(2));
                VncVal append = options.get(new VncKeyword("append"));
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String string = encoding = encVal == Constants.Nil ? "UTF-8" : ((VncString)encVal).getValue();
                if (Types.isVncString(content)) {
                    data = ((VncString)content).getValue().getBytes(encoding);
                } else if (Types.isVncByteBuffer(content)) {
                    data = ((VncByteBuffer)content).getValue().array();
                } else {
                    throw new VncException(String.format("Function 'io/spit' does not allow %s as content. %s", Types.getClassName(content), ErrorMessage.buildErrLocation(args)));
                }
                ArrayList<StandardOpenOption> openOptions = new ArrayList<StandardOpenOption>();
                openOptions.add(StandardOpenOption.CREATE);
                openOptions.add(StandardOpenOption.WRITE);
                if (append != Constants.False) {
                    openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                }
                Files.write(file.toPath(), data, openOptions.toArray(new OpenOption[0]));
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_slurp_stream = new VncFunction("io/slurp-stream"){
        {
            this.setArgLists("(io/slurp-stream is & options)");
            this.setDoc("Slurps binary or string data from an input stream. Supports the option :binary to either slurp binary or string data. For string data an optional encoding can be specified.\nOptions: :encoding \"UTF-8\" :binary true/false. ");
            this.setExamples("(do \n   (import :java.io.FileInputStream) \n   (let [file (io/temp-file \"test-\", \".txt\")] \n        (io/delete-file-on-exit file) \n        (io/spit file \"123456789\" :append true) \n        (try-with [is (. :FileInputStream :new file)] \n           (io/slurp-stream is :binary false))) \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/slurp-stream", args);
            FunctionsUtil.assertMinArity("io/slurp-stream", args, 1);
            try {
                InputStream is = (InputStream)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                VncHashMap options = new VncHashMap(args.slice(1));
                VncVal binary = options.get(new VncKeyword("binary"));
                if (binary == Constants.True) {
                    byte[] data = IOStreamUtil.copyIStoByteArray(is);
                    return data == null ? Constants.Nil : new VncByteBuffer(ByteBuffer.wrap(data));
                }
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String encoding = encVal == Constants.Nil ? "UTF-8" : Coerce.toVncString(encVal).getValue();
                return new VncString(IOStreamUtil.copyIStoString(is, encoding));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_spit_stream = new VncFunction("spit-stream"){
        {
            this.setArgLists("(io/spit-stream os content & options)");
            this.setDoc("Writes content (string or bytebuf) to the output stream os. If content is of type string an optional encoding (defaults to UTF-8) is supported. The stream can optionally be flushed after the operation.\nOptions: :flush true/false :encoding \"UTF-8\"");
            this.setExamples("(do \n   (import :java.io.FileOutputStream) \n   (let [file (io/temp-file \"test-\", \".txt\")] \n        (io/delete-file-on-exit file) \n        (try-with [os (. :FileOutputStream :new file)] \n           (io/spit-stream os \"123456789\" :flush true))) \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/spit-stream", args);
            FunctionsUtil.assertMinArity("io/spit-stream", args, 2);
            try {
                byte[] data;
                boolean flush;
                OutputStream os = (OutputStream)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                VncVal content = args.nth(1);
                VncHashMap options = new VncHashMap(args.slice(2));
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String encoding = encVal == Constants.Nil ? "UTF-8" : ((VncString)encVal).getValue();
                VncVal flushVal = options.get(new VncKeyword("flush"));
                boolean bl = flush = flushVal == Constants.True;
                if (Types.isVncString(content)) {
                    data = ((VncString)content).getValue().getBytes(encoding);
                } else if (Types.isVncByteBuffer(content)) {
                    data = ((VncByteBuffer)content).getValue().array();
                } else {
                    throw new VncException(String.format("Function 'spit-stream' does not allow %s as content. %s", Types.getClassName(content), ErrorMessage.buildErrLocation(args)));
                }
                os.write(data);
                if (flush) {
                    os.flush();
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_mime_type = new VncFunction("io/mime-type"){
        {
            this.setArgLists("(io/mime-type file)");
            this.setDoc("Returns the mime-type for the file if available else nil");
            this.setExamples("(io/mime-type \"document.pdf\")", "(io/mime-type (io/file \"document.pdf\"))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/mime-type", args);
            FunctionsUtil.assertMinArity("io/mime-type", args, 1);
            if (Types.isVncString(args.first())) {
                return new VncString(MimeTypes.getMimeTypeFromFileName(((VncString)args.first()).getValue()));
            }
            if (FunctionsUtil.isJavaIoFile(args.first())) {
                return new VncString(MimeTypes.getMimeTypeFromFile((File)Coerce.toVncJavaObject(args.first()).getDelegate()));
            }
            throw new VncException(String.format("Function 'io/mime-type' does not allow %s as f. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction io_temp_file = new VncFunction("io/temp-file"){
        {
            this.setArgLists("(io/temp-file prefix suffix)");
            this.setDoc("Creates an empty temp file with prefix and suffix. \nio/temp-file with its companions io/spit-temp-file and io/slurp-temp-file provide safe file access in sandboxed environments.");
            this.setExamples("(do \n   (let [file (io/temp-file \"test-\", \".txt\")] \n        (io/spit-temp-file file \"123456789\" :append true) \n        (io/slurp-temp-file file :binary false :remove true)) \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/temp-file", args);
            FunctionsUtil.assertArity("io/temp-file", args, 2);
            String prefix = Coerce.toVncString(args.first()).getValue();
            String suffix = Coerce.toVncString(args.second()).getValue();
            try {
                String path = File.createTempFile(prefix, suffix).getPath();
                tempFiles.add(path);
                return new VncString(path);
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_slurp_temp_file = new VncFunction("io/slurp-temp-file"){
        {
            this.setArgLists("(io/slurp-temp-file file & options)");
            this.setDoc("Slurps binary or string data from a previously created temp file. Supports the option :binary to either slurp binary or string data. For string data an optional encoding can be specified. \nEnsures that the caller can only read back files he previously created, but no other files. This allows callers to work with files without escaping the sandbox. The file must have been created with io/temp_file. \nOptions: :encoding \"UTF-8\" :binary true/false.");
            this.setExamples("(do \n   (let [file (io/temp-file \"test-\", \".txt\")] \n        (io/spit-temp-file file \"123456789\" :append true) \n        (io/slurp-temp-file file :binary false :remove true)) \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/slurp-temp-file", args);
            FunctionsUtil.assertMinArity("io/slurp-temp-file", args, 1);
            try {
                File file;
                if (Types.isVncString(args.nth(0))) {
                    file = new File(((VncString)args.nth(0)).getValue());
                } else if (FunctionsUtil.isJavaIoFile(args.nth(0))) {
                    file = (File)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                } else {
                    throw new VncException(String.format("Function 'io/slurp-temp-file' does not allow %s as f. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
                }
                if (!tempFiles.contains(file.getPath())) {
                    throw new VncException(String.format("Function 'io/slurp-temp-file' tries to access the unknown temp file '%s'. %s", file.getPath(), ErrorMessage.buildErrLocation(args)));
                }
                VncHashMap options = new VncHashMap(args.slice(1));
                VncVal binary = options.get(new VncKeyword("binary"));
                VncVal remove = options.get(new VncKeyword("remove"));
                if (binary == Constants.True) {
                    byte[] data = Files.readAllBytes(file.toPath());
                    if (remove == Constants.True) {
                        file.delete();
                        tempFiles.remove(file.getPath());
                    }
                    return new VncByteBuffer(ByteBuffer.wrap(data));
                }
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String encoding = encVal == Constants.Nil ? "UTF-8" : Coerce.toVncString(encVal).getValue();
                byte[] data = Files.readAllBytes(file.toPath());
                if (remove == Constants.True) {
                    file.delete();
                    tempFiles.remove(file.getPath());
                }
                return new VncString(new String(data, encoding));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_spit_temp_file = new VncFunction("io/spit-temp-file"){
        {
            this.setArgLists("(io/spit-temp-file f content & options)");
            this.setDoc("Spits binary or string data from to previously created temp file. \nEnsures that the caller can only write to files he previously created, but no other files. This allows callers to work with files without escaping the sandbox. The file must have been created with io/temp_file. \nDefaults to append=true and encoding=UTF-8.\nOptions: :append true/false, :encoding \"UTF-8\"");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/spit-temp-file", args);
            FunctionsUtil.assertMinArity("io/spit-temp-file", args, 2);
            try {
                byte[] data;
                String encoding;
                File file;
                if (Types.isVncString(args.nth(0))) {
                    file = new File(((VncString)args.nth(0)).getValue());
                } else if (FunctionsUtil.isJavaIoFile(args.nth(0))) {
                    file = (File)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                } else {
                    throw new VncException(String.format("Function 'io/spit-temp-file' does not allow %s as f. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
                }
                if (!tempFiles.contains(file.getPath())) {
                    throw new VncException(String.format("Function 'io/spit-temp-file' tries to access the unknown temp file '%s'. %s", file.getPath(), ErrorMessage.buildErrLocation(args)));
                }
                VncVal content = args.nth(1);
                VncHashMap options = new VncHashMap(args.slice(2));
                VncVal append = options.get(new VncKeyword("append"));
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String string = encoding = encVal == Constants.Nil ? "UTF-8" : ((VncString)encVal).getValue();
                if (Types.isVncString(content)) {
                    data = ((VncString)content).getValue().getBytes(encoding);
                } else if (Types.isVncByteBuffer(content)) {
                    data = ((VncByteBuffer)content).getValue().array();
                } else {
                    throw new VncException(String.format("Function 'io/spit-temp-file' does not allow %s as content. %s", Types.getClassName(content), ErrorMessage.buildErrLocation(args)));
                }
                ArrayList<StandardOpenOption> openOptions = new ArrayList<StandardOpenOption>();
                openOptions.add(StandardOpenOption.CREATE);
                openOptions.add(StandardOpenOption.WRITE);
                if (append != Constants.False) {
                    openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                }
                Files.write(file.toPath(), data, openOptions.toArray(new OpenOption[0]));
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_load_classpath_resource = new VncFunction("io/load-classpath-resource"){
        {
            this.setArgLists("(io/load-classpath-resource name)");
            this.setDoc("Loads a classpath resource.");
        }

        @Override
        public VncVal apply(VncList args) {
            try {
                JavaInterop.getInterceptor().validateBlackListedVeniceFunction("io/load-classpath-resource", args);
                FunctionsUtil.assertArity("io/load-classpath-resource", args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String res = ((VncString)args.first()).getValue();
                    byte[] data = JavaInterop.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                if (Types.isVncKeyword(name)) {
                    String res = ((VncKeyword)args.first()).getValue();
                    byte[] data = JavaInterop.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                if (Types.isVncSymbol(name)) {
                    String res = ((VncSymbol)args.first()).getName();
                    byte[] data = JavaInterop.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("io/file", (VncVal)io_file).put("io/file?", (VncVal)io_file_Q).put("io/file-size", (VncVal)io_file_size).put("io/exists-file?", (VncVal)io_exists_file_Q).put("io/exists-dir?", (VncVal)io_exists_dir_Q).put("io/list-files", (VncVal)io_list_files).put("io/delete-file", (VncVal)io_delete_file).put("io/delete-file-on-exit", (VncVal)io_delete_file_on_exit).put("io/copy-file", (VncVal)io_copy_file).put("io/move-file", (VncVal)io_move_file).put("io/temp-file", (VncVal)io_temp_file).put("io/tmp-dir", (VncVal)io_tmp_dir).put("io/user-dir", (VncVal)io_user_dir).put("io/slurp", (VncVal)io_slurp).put("io/spit", (VncVal)io_spit).put("io/spit-temp-file", (VncVal)io_spit_temp_file).put("io/slurp-temp-file", (VncVal)io_slurp_temp_file).put("io/slurp-stream", (VncVal)io_slurp_stream).put("io/spit-stream", (VncVal)io_spit_stream).put("io/mime-type", (VncVal)io_mime_type).put("io/load-classpath-resource", (VncVal)io_load_classpath_resource).toMap();
    private static final HashSet<String> tempFiles = new HashSet();
}

