/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.JavaMethodInvocationException;
import com.github.jlangch.venice.impl.javainterop.Invoker;
import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.impl.util.reflect.ReflectionTypes;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaInteropUtil {
    public static VncVal applyJavaAccess(VncList args, JavaImports javaImports) {
        try {
            Object target;
            VncVal arg0 = args.nth(0);
            VncString method = (VncString)args.nth(1);
            VncList params = args.slice(2);
            String methodName = method.getValue();
            Object[] methodArgs = new Object[params.size()];
            for (int ii = 0; ii < params.size(); ++ii) {
                methodArgs[ii] = JavaInteropUtil.convertToJavaObject(params.nth(ii));
            }
            if ("new".equals(methodName)) {
                String className = javaImports.resolveClassName(((VncString)arg0).getValue());
                Class<?> targetClass = ReflectionAccessor.classForName(className);
                return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onInvokeConstructor(new Invoker(), targetClass, methodArgs));
            }
            if ("class".equals(methodName)) {
                if (arg0 instanceof VncString) {
                    String className = javaImports.resolveClassName(((VncString)arg0).getValue());
                    try {
                        return new VncJavaObject(ReflectionAccessor.classForName(className));
                    }
                    catch (Exception ex) {
                        return Constants.Nil;
                    }
                }
                if (arg0 instanceof VncJavaObject) {
                    return new VncJavaObject(((VncJavaObject)arg0).getDelegate().getClass());
                }
                return new VncJavaObject(Types.getClassName(arg0));
            }
            if (arg0 instanceof VncString) {
                String className = javaImports.resolveClassName(((VncString)arg0).getValue());
                Class<?> targetClass = ReflectionAccessor.classForName(className);
                if (methodArgs.length > 0 || ReflectionAccessor.isStaticMethod(targetClass, methodName, methodArgs)) {
                    return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onInvokeStaticMethod(new Invoker(), targetClass, methodName, methodArgs));
                }
                if (ReflectionAccessor.isStaticField(targetClass, methodName)) {
                    return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onGetStaticField(new Invoker(), targetClass, methodName));
                }
                throw new JavaMethodInvocationException(String.format("No matching public static method or field found: '%s' for target '%s'", methodName, targetClass));
            }
            Object object = target = arg0 instanceof VncJavaObject ? ((VncJavaObject)arg0).getDelegate() : JavaInteropUtil.convertToJavaObject(arg0);
            if (methodArgs.length > 0 || ReflectionAccessor.isInstanceMethod(target, methodName, methodArgs)) {
                return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onInvokeInstanceMethod(new Invoker(), target, methodName, methodArgs));
            }
            if (ReflectionAccessor.isInstanceField(target, methodName)) {
                return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onGetInstanceField(new Invoker(), target, methodName));
            }
            throw new JavaMethodInvocationException(String.format("No matching public instance method or field found: '%s' for target '%s'", methodName, target.getClass()));
        }
        catch (JavaMethodInvocationException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof SecurityException) {
                throw new SecurityException(String.format("%s. %s", ex.getMessage(), ErrorMessage.buildErrLocation(args)));
            }
            throw new JavaMethodInvocationException(String.format("%s. %s", ex.getMessage(), ErrorMessage.buildErrLocation(args)), ex);
        }
        catch (SecurityException ex) {
            throw new SecurityException(String.format("%s. %s", ex.getMessage(), ErrorMessage.buildErrLocation(args)));
        }
        catch (RuntimeException ex) {
            throw new JavaMethodInvocationException(String.format("JavaInterop failure. %s", ErrorMessage.buildErrLocation(args)));
        }
    }

    public static Object convertToJavaObject(VncVal value) {
        if (value instanceof VncConstant) {
            if ((VncConstant)value == Constants.Nil) {
                return null;
            }
            if ((VncConstant)value == Constants.True) {
                return Boolean.TRUE;
            }
            if ((VncConstant)value == Constants.False) {
                return Boolean.FALSE;
            }
        } else {
            if (value instanceof IVncJavaObject) {
                return ((IVncJavaObject)((Object)value)).getDelegate();
            }
            if (Types.isVncKeyword(value)) {
                return ((VncKeyword)value).getValue();
            }
            if (Types.isVncSymbol(value)) {
                return ((VncSymbol)value).getName();
            }
            if (Types.isVncString(value)) {
                return ((VncString)value).getValue();
            }
            if (Types.isVncLong(value)) {
                return ((VncLong)value).getValue();
            }
            if (Types.isVncDouble(value)) {
                return ((VncDouble)value).getValue();
            }
            if (Types.isVncBigDecimal(value)) {
                return ((VncBigDecimal)value).getValue();
            }
            if (Types.isVncByteBuffer(value)) {
                return ((VncByteBuffer)value).getValue();
            }
            if (Types.isVncVector(value)) {
                return ((VncVector)value).getList().stream().map(v -> JavaInteropUtil.convertToJavaObject(v)).filter(v -> v != null).collect(Collectors.toList());
            }
            if (Types.isVncList(value)) {
                return ((VncList)value).getList().stream().map(v -> JavaInteropUtil.convertToJavaObject(v)).filter(v -> v != null).collect(Collectors.toList());
            }
            if (Types.isVncSet(value)) {
                return ((VncSet)value).getList().stream().map(v -> JavaInteropUtil.convertToJavaObject(v)).filter(v -> v != null).collect(Collectors.toSet());
            }
            if (Types.isVncMap(value)) {
                return ((VncMap)value).entries().stream().collect(Collectors.toMap(e -> JavaInteropUtil.convertToJavaObject((VncVal)e.getKey()), e -> JavaInteropUtil.convertToJavaObject((VncVal)e.getValue())));
            }
        }
        return null;
    }

    public static VncVal convertToVncVal(Object value) {
        if (value == null) {
            return Constants.Nil;
        }
        if (value instanceof VncVal) {
            return (VncVal)value;
        }
        if (value instanceof Class) {
            return new VncString(((Class)value).getName());
        }
        if (value instanceof String) {
            return new VncString((String)value);
        }
        if (value instanceof Byte) {
            return null;
        }
        if (value instanceof Short) {
            return new VncLong(((Short)value).longValue());
        }
        if (value instanceof Integer) {
            return new VncLong(((Integer)value).longValue());
        }
        if (value instanceof Long) {
            return new VncLong((Long)value);
        }
        if (value instanceof Float) {
            return new VncDouble((Float)value);
        }
        if (value instanceof Double) {
            return new VncDouble((Double)value);
        }
        if (value instanceof BigDecimal) {
            return new VncBigDecimal((BigDecimal)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Constants.True : Constants.False;
        }
        if (ReflectionTypes.isEnumType(value.getClass())) {
            return new VncString(value.toString());
        }
        if (value instanceof ByteBuffer) {
            return new VncByteBuffer((ByteBuffer)value);
        }
        if (value instanceof List) {
            return new VncJavaList((List)value);
        }
        if (value instanceof Set) {
            return new VncJavaSet((Set)value);
        }
        if (value instanceof Map) {
            return new VncJavaMap((Map)value);
        }
        if (ReflectionTypes.isArrayType(value.getClass())) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType == Byte.TYPE) {
                return new VncByteBuffer(ByteBuffer.wrap((byte[])value));
            }
            VncVector vec = new VncVector(new VncVal[0]);
            for (int ii = 0; ii < Array.getLength(value); ++ii) {
                vec.addAtEnd(JavaInteropUtil.convertToVncVal(Array.get(value, ii)));
            }
            return vec;
        }
        return new VncJavaObject(value);
    }
}

