/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncVal;

public class VncDouble
extends VncVal {
    private final Double value;

    public VncDouble(Double v) {
        this.value = v;
    }

    public VncDouble(Float v) {
        this.value = v.doubleValue();
    }

    @Override
    public VncDouble copy() {
        VncDouble v = new VncDouble(this.value);
        v.setMeta(this.getMeta());
        return v;
    }

    public Double getValue() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncNumber(o)) {
            return this.value.compareTo(Numeric.toDouble(o).getValue());
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncDouble other = (VncDouble)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

