/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncVal;

public class VncLong
extends VncVal {
    private final Long value;

    public VncLong(Long v) {
        this.value = v;
    }

    public VncLong(Integer v) {
        this.value = v.longValue();
    }

    @Override
    public VncLong copy() {
        VncLong v = new VncLong(this.value);
        v.setMeta(this.getMeta());
        return v;
    }

    public Long getValue() {
        return this.value;
    }

    public Integer getIntValue() {
        return this.value.intValue();
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncNumber(o)) {
            return this.value.compareTo(Numeric.toLong(o).getValue());
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncLong other = (VncLong)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

