/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class VncList
extends VncSequence {
    private final ArrayList<VncVal> value;

    public VncList(List<VncVal> val) {
        this.value = new ArrayList<VncVal>(val);
    }

    public VncList(VncVal ... mvs) {
        this.value = new ArrayList<VncVal>(Arrays.asList(mvs));
    }

    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super E v) -> action.accept((VncVal)v));
    }

    @Override
    public VncList copy() {
        VncList v = new VncList((ArrayList)this.value.clone());
        v.setMeta(this.getMeta());
        return v;
    }

    @Override
    public List<VncVal> getList() {
        return this.value;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException(String.format("nth: index %d out of range. list size: %d", idx, this.size()));
        }
        return this.value.get(idx);
    }

    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.nth(idx) : defaultVal;
    }

    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.nth(0);
    }

    public VncVal second() {
        return this.size() < 2 ? Constants.Nil : this.nth(1);
    }

    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : this.nth(this.value.size() - 1);
    }

    public VncList rest() {
        if (this.isEmpty()) {
            return new VncList(new VncVal[0]);
        }
        return new VncList(this.value.subList(1, this.value.size()));
    }

    public VncList slice(int start, int end) {
        return new VncList(this.value.subList(start, end));
    }

    public VncList slice(int start) {
        return this.slice(start, this.value.size());
    }

    @Override
    public VncList empty() {
        return new VncList(new VncVal[0]);
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value);
    }

    public VncVector toVncVector() {
        return new VncVector(this.value);
    }

    public VncSet toVncSet() {
        return new VncSet(this);
    }

    public VncList addAtStart(VncVal val) {
        this.value.add(0, val);
        return this;
    }

    public VncList addAllAtStart(VncList list) {
        List<VncVal> items = list.getList();
        for (int ii = items.size() - 1; ii >= 0; ++ii) {
            this.value.add(0, items.get(ii));
        }
        return this;
    }

    public VncList addAtEnd(VncVal val) {
        this.value.add(val);
        return this;
    }

    public VncList addAllAtEnd(VncList list) {
        this.value.addAll(list.getList());
        return this;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncList(o)) {
            for (int ii = 0; ii < Math.min(this.size(), ((VncList)o).size()); ++ii) {
                int c = this.nth(ii).compareTo(((VncList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncList other = (VncList)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "(" + Printer.join(this.value, " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.value, " ", print_readably) + ")";
    }
}

