/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class VncOrderedMap
extends VncMap {
    private final LinkedHashMap<VncVal, VncVal> value;

    public VncOrderedMap(Map<VncVal, VncVal> val) {
        this.value = val instanceof LinkedHashMap ? (LinkedHashMap<Object, Object>)val : new LinkedHashMap<VncVal, VncVal>(val);
    }

    public VncOrderedMap(VncList lst) {
        this.value = new LinkedHashMap();
        this.assoc(lst);
    }

    public VncOrderedMap(VncVal ... mvs) {
        this.value = new LinkedHashMap();
        this.assoc(mvs);
    }

    @Override
    public VncOrderedMap empty() {
        return new VncOrderedMap(new VncVal[0]);
    }

    @Override
    public Map<VncVal, VncVal> getMap() {
        return this.value;
    }

    @Override
    public VncVal get(VncVal key) {
        VncVal val = this.value.get(key);
        return val == null ? Constants.Nil : val;
    }

    @Override
    public VncOrderedMap copy() {
        VncOrderedMap v = new VncOrderedMap((LinkedHashMap)this.value.clone());
        v.setMeta(this.getMeta());
        return v;
    }

    @Override
    public Set<Map.Entry<VncVal, VncVal>> entries() {
        return this.value.entrySet();
    }

    @Override
    public VncOrderedMap assoc(VncVal ... mvs) {
        for (int i = 0; i < mvs.length; i += 2) {
            this.value.put(mvs[i], mvs[i + 1]);
        }
        return this;
    }

    @Override
    public VncOrderedMap assoc(VncList mvs) {
        for (int i = 0; i < mvs.getList().size(); i += 2) {
            this.value.put(mvs.nth(i), mvs.nth(i + 1));
        }
        return this;
    }

    @Override
    public VncMap dissoc(VncVal ... keys) {
        for (VncVal key : keys) {
            this.value.remove(key);
        }
        return this;
    }

    @Override
    public VncOrderedMap dissoc(VncList keys) {
        for (int i = 0; i < keys.getList().size(); ++i) {
            this.value.remove(keys.nth(i));
        }
        return this;
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value.entrySet().stream().map(e -> new VncVector((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value.entrySet().stream().map(e -> new VncVector((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncOrderedMap other = (VncOrderedMap)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        List<VncVal> list = this.value.entrySet().stream().map(e -> new VncList((VncVal)e.getKey(), (VncVal)e.getValue()).getList()).flatMap(l -> l.stream()).collect(Collectors.toList());
        return "{" + Printer.join(list, " ", print_readably) + "}";
    }

    public static class Builder {
        private final LinkedHashMap<VncVal, VncVal> map = new LinkedHashMap();

        public Builder put(String key, VncVal val) {
            this.map.put(new VncSymbol(key), val);
            return this;
        }

        public Builder put(VncVal key, VncVal val) {
            this.map.put(key, val);
            return this;
        }

        public VncOrderedMap build() {
            return new VncOrderedMap(this.map);
        }

        public Map<VncVal, VncVal> toMap() {
            return this.map;
        }
    }
}

