/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.JavaValueException;
import com.github.jlangch.venice.PreCompiled;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.ValueException;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.Callable;

public class Venice {
    private final IInterceptor interceptor;

    public Venice() {
        this(null);
    }

    public Venice(IInterceptor interceptor) {
        this.interceptor = interceptor == null ? new AcceptAllInterceptor() : interceptor;
    }

    public PreCompiled precompile(String scriptName, String script) {
        if (StringUtil.isBlank(scriptName)) {
            throw new IllegalArgumentException("A 'scriptName' must not be blank");
        }
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        VeniceInterpreter venice = new VeniceInterpreter();
        return new PreCompiled(scriptName, venice.READ(script, scriptName), this.createEnv(venice, null));
    }

    public Object eval(PreCompiled precompiled) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        return this.eval(precompiled, null);
    }

    public Object eval(PreCompiled precompiled, Map<String, Object> params) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        return this.runWithSandbox(() -> {
            VeniceInterpreter venice = new VeniceInterpreter();
            Env env = this.addParams(new Env(precompiled.getEnv()), params);
            VncVal result = venice.EVAL((VncVal)precompiled.getPrecompiled(), env);
            return JavaInteropUtil.convertToJavaObject(result);
        });
    }

    public Object eval(String script) {
        return this.eval(null, script, null);
    }

    public Object eval(String scriptName, String script) {
        return this.eval(scriptName, script, null);
    }

    public Object eval(String script, Map<String, Object> params) {
        return this.eval(null, script, params);
    }

    public Object eval(String scriptName, String script, Map<String, Object> params) {
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        return this.runWithSandbox(() -> {
            VeniceInterpreter venice = new VeniceInterpreter();
            Env env = this.createEnv(venice, params);
            VncVal result = venice.RE(script, scriptName, env);
            return JavaInteropUtil.convertToJavaObject(result);
        });
    }

    public static String getVersion() {
        return "0.9.12";
    }

    public void enableJavaInteropReflectionCache(boolean enable) {
        ReflectionAccessor.enableCache(enable);
    }

    public boolean isJavaInteropReflectionCacheEnabled() {
        return ReflectionAccessor.isCacheEnabled();
    }

    private Env createEnv(VeniceInterpreter venice, Map<String, Object> params) {
        Env env = venice.createEnv(new PrintStream(System.out));
        this.addParams(env, params);
        return env;
    }

    private Env addParams(Env env, Map<String, Object> params) {
        if (params != null) {
            params.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                VncSymbol symbol = new VncSymbol(key);
                if (key.equals("*out*")) {
                    if (val == null) {
                        env.set(symbol, JavaInteropUtil.convertToVncVal(new PrintStream(new NullOutputStream())));
                        return;
                    } else if (val instanceof PrintStream) {
                        env.set(symbol, JavaInteropUtil.convertToVncVal(val));
                        return;
                    } else {
                        if (!(val instanceof OutputStream)) throw new VncException("The *out* parameter value must be an instance of OutputStream");
                        env.set(symbol, JavaInteropUtil.convertToVncVal(new PrintStream((OutputStream)val, true)));
                    }
                    return;
                } else {
                    if (env.findEnv(symbol) != null) {
                        throw new VncException(String.format("A parameter with the name '%' already exists", symbol.getName()));
                    }
                    env.set(symbol, JavaInteropUtil.convertToVncVal(val));
                }
            });
        }
        return env;
    }

    private Object runWithSandbox(Callable<Object> callable) {
        try {
            JavaInterop.register(this.interceptor);
            Object object = callable.call();
            return object;
        }
        catch (ValueException ex) {
            throw new JavaValueException(JavaInteropUtil.convertToJavaObject(ex.getValue()));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            ThreadLocalMap.remove();
            JavaInterop.unregister();
        }
    }
}

