/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Symbols;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.CallFrameBuilder;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;

public class Env {
    private final Env outer;
    private final int level;
    private final Symbols globalSymbols;
    private final Symbols symbols = new Symbols();

    public Env() {
        this(null);
    }

    public Env(Env outer) {
        this.outer = outer;
        this.level = outer == null ? 0 : outer.level() + 1;
        this.globalSymbols = outer == null ? new Symbols() : outer.globalSymbols;
    }

    public Env findEnv(VncSymbol key) {
        if (this.symbols.contains(key)) {
            return this;
        }
        if (this.outer != null) {
            return this.outer.findEnv(key);
        }
        if (this.globalSymbols.contains(key)) {
            return this;
        }
        return null;
    }

    public VncVal get(VncSymbol key) {
        Env e = this.findEnv(key);
        if (e == null) {
            ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(key));
            throw new VncException(String.format("Symbol '" + key.getName() + "' not found.", new Object[0]));
        }
        if (e.symbols.contains(key)) {
            return e.symbols.get(key);
        }
        if (this.globalSymbols.contains(key)) {
            return this.globalSymbols.get(key);
        }
        ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(key));
        throw new VncException(String.format("Symbol '" + key.getName() + "' not found.", new Object[0]));
    }

    public int level() {
        return this.level;
    }

    public Env set(VncSymbol key, VncVal value) {
        this.symbols.set(key, value);
        return this;
    }

    public Env setGlobal(VncSymbol key, VncVal value) {
        this.globalSymbols.set(key, value);
        return this;
    }

    public String toString() {
        return String.format("level %d: %s\n\nglobal: %s", this.level, this.symbols, this.globalSymbols);
    }
}

