/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.Map;

public class SpecialForms {
    public static VncFunction doc = new SpecialFormsDocFunction("doc"){
        {
            this.setArgLists("(doc name)");
            this.setDoc("Prints documentation for a var or special form given its name");
            this.setExamples("(doc +)");
        }
    };
    public static VncFunction list = new SpecialFormsDocFunction("()"){
        {
            this.setArgLists("");
            this.setDoc("Creates a list.");
            this.setExamples("'(10 20 30)");
        }
    };
    public static VncFunction vector = new SpecialFormsDocFunction("[]"){
        {
            this.setArgLists("");
            this.setDoc("Creates a vector.");
            this.setExamples("[10 20 30]");
        }
    };
    public static VncFunction set = new SpecialFormsDocFunction("#{}"){
        {
            this.setArgLists("");
            this.setDoc("Creates a set.");
            this.setExamples("#{10 20 30}");
        }
    };
    public static VncFunction map = new SpecialFormsDocFunction("{}"){
        {
            this.setArgLists("");
            this.setDoc("Creates a hash map.");
            this.setExamples("{:a 10 b: 20}");
        }
    };
    public static VncFunction fn = new SpecialFormsDocFunction("fn"){
        {
            this.setArgLists("(fn name? [params*] condition-map? expr*)");
            this.setDoc("Defines an anonymous function.");
            this.setExamples("(do (def sum (fn [x y] (+ x y))) (sum 2 3))", "(map (fn double [x] (* 2 x)) (range 1 5))", "(map #(* 2 %) (range 1 5))", "(map #(* 2 %1) (range 1 5))", ";; anonymous function with two params, the second is destructured\n(reduce (fn [m [k v]] (assoc m v k)) {} {:b 2 :a 1 :c 3})", ";; defining a pre-condition                 \n(do                                         \n   (def sqrt                                \n        (fn [x]                             \n            { :pre [(>= x 0)] }             \n            (. :java.lang.Math :sqrt x)))   \n   (sqrt 4))                                  ", ";; higher-order function                                           \n(do                                                                \n   (def discount                                                   \n        (fn [percentage]                                           \n            { :pre [(and (>= percentage 0) (<= percentage 100))] } \n            (fn [price] (- price (* price percentage 0.01)))))     \n   ((discount 50) 300))                                              ");
        }
    };
    public static VncFunction eval = new SpecialFormsDocFunction("eval"){
        {
            this.setArgLists("(eval form)");
            this.setDoc("Evaluates the form data structure (not text!) and returns the result.");
            this.setExamples("(eval '(let [a 10] (+ 3 4 a)))", "(eval (list + 1 2 3))");
        }
    };
    public static VncFunction def = new SpecialFormsDocFunction("def"){
        {
            this.setArgLists("(def name expr)");
            this.setDoc("Creates a global variable.");
            this.setExamples("(def val 5)", "(def sum (fn [x y] (+ x y)))");
        }
    };
    public static VncFunction do_ = new SpecialFormsDocFunction("do"){
        {
            this.setArgLists("(do exprs)");
            this.setDoc("Evaluates the expressions in order and returns the value of the last.");
            this.setExamples("(do (println \"Test...\") (+ 1 1))");
        }
    };
    public static VncFunction if_ = new SpecialFormsDocFunction("if"){
        {
            this.setArgLists("(if test true-expr false-expr)");
            this.setDoc("Evaluates test.");
            this.setExamples("(if (< 10 20) \"yes\" \"no\")");
        }
    };
    public static VncFunction let = new SpecialFormsDocFunction("let"){
        {
            this.setArgLists("(let [bindings*] exprs*)");
            this.setDoc("Evaluates the expressions and binds the values to symbols to new local context");
            this.setExamples("(let [x 1] x))", ";; destructured map                     \n(let [{:keys [width height title ]      \n       :or {width 640 height 500}       \n       :as styles}                      \n      {:width 1000 :title \"Title\"}]   \n     (println \"width: \" width)        \n     (println \"height: \" height)      \n     (println \"title: \" title)        \n     (println \"styles: \" styles))       ");
        }
    };
    public static VncFunction loop = new SpecialFormsDocFunction("loop"){
        {
            this.setArgLists("(loop [bindings*] exprs*)");
            this.setDoc("Evaluates the exprs and binds the bindings. Creates a recursion point with the bindings.");
            this.setExamples(";; tail recursion                                   \n(loop [x 10]                                        \n   (when (> x 1)                                    \n      (println x)                                   \n      (recur (- x 2))))                               ", ";; tail recursion                                   \n(do                                                 \n   (defn sum [n]                                    \n         (loop [cnt n acc 0]                        \n            (if (zero? cnt)                         \n                acc                                 \n                (recur (dec cnt) (+ acc cnt)))))    \n   (sum 10000))                                       ");
        }
    };
    public static VncFunction recur = new SpecialFormsDocFunction("recur"){
        {
            this.setArgLists("(recur expr*)");
            this.setDoc("Evaluates the exprs and rebinds the bindings of the recursion point to the values of the exprs. The recur expression must be at the tail position. The tail position is a postion which an expression would return a value from.");
            this.setExamples(";; tail recursion                                   \n(loop [x 10]                                        \n   (when (> x 1)                                    \n      (println x)                                   \n      (recur (- x 2))))                               ", ";; tail recursion                                   \n(do                                                 \n   (defn sum [n]                                    \n         (loop [cnt n acc 0]                        \n            (if (zero? cnt)                         \n                acc                                 \n                (recur (dec cnt) (+ acc cnt)))))    \n   (sum 10000))                                       ");
        }
    };
    public static VncFunction try_ = new SpecialFormsDocFunction("try"){
        {
            this.setArgLists("(try expr)", "(try expr (catch exClass exSym expr))", "(try expr (catch exClass exSym expr) (finally expr))");
            this.setDoc("Exception handling: try - catch -finally ");
            this.setExamples("(try (throw))", "(try                                      \n   (throw \"test message\"))                ", "(try                                       \n   (throw 100)                             \n   (catch :java.lang.Exception ex -100))    ", "(try                                       \n   (throw 100)                             \n   (finally (println \"...finally\")))       ", "(try                                       \n   (throw 100)                             \n   (catch :java.lang.Exception ex -100)    \n   (finally (println \"...finally\")))       ", "(do                                                  \n   (import :java.lang.RuntimeException)              \n   (try                                              \n      (throw (. :RuntimeException :new \"message\")) \n      (catch :RuntimeException ex (:message ex))))   \n", "(do                                                   \n   (try                                               \n      (throw [1 2 3])                                 \n      (catch :ValueException ex (str (:value ex)))    \n      (catch :RuntimeException ex \"runtime ex\")     \n      (finally (println \"...finally\"))))             ");
        }
    };
    public static VncFunction try_with = new SpecialFormsDocFunction("try-with"){
        {
            this.setArgLists("(try-with [bindings*] expr)", "(try-with [bindings*] expr (catch :java.lang.Exception ex expr))", "(try-with [bindings*] expr (catch :java.lang.Exception ex expr) (finally expr))");
            this.setDoc("try-with resources allows the declaration of resources to be used in a try block with the assurance that the resources will be closed after execution of that block. The resources declared must implement the Closeable or ");
            this.setExamples("(do                                                   \n   (import :java.io.FileInputStream)                  \n   (let [file (io/temp-file \"test-\", \".txt\")]     \n        (io/spit file \"123456789\" :append true)     \n        (try-with [is (. :FileInputStream :new file)] \n           (io/slurp-stream is :binary false))))        ");
        }
    };
    public static VncFunction defmacro = new SpecialFormsDocFunction("defmacro"){
        {
            this.setArgLists("(defmacro name [params*] body)");
            this.setDoc("Macro definition");
            this.setExamples("(defmacro unless [pred a b]         \n  `(if (not ~pred) ~a ~b))    ");
        }
    };
    public static VncFunction macroexpand = new SpecialFormsDocFunction("macroexpand"){
        {
            this.setArgLists("(macroexpand form)");
            this.setDoc("If form represents a macro form, returns its expansion, else returns form");
            this.setExamples("(macroexpand (-> c (+ 3) (* 2)))");
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("doc", (VncVal)doc).put("()", (VncVal)list).put("[]", (VncVal)vector).put("#{}", (VncVal)set).put("{}", (VncVal)map).put("fn", (VncVal)fn).put("eval", (VncVal)eval).put("def", (VncVal)def).put("do", (VncVal)do_).put("if", (VncVal)if_).put("let", (VncVal)let).put("loop", (VncVal)loop).put("recur", (VncVal)recur).put("try", (VncVal)try_).put("try-with", (VncVal)try_with).put("defmacro", (VncVal)defmacro).put("macroexpand", (VncVal)macroexpand).toMap();

    private static class SpecialFormsDocFunction
    extends VncFunction {
        public SpecialFormsDocFunction(String name) {
            super(name);
        }

        @Override
        public VncVal apply(VncList args) {
            return Constants.Nil;
        }
    }
}

