/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class VncBigDecimal
extends VncVal {
    private final BigDecimal value;

    public VncBigDecimal(BigDecimal v) {
        this.value = v;
    }

    @Override
    public VncBigDecimal copy() {
        VncBigDecimal v = new VncBigDecimal(this.value);
        v.setMeta(this.getMeta());
        return v;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public static RoundingMode toRoundingMode(VncString val) {
        return RoundingMode.valueOf(RoundingMode.class, val.getValue());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncNumber(o)) {
            return this.value.compareTo(Numeric.toDecimal(o).getValue());
        }
        throw new VncException(String.format("Function 'compareTo' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), o.getClass().getSimpleName()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncBigDecimal other = (VncBigDecimal)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString() + "M";
    }
}

