/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.util.CallStack;
import java.util.HashMap;
import java.util.Map;

public class ThreadLocalMap {
    private final Map<VncKeyword, VncVal> values = new HashMap<VncKeyword, VncVal>();
    private final CallStack callStack = new CallStack();
    private static ThreadLocal<ThreadLocalMap> context = InheritableThreadLocal.withInitial(() -> new ThreadLocalMap());

    public static VncVal get(VncKeyword key) {
        return ThreadLocalMap.get(key, Constants.Nil);
    }

    public static VncVal get(VncKeyword key, VncVal defaultValue) {
        if (key == null) {
            return Constants.Nil;
        }
        VncVal v = ThreadLocalMap.get().values.get(key);
        return v == null ? defaultValue : v;
    }

    public static void set(VncKeyword key, VncVal val) {
        if (key != null) {
            ThreadLocalMap.get().values.put(key, val == null ? Constants.Nil : val);
        }
    }

    public static void remove(VncKeyword key) {
        if (key != null) {
            ThreadLocalMap.get().values.remove(key);
        }
    }

    public static boolean containsKey(VncKeyword key) {
        return key == null ? false : ThreadLocalMap.get().values.containsKey(key);
    }

    public static void getClearCallStack() {
        ThreadLocalMap.get().callStack.clear();
    }

    public static CallStack getCallStack() {
        return ThreadLocalMap.get().callStack;
    }

    private static ThreadLocalMap get() {
        return context.get();
    }

    public static void clear() {
        try {
            ThreadLocalMap.get().values.clear();
            ThreadLocalMap.get().callStack.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void remove() {
        try {
            ThreadLocalMap.get().values.clear();
            context.set(null);
            context.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

