/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import java.math.RoundingMode;

public class Calc {
    public static VncVal add(VncVal op1, VncVal op2) {
        Calc.validateNumericTypes("+", op1, op2);
        if (Types.isVncLong(op1)) {
            if (Types.isVncLong(op2)) {
                return new VncLong(((VncLong)op1).getValue() + ((VncLong)op2).getValue());
            }
            if (Types.isVncDouble(op2)) {
                return Calc.add(((VncLong)op1).toDouble(), op2);
            }
            if (Types.isVncBigDecimal(op2)) {
                return Calc.add(((VncLong)op1).toDecimal(), op2);
            }
        } else if (Types.isVncDouble(op1)) {
            if (Types.isVncLong(op2)) {
                return Calc.add(op1, ((VncLong)op2).toDouble());
            }
            if (Types.isVncDouble(op2)) {
                return new VncDouble(((VncDouble)op1).getValue() + ((VncDouble)op2).getValue());
            }
            if (Types.isVncBigDecimal(op2)) {
                return Calc.add(((VncDouble)op1).toDecimal(), op2);
            }
        } else if (Types.isVncBigDecimal(op1)) {
            if (Types.isVncLong(op2)) {
                return Calc.add(op1, ((VncLong)op2).toDecimal());
            }
            if (Types.isVncDouble(op2)) {
                return Calc.add(op1, ((VncDouble)op2).toDecimal());
            }
            if (Types.isVncBigDecimal(op2)) {
                return new VncBigDecimal(((VncBigDecimal)op1).getValue().add(((VncBigDecimal)op2).getValue()));
            }
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncVal sub(VncVal op1, VncVal op2) {
        Calc.validateNumericTypes("-", op1, op2);
        if (Types.isVncLong(op1)) {
            if (Types.isVncLong(op2)) {
                return new VncLong(((VncLong)op1).getValue() - ((VncLong)op2).getValue());
            }
            if (Types.isVncDouble(op2)) {
                return Calc.sub(((VncLong)op1).toDouble(), op2);
            }
            if (Types.isVncBigDecimal(op2)) {
                return Calc.sub(((VncLong)op1).toDecimal(), op2);
            }
        } else if (Types.isVncDouble(op1)) {
            if (Types.isVncLong(op2)) {
                return Calc.sub(op1, ((VncLong)op2).toDouble());
            }
            if (Types.isVncDouble(op2)) {
                return new VncDouble(((VncDouble)op1).getValue() - ((VncDouble)op2).getValue());
            }
            if (Types.isVncBigDecimal(op2)) {
                return Calc.sub(((VncDouble)op1).toDecimal(), op2);
            }
        } else if (Types.isVncBigDecimal(op1)) {
            if (Types.isVncLong(op2)) {
                return Calc.sub(op1, ((VncLong)op2).toDecimal());
            }
            if (Types.isVncDouble(op2)) {
                return Calc.sub(op1, ((VncDouble)op2).toDecimal());
            }
            if (Types.isVncBigDecimal(op2)) {
                return new VncBigDecimal(((VncBigDecimal)op1).getValue().subtract(((VncBigDecimal)op2).getValue()));
            }
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncVal mul(VncVal op1, VncVal op2) {
        Calc.validateNumericTypes("*", op1, op2);
        if (Types.isVncLong(op1)) {
            if (Types.isVncLong(op2)) {
                return new VncLong(((VncLong)op1).getValue() * ((VncLong)op2).getValue());
            }
            if (Types.isVncDouble(op2)) {
                return Calc.mul(((VncLong)op1).toDouble(), op2);
            }
            if (Types.isVncBigDecimal(op2)) {
                return Calc.mul(((VncLong)op1).toDecimal(), op2);
            }
        } else if (Types.isVncDouble(op1)) {
            if (Types.isVncLong(op2)) {
                return Calc.mul(op1, ((VncLong)op2).toDouble());
            }
            if (Types.isVncDouble(op2)) {
                return new VncDouble(((VncDouble)op1).getValue() * ((VncDouble)op2).getValue());
            }
            if (Types.isVncBigDecimal(op2)) {
                return Calc.mul(((VncDouble)op1).toDecimal(), op2);
            }
        } else if (Types.isVncBigDecimal(op1)) {
            if (Types.isVncLong(op2)) {
                return Calc.mul(op1, ((VncLong)op2).toDecimal());
            }
            if (Types.isVncDouble(op2)) {
                return Calc.mul(op1, ((VncDouble)op2).toDecimal());
            }
            if (Types.isVncBigDecimal(op2)) {
                return new VncBigDecimal(((VncBigDecimal)op1).getValue().multiply(((VncBigDecimal)op2).getValue()));
            }
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncVal div(VncVal op1, VncVal op2) {
        Calc.validateNumericTypes("/", op1, op2);
        if (Types.isVncLong(op1)) {
            if (Types.isVncLong(op2)) {
                return new VncLong(((VncLong)op1).getValue() / ((VncLong)op2).getValue());
            }
            if (Types.isVncDouble(op2)) {
                return Calc.div(((VncLong)op1).toDouble(), op2);
            }
            if (Types.isVncBigDecimal(op2)) {
                return Calc.div(((VncLong)op1).toDecimal(), op2);
            }
        } else if (Types.isVncDouble(op1)) {
            if (Types.isVncLong(op2)) {
                return Calc.div(op1, ((VncLong)op2).toDouble());
            }
            if (Types.isVncDouble(op2)) {
                return new VncDouble(((VncDouble)op1).getValue() / ((VncDouble)op2).getValue());
            }
            if (Types.isVncBigDecimal(op2)) {
                return Calc.div(((VncDouble)op1).toDecimal(), op2);
            }
        } else if (Types.isVncBigDecimal(op1)) {
            if (Types.isVncLong(op2)) {
                return Calc.div(op1, ((VncLong)op2).toDecimal());
            }
            if (Types.isVncDouble(op2)) {
                return Calc.div(op1, ((VncDouble)op2).toDecimal());
            }
            if (Types.isVncBigDecimal(op2)) {
                return new VncBigDecimal(((VncBigDecimal)op1).getValue().divide(((VncBigDecimal)op2).getValue(), 16, RoundingMode.HALF_UP));
            }
        }
        throw new RuntimeException("Unexpected outcome");
    }

    private static void validateNumericTypes(String fn, VncVal op1, VncVal op2) {
        if (!Types.isVncNumber(op1)) {
            throw new VncException(String.format("Function '%s' operand 1 (%s) is not a numeric type", fn, Types.getClassName(op1)));
        }
        if (!Types.isVncNumber(op2)) {
            throw new VncException(String.format("Function '%s' operand 2 (%s) is not a numeric type", fn, Types.getClassName(op2)));
        }
    }
}

