/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StringFunctions {
    public static VncFunction str_blank = new VncFunction("str/blank?"){
        {
            this.setArgLists("(str/blank? s)");
            this.setDoc("True if s is blank.");
            this.setExamples("(str/blank? nil)", "(str/blank? \"\")", "(str/blank? \"  \")", "(str/blank? \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/blank?", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.True;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            return StringUtil.isBlank(s) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_starts_with = new VncFunction("str/starts-with?"){
        {
            this.setArgLists("(str/starts-with? s substr)");
            this.setDoc("True if s starts with substr.");
            this.setExamples("(str/starts-with? \"abc\"  \"ab\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/starts-with?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString prefix = Coerce.toVncString(args.nth(1));
            return string.getValue().startsWith(prefix.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_ends_with = new VncFunction("str/ends-with?"){
        {
            this.setArgLists("(str/ends-with? s substr)");
            this.setDoc("True if s ends with substr.");
            this.setExamples("(str/starts-with? \"abc\"  \"bc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/ends-with?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString suffix = Coerce.toVncString(args.nth(1));
            return string.getValue().endsWith(suffix.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_contains = new VncFunction("str/contains?"){
        {
            this.setArgLists("(str/contains? s substr)");
            this.setDoc("True if s contains with substr.");
            this.setExamples("(str/contains? \"abc\"  \"ab\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/contains?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString text = Coerce.toVncString(args.nth(1));
            return string.getValue().contains(text.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_trim = new VncFunction("str/trim"){
        {
            this.setArgLists("(str/trim s substr)");
            this.setDoc("Trims leading and trailing spaces from s.");
            this.setExamples("(str/trim \" abc  \")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/trim", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(Coerce.toVncString(args.nth(0)).getValue().trim());
        }
    };
    public static VncFunction str_trim_to_nil = new VncFunction("str/trim-to-nil"){
        {
            this.setArgLists("(str/trim-to-nil s substr)");
            this.setDoc("Trims leading and trailing spaces from s. Returns nil if the rewsulting string is empry");
            this.setExamples("(str/trim \"\")", "(str/trim \"    \")", "(str/trim nil)", "(str/trim \" abc   \")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/trim-to-nil", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String str = Coerce.toVncString(args.nth(0)).getValue().trim();
            return str.isEmpty() ? Constants.Nil : new VncString(str);
        }
    };
    public static VncFunction str_index_of = new VncFunction("str/index-of"){
        {
            this.setArgLists("(str/index-of s value)", "(str/index-of s value from-index)");
            this.setDoc("Return index of value (string or char) in s, optionally searching forward from from-index. Return nil if value not found.");
            this.setExamples("(str/index-of \"abcdefabc\" \"ab\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/index-of", args, 2, 3);
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            if (args.size() == 3) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.indexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.indexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_last_index_of = new VncFunction("str/last-index-of"){
        {
            this.setArgLists("(str/last-index-of s value)", "(str/last-index-of s value from-index)");
            this.setDoc("Return last index of value (string or char) in s, optionally\nsearching backward from from-index. Return nil if value not found.");
            this.setExamples("(str/last-index-of \"abcdefabc\" \"ab\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/last-index-of", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            if (args.size() > 2) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.lastIndexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.lastIndexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_replace_first = new VncFunction("str/replace-first"){
        {
            this.setArgLists("(str/replace-first s search replacement)");
            this.setDoc("Replaces the first occurrance of search in s");
            this.setExamples("(str/replace-first \"abcdefabc\" \"ab\" \"XYZ\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/replace-first", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            int pos = text.indexOf(searchString);
            return pos >= 0 ? new VncString(text.substring(0, pos) + replacement + text.substring(pos + replacement.length())) : args.nth(0);
        }
    };
    public static VncFunction str_replace_last = new VncFunction("str/replace-last"){
        {
            this.setArgLists("(str/replace-last s search replacement)");
            this.setDoc("Replaces the last occurrance of search in s");
            this.setExamples("(str/replace-last \"abcdefabc\" \"ab\" \"XYZ\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/replace-last", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            int pos = text.lastIndexOf(searchString);
            return pos >= 0 ? new VncString(text.substring(0, pos) + replacement + text.substring(pos + replacement.length())) : args.nth(0);
        }
    };
    public static VncFunction str_replace_all = new VncFunction("str/replace-all"){
        {
            this.setArgLists("(str/replace-all s search replacement)");
            this.setDoc("Replaces the all occurrances of search in s");
            this.setExamples("(str/replace-all \"abcdefabc\" \"ab\" \"XYZ\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/replace-all", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            String searchText = text;
            int start = 0;
            int end = searchText.indexOf(searchString, start);
            if (end == -1) {
                return args.nth(0);
            }
            int replLength = searchString.length();
            StringBuilder buf = new StringBuilder();
            while (end != -1) {
                buf.append(text, start, end).append(replacement);
                start = end + replLength;
                end = searchText.indexOf(searchString, start);
            }
            buf.append(text, start, text.length());
            return new VncString(buf.toString());
        }
    };
    public static VncFunction str_lower_case = new VncFunction("str/lower-case"){
        {
            this.setArgLists("(str/lower-case s)");
            this.setDoc("Converts s to lowercase");
            this.setExamples("(str/lower-case \"aBcDeF\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/lower-case", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            return new VncString(string.getValue().toLowerCase());
        }
    };
    public static VncFunction str_upper_case = new VncFunction("str/upper-case"){
        {
            this.setArgLists("(str/upper-case s)");
            this.setDoc("Converts s to uppercase");
            this.setExamples("(str/upper-case \"aBcDeF\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/upper-case", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            return new VncString(string.getValue().toUpperCase());
        }
    };
    public static VncFunction str_join = new VncFunction("str/join"){
        {
            this.setArgLists("(str/join coll)", "(str/join separator coll)");
            this.setDoc("Joins all elements in coll separated by an optional separator.");
            this.setExamples("(str/join [1 2 3])", "(str/join \"-\" [1 2 3])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/join", args, 1, 2);
            VncList coll = Coerce.toVncList(args.last());
            VncString delim = args.size() == 2 ? Coerce.toVncString(args.nth(0)) : new VncString("");
            return new VncString(coll.size() > 0 ? coll.getList().stream().map(v -> Types.isVncString(v) ? ((VncString)v).getValue() : v.toString()).collect(Collectors.joining(delim.getValue())) : "");
        }
    };
    public static VncFunction str_subs = new VncFunction("str/subs"){
        {
            this.setArgLists("(str/subs s start)", "(str/subs s start end)");
            this.setDoc("Returns the substring of s beginning at start inclusive, and ending at end (defaults to length of string), exclusive.");
            this.setExamples("(str/subs \"abcdef\" 2)", "(str/subs \"abcdef\" 2 5)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/subs", args, 2, 3);
            VncString string = Coerce.toVncString(args.nth(0));
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? (VncLong)args.nth(2) : null;
            return new VncString(to == null ? string.getValue().substring(from.getValue().intValue()) : string.getValue().substring(from.getValue().intValue(), to.getValue().intValue()));
        }
    };
    public static VncFunction str_split = new VncFunction("str/split"){
        {
            this.setArgLists("(str/split s regex)");
            this.setDoc("Splits string on a regular expression.");
            this.setExamples("(str/split \"abc , def , ghi\" \"[ *],[ *]\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/split", args, 2);
            VncString string = Coerce.toVncString(args.nth(0));
            VncString regex = Coerce.toVncString(args.nth(1));
            return new VncList(Arrays.asList(string.getValue().split(regex.getValue())).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_split_lines = new VncFunction("str/split-lines"){
        {
            this.setArgLists("(str/split-lines s)");
            this.setDoc("Splits s into lines.");
            this.setExamples("(str/split-lines \"line1\nline2\nline3\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/split-lines", args, 1);
            return args.nth(0) == Constants.Nil ? new VncList(new VncVal[0]) : new VncList(StringUtil.splitIntoLines(Coerce.toVncString(args.nth(0)).getValue()).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_format = new VncFunction("str/format"){
        {
            this.setArgLists("(str/format format args*)");
            this.setDoc("Returns a formatted string using the specified format string and arguments.");
            this.setExamples("(str/format \"%s: %d\" \"abc\" 100)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncString fmt = (VncString)args.nth(0);
            List fmtArgs = args.slice(1).getList().stream().map(v -> JavaInteropUtil.convertToJavaObject(v)).collect(Collectors.toList());
            return new VncString(String.format(fmt.getValue(), fmtArgs.toArray()));
        }
    };
    public static VncFunction str_quote = new VncFunction("str/quote"){
        {
            this.setArgLists("(str/quote str q)", "(str/quote str start end)");
            this.setDoc("Quotes a string.");
            this.setExamples("(str/quote \"abc\" \"-\")", "(str/quote \"abc\" \"<\" \">\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/quote", args, 2, 3);
            String s = Coerce.toVncString(args.nth(0)).getValue();
            String start = Coerce.toVncString(args.nth(1)).getValue();
            String end = args.size() == 2 ? start : Coerce.toVncString(args.nth(2)).getValue();
            return new VncString(start + s + end);
        }
    };
    public static VncFunction str_truncate = new VncFunction("str/truncate"){
        {
            this.setArgLists("(str/truncate s maxlen marker)");
            this.setDoc("Truncates a string to the max lenght maxlen and adds the marker to the end if the string needs to be truncated");
            this.setExamples("(str/truncate \"abcdefghij\" 20 \"...\")", "(str/truncate \"abcdefghij\" 9 \"...\")", "(str/truncate \"abcdefghij\" 4 \"...\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/truncate", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.truncate(Coerce.toVncString(args.nth(0)).getValue(), Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncString(args.nth(2)).getValue()));
        }
    };
    public static VncFunction str_strip_start = new VncFunction("str/strip-start"){
        {
            this.setArgLists("(str/strip-start s substr)");
            this.setDoc("Removes a substr only if it is at the beginning of a s, otherwise returns s.");
            this.setExamples("(str/strip-start \"abcdef\" \"abc\")", "(str/strip-start \"abcdef\" \"def\")");
        }

        @Override
        public VncVal apply(VncList args) {
            String substr;
            FunctionsUtil.assertArity("str/strip-start", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            return new VncString(s.startsWith(substr = Coerce.toVncString(args.nth(1)).getValue()) ? s.substring(substr.length()) : s);
        }
    };
    public static VncFunction str_strip_end = new VncFunction("str/strip-end"){
        {
            this.setArgLists("(str/strip-end s substr)");
            this.setDoc("Removes a substr only if it is at the end of a s, otherwise returns s.");
            this.setExamples("(str/strip-end \"abcdef\" \"def\")", "(str/strip-end \"abcdef\" \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            String substr;
            FunctionsUtil.assertArity("str/strip-end", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            return new VncString(s.endsWith(substr = Coerce.toVncString(args.nth(1)).getValue()) ? s.substring(0, s.length() - substr.length()) : s);
        }
    };
    public static VncFunction str_strip_indent = new VncFunction("str/strip-indent"){
        {
            this.setArgLists("(str/strip-indent s)");
            this.setDoc("Strip the indent of a multi-line string. The first line's leading whitespaces define the indent.");
            this.setExamples("(str/strip-indent \"  line1\n    line2\n    line3\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/strip-indent", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripIndent(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_strip_margin = new VncFunction("str/strip-margin"){
        {
            this.setArgLists("(str/strip-margin s)");
            this.setDoc("Strips leading whitespaces upto and including the margin '|' from each line in a multi-line string.");
            this.setExamples("(str/strip-margin \"line1\n  |  line2\n  |  line3\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/strip-margin", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripMargin(Coerce.toVncString(args.first()).getValue(), '|'));
        }
    };
    public static VncFunction str_repeat = new VncFunction("str/repeat"){
        {
            this.setArgLists("(str/repeat s n)", "(str/repeat s n sep)");
            this.setDoc("Repeats s n times with an optional separator.");
            this.setExamples("(str/repeat \"abc\" 0)", "(str/repeat \"abc\" 3)", "(str/repeat \"abc\" 3 \"-\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/repeat", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            int times = Coerce.toVncLong(args.nth(1)).getValue().intValue();
            String sep = args.size() == 3 ? Coerce.toVncString(args.nth(2)).getValue() : "";
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < times; ++ii) {
                if (ii > 0) {
                    sb.append(sep);
                }
                sb.append(s);
            }
            return new VncString(sb.toString());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("str/blank?", (VncVal)str_blank).put("str/starts-with?", (VncVal)str_starts_with).put("str/ends-with?", (VncVal)str_ends_with).put("str/contains?", (VncVal)str_contains).put("str/trim", (VncVal)str_trim).put("str/trim-to-nil", (VncVal)str_trim_to_nil).put("str/index-of", (VncVal)str_index_of).put("str/last-index-of", (VncVal)str_last_index_of).put("str/replace-first", (VncVal)str_replace_first).put("str/replace-last", (VncVal)str_replace_last).put("str/replace-all", (VncVal)str_replace_all).put("str/lower-case", (VncVal)str_lower_case).put("str/upper-case", (VncVal)str_upper_case).put("str/join", (VncVal)str_join).put("str/subs", (VncVal)str_subs).put("str/split", (VncVal)str_split).put("str/split-lines", (VncVal)str_split_lines).put("str/format", (VncVal)str_format).put("str/quote", (VncVal)str_quote).put("str/truncate", (VncVal)str_truncate).put("str/strip-start", (VncVal)str_strip_start).put("str/strip-end", (VncVal)str_strip_end).put("str/strip-indent", (VncVal)str_strip_indent).put("str/strip-margin", (VncVal)str_strip_margin).put("str/repeat", (VncVal)str_repeat).toMap();
}

