/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.javainterop.CompiledSandboxRules;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.JavaValueFilterInterceptor;
import com.github.jlangch.venice.javainterop.SandboxRules;

public class JavaSandboxInterceptor
extends JavaValueFilterInterceptor {
    private final CompiledSandboxRules sandboxRules;

    public JavaSandboxInterceptor(SandboxRules rules) {
        this.sandboxRules = CompiledSandboxRules.compile(rules);
    }

    @Override
    public Object onInvokeInstanceMethod(IInvoker invoker, Object receiver, String method, Object ... args) {
        this.validateAccessor(receiver, method);
        return super.onInvokeInstanceMethod(invoker, receiver, method, args);
    }

    @Override
    public Object onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) {
        this.validateAccessor(receiver, method);
        return super.onInvokeStaticMethod(invoker, receiver, method, args);
    }

    @Override
    public Object onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) {
        return super.onInvokeConstructor(invoker, receiver, args);
    }

    @Override
    public Object onGetBeanProperty(IInvoker invoker, Object receiver, String property) {
        this.validateAccessor(receiver, property);
        return super.onGetBeanProperty(invoker, receiver, property);
    }

    @Override
    public Object onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) {
        this.validateAccessor(receiver, property);
        return super.onSetBeanProperty(invoker, receiver, property, value);
    }

    @Override
    public Object onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) {
        this.validateAccessor(receiver, fieldName);
        return super.onGetStaticField(invoker, receiver, fieldName);
    }

    @Override
    public Object onGetInstanceField(IInvoker invoker, Object receiver, String fieldName) {
        this.validateAccessor(receiver, fieldName);
        return super.onGetInstanceField(invoker, receiver, fieldName);
    }

    @Override
    public Object filter(Object obj) {
        this.validateClass(obj);
        return obj;
    }

    @Override
    public Object filterAccessor(Object o, String accessor) {
        this.validateAccessor(o, accessor);
        return o;
    }

    @Override
    public void checkBlackListedVeniceFunction(String funcName, VncList args) {
        if (this.sandboxRules.isBlackListedVeniceFunction(funcName, args)) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to function %s", funcName));
        }
    }

    @Override
    public void checkWhiteListedSystemProperty(String property) {
        if (!this.sandboxRules.isWhiteListedSystemProperty(property)) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to system property '%s'", property));
        }
    }

    private void validateClass(Object obj) {
        Class<?> clazz;
        if (obj != null && !this.sandboxRules.isWhiteListed(clazz = this.getClass(obj))) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to class %s", clazz.getName()));
        }
    }

    private void validateAccessor(Object receiver, String accessor) {
        Class<?> clazz;
        if (receiver != null && !this.sandboxRules.isWhiteListed(clazz = this.getClass(receiver), accessor)) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to accessor %s::%s", clazz.getName(), accessor));
        }
    }

    private Class<?> getClass(Object obj) {
        if (obj != null) {
            return obj instanceof Class ? (Class<?>)obj : obj.getClass();
        }
        return null;
    }
}

