/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class SandboxRules {
    private static final Set<String> DEFAULT_CLASS_RULES = new HashSet<String>(Arrays.asList("com.github.jlangch.venice.javainterop.DynamicInvocationHandler*:*", "java.lang.Object:class", Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), BigDecimal.class.getName(), String.class.getName(), ArrayList.class.getName(), HashSet.class.getName(), HashMap.class.getName(), LinkedHashMap.class.getName()));
    public static final Set<String> DEFAULT_SYSTEM_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("file.separator", "java.home", "java.vendor", "java.vendor.url", "java.version", "line.separator", "os.arch", "os.name", "os.version", "path.separator", "user.dir", "user.home", "user.name")));
    private final Set<String> rules = new HashSet<String>(DEFAULT_CLASS_RULES);

    public SandboxRules add(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules);
        }
        return this;
    }

    public SandboxRules add(String ... rules) {
        if (rules != null) {
            this.rules.addAll(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules addClasses(Class<?> ... classes) {
        if (classes != null) {
            for (Class<?> clazz : classes) {
                this.rules.add(clazz.getName() + ":*");
            }
        }
        return this;
    }

    public SandboxRules addClasses(Collection<Class<?>> classes) {
        if (classes != null) {
            for (Class<?> clazz : classes) {
                this.rules.add(clazz.getName() + ":*");
            }
        }
        return this;
    }

    public SandboxRules rejectAllVeniceIoFunctions() {
        if (this.rules != null) {
            this.rules.add("blacklist:venice:*io*");
        }
        return this;
    }

    public SandboxRules allowAccessToStandardSystemProperties() {
        this.rules.addAll(DEFAULT_SYSTEM_PROPERTIES.stream().map(p -> "system.property:" + p).collect(Collectors.toSet()));
        return this;
    }

    public SandboxRules allowAccessToAllSystemProperties() {
        this.rules.add("system.property:*");
        return this;
    }

    public SandboxRules merge(SandboxRules other) {
        SandboxRules merged = new SandboxRules();
        merged.add(this.rules);
        merged.add(other.rules);
        return merged;
    }

    public Set<String> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    public String toString() {
        return new ArrayList<String>(this.rules).stream().sorted().collect(Collectors.joining("\n"));
    }
}

