/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.Readline;
import com.github.jlangch.venice.impl.ValueException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class CoreFunctions {
    public static VncFunction throw_ex = new VncFunction("throw"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(throw)", "(throw x)");
            this.setDoc("Throws exception with passed value x");
            this.setExamples("(do                                                     \n   (try                                                 \n     (throw 100)                                        \n     (catch :ValueException ex (:value ex))))             ", "(do                                                     \n   (import :java.lang.Exception)                        \n   (try                                                 \n      (throw [100 {:a 3}])                              \n      (catch :Exception ex (:value ex))                 \n      (finally (println \"#finally\"))))                  ", "(do                                                     \n   (import :java.lang.RuntimeException)                 \n   (try                                                 \n      (throw (. :RuntimeException :new \"#test\"))      \n      (catch :RuntimeException ex (:message ex))))        ", ";; Venice wraps thrown checked exceptions with a RuntimeException! \n(do                                                                \n   (import :java.lang.RuntimeException)                            \n   (import :java.io.IOException)                                   \n   (try                                                            \n      (throw (. :IOException :new \"#test\"))                      \n      (catch :RuntimeException ex (:message (:cause ex)))))          ");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ValueException("throw", Constants.Nil);
            }
            if (Types.isVncJavaObject(args.nth(0))) {
                Object obj = ((VncJavaObject)args.nth(0)).getDelegate();
                if (obj instanceof RuntimeException) {
                    throw (RuntimeException)obj;
                }
                if (obj instanceof Exception) {
                    throw new RuntimeException((Exception)obj);
                }
                throw new RuntimeException(obj.toString());
            }
            throw new ValueException("throw", args.nth(0));
        }
    };
    public static VncFunction nil_Q = new VncFunction("nil?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(nil? x)");
            this.setDoc("Returns true if x is nil, false otherwise");
            this.setExamples("(nil? nil)", "(nil? 0)", "(nil? false)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nil?", args, 1);
            return args.nth(0) == Constants.Nil ? Constants.True : Constants.False;
        }
    };
    public static VncFunction some_Q = new VncFunction("some?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(some? x)");
            this.setDoc("Returns true if x is not nil, false otherwise");
            this.setExamples("(some? nil)", "(some? 0)", "(some? 4.0)", "(some? false)", "(some? [])", "(some? {})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("some?", args, 1);
            return args.nth(0) == Constants.Nil ? Constants.False : Constants.True;
        }
    };
    public static VncFunction true_Q = new VncFunction("true?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(true? x)");
            this.setDoc("Returns true if x is true, false otherwise");
            this.setExamples("(true? true)", "(true? false)", "(true? nil)", "(true? 0)", "(true? (== 1 1))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("true?", args, 1);
            return args.nth(0) == Constants.True ? Constants.True : Constants.False;
        }
    };
    public static VncFunction false_Q = new VncFunction("false?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(false? x)");
            this.setDoc("Returns true if x is false, false otherwise");
            this.setExamples("(false? true)", "(false? false)", "(false? nil)", "(false? 0)", "(false? (== 1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("false?", args, 1);
            return args.nth(0) == Constants.False ? Constants.True : Constants.False;
        }
    };
    public static VncFunction boolean_Q = new VncFunction("boolean?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(boolean? n)");
            this.setDoc("Returns true if n is a boolean");
            this.setExamples("(boolean? true)", "(boolean? false)", "(boolean? nil)", "(boolean? 0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("boolean?", args, 1);
            return args.nth(0) == Constants.True || args.nth(0) == Constants.False ? Constants.True : Constants.False;
        }
    };
    public static VncFunction long_Q = new VncFunction("long?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(long? n)");
            this.setDoc("Returns true if n is a long");
            this.setExamples("(long? 4)", "(long? 3.1)", "(long? true)", "(long? nil)", "(long? {})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("long?", args, 1);
            return Types.isVncLong(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction double_Q = new VncFunction("double?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(double? n)");
            this.setDoc("Returns true if n is a double");
            this.setExamples("(double? 4.0)", "(double? 3)", "(double? true)", "(double? nil)", "(double? {})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("double?", args, 1);
            return Types.isVncDouble(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction decimal_Q = new VncFunction("decimal?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(decimal? n)");
            this.setDoc("Returns true if n is a decimal");
            this.setExamples("(decimal? 4.0M)", "(decimal? 4.0)", "(decimal? 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("decimal?", args, 1);
            return Types.isVncBigDecimal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction number_Q = new VncFunction("number?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(number? n)");
            this.setDoc("Returns true if n is a number (long, double, or decimal)");
            this.setExamples("(number? 4.0M)", "(number? 4.0)", "(number? 3)", "(number? true)", "(number? \"a\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("number?", args, 1);
            return Types.isVncLong(args.nth(0)) || Types.isVncDouble(args.nth(0)) || Types.isVncBigDecimal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction string_Q = new VncFunction("string?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(string? x)");
            this.setDoc("Returns true if x is a string");
            this.setExamples("(bytebuf? (bytebuf [1 2]))", "(bytebuf? [1 2])", "(bytebuf? nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("string?", args, 1);
            if (args.nth(0) instanceof VncKeyword) {
                return Constants.False;
            }
            if (args.nth(0) instanceof VncString) {
                return Constants.True;
            }
            return Constants.False;
        }
    };
    public static VncFunction symbol = new VncFunction("symbol"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(symbol name)");
            this.setDoc("Returns a symbol from the given name");
            this.setExamples("(symbol \"a\")", "(symbol 'a)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("symbol", args, 1);
            if (Types.isVncSymbol(args.nth(0))) {
                return args.nth(0);
            }
            if (Types.isVncString(args.nth(0))) {
                return new VncSymbol((VncString)args.nth(0));
            }
            throw new VncException(String.format("Function 'symbol' does not allow %s name.", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction symbol_Q = new VncFunction("symbol?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(symbol? x)");
            this.setDoc("Returns true if x is a symbol");
            this.setExamples("(symbol? (symbol \"a\"))", "(symbol? 'a)", "(symbol? nil)", "(symbol? :a)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("symbol?", args, 1);
            return Types.isVncSymbol(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction keyword = new VncFunction("keyword"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(keyword name)");
            this.setDoc("Returns a keyword from the given name");
            this.setExamples("(keyword \"a\")", "(keyword :a)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keyword", args, 1);
            if (Types.isVncKeyword(args.nth(0))) {
                return args.nth(0);
            }
            if (Types.isVncString(args.nth(0))) {
                return new VncKeyword(((VncString)args.nth(0)).getValue());
            }
            throw new VncException(String.format("Function 'keyword' does not allow %s name", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction keyword_Q = new VncFunction("keyword?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(keyword? x)");
            this.setDoc("Returns true if x is a keyword");
            this.setExamples("(keyword? (keyword \"a\"))", "(keyword? :a)", "(keyword? nil)", "(keyword? 'a)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keyword?", args, 1);
            return Types.isVncKeyword(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction fn_Q = new VncFunction("fn?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(fn? x)");
            this.setDoc("Returns true if x is a function");
            this.setExamples("(do \n   (def sum (fn [x] (+ 1 x)))\n   (fn? sum))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("fn?", args, 1);
            if (!Types.isVncFunction(args.nth(0))) {
                return Constants.False;
            }
            return ((VncFunction)args.nth(0)).isMacro() ? Constants.False : Constants.True;
        }
    };
    public static VncFunction macro_Q = new VncFunction("macro?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(macro? x)");
            this.setDoc("Returns true if x is a macro");
            this.setExamples("(macro? and)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("macro?", args, 1);
            if (!Types.isVncFunction(args.nth(0))) {
                return Constants.False;
            }
            return ((VncFunction)args.nth(0)).isMacro() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction pr_str = new VncFunction("pr-str"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(pr-str & xs)");
            this.setDoc("With no args, returns the empty string. With one arg x, returns x.toString(). With more than one arg, returns the concatenation of the str values of the args with delimiter ' '.");
            this.setExamples("(pr-str )", "(pr-str 1 2 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().map(v -> Printer._pr_str(v, true)).collect(Collectors.joining(" ")));
        }
    };
    public static VncFunction str = new VncFunction("str"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(str & xs)");
            this.setDoc("With no args, returns the empty string. With one arg x, returns x.toString(). (str nil) returns the empty string. With more than one arg, returns the concatenation of the str values of the args.");
            this.setExamples("(str )", "(str 1 2 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().filter(v -> v != Constants.Nil).map(v -> Printer._pr_str(v, false)).collect(Collectors.joining("")));
        }
    };
    public static VncFunction readline = new VncFunction("readline"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(readline prompt)");
            this.setDoc("Reads the next line from stdin. The function is sandboxed");
        }

        @Override
        public VncVal apply(VncList args) {
            String prompt = Coerce.toVncString(args.nth(0)).getValue();
            try {
                return new VncString(Readline.readline(prompt));
            }
            catch (IOException ex) {
                throw new ValueException(new VncString(ex.getMessage()), (Throwable)ex);
            }
            catch (EofException e) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction read_string = new VncFunction("read-string"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(read-string x)");
            this.setDoc("Reads from x");
        }

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("read-string", args, 1);
                return Reader.read_str(Coerce.toVncString(args.nth(0)).getValue(), null);
            }
            catch (ContinueException c) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction loadCoreModule = new VncFunction("load-core-module"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(load-core-module name)");
            this.setDoc("Loads a Venice extension module.");
        }

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("load-core-module", args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String module = ModuleLoader.load(((VncString)args.first()).getValue());
                    return new VncString(module);
                }
                if (Types.isVncSymbol(name)) {
                    String module = ModuleLoader.load(((VncSymbol)args.first()).getName());
                    return new VncString(module);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction loadClasspathVenice = new VncFunction("load-classpath-venice"){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("load-classpath-venice", args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String res = ModuleLoader.loadVeniceResource(((VncString)args.first()).getValue());
                    return res == null ? Constants.Nil : new VncString(res);
                }
                if (Types.isVncKeyword(name)) {
                    String res = ModuleLoader.loadVeniceResource(((VncKeyword)args.first()).getValue());
                    return res == null ? Constants.Nil : new VncString(res);
                }
                if (Types.isVncSymbol(name)) {
                    String res = ModuleLoader.loadVeniceResource(((VncSymbol)args.first()).getName());
                    return res == null ? Constants.Nil : new VncString(res);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction equal_Q = new VncFunction("=="){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(== x y)");
            this.setDoc("Returns true if both operands have the equivalent type");
            this.setExamples("(== 0 0)", "(== 0 1)", "(== 0 0.0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("==", args, 2);
            return Types._equal_Q(args.nth(0), args.nth(1)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_equal_Q = new VncFunction("!="){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(!= x y)");
            this.setDoc("Returns true if both operands do not have the equivalent type");
            this.setExamples("(!= 0 1)", "(!= 0 0)", "(!= 0 0.0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("!=", args, 2);
            return Types._equal_Q(args.nth(0), args.nth(1)) ? Constants.False : Constants.True;
        }
    };
    public static VncFunction match_Q = new VncFunction("match"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(match s regex)");
            this.setDoc("Returns true if the string s matches the regular expression regex");
            this.setExamples("(match \"1234\" \"[0-9]+\")", "(match \"1234ss\" \"[0-9]+\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("match", args, 2);
            if (!Types.isVncString(args.nth(0))) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'match'", Types.getClassName(args.nth(0))));
            }
            if (!Types.isVncString(args.nth(1))) {
                throw new VncException(String.format("Invalid second argument type %s while calling function 'match'", Types.getClassName(args.nth(1))));
            }
            return Types._match_Q(args.nth(0), args.nth(1)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction match_not_Q = new VncFunction("match-not"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(match-not s regex)");
            this.setDoc("Returns true if the string s does not match the regular expression regex");
            this.setExamples("(match-not \"1234\" \"[0-9]+\")", "(match-not \"1234ss\" \"[0-9]+\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("match-not", args, 2);
            if (!Types.isVncString(args.nth(0))) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'match-not'", Types.getClassName(args.nth(0))));
            }
            if (!Types.isVncString(args.nth(1))) {
                throw new VncException(String.format("Invalid second argument type %s while calling function 'match-not'", Types.getClassName(args.nth(1))));
            }
            return Types._match_Q(args.nth(0), args.nth(1)) ? Constants.False : Constants.True;
        }
    };
    public static VncFunction lt = new VncFunction("<"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(< x y)");
            this.setDoc("Returns true if x is smaller than y");
            this.setExamples("(< 2 3)", "(< 2 3.0)", "(< 2 3.0M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("<", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1) || Types.isVncDouble(op1) || Types.isVncBigDecimal(op1)) {
                return op1.compareTo(op2) < 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '<' with operand 1 of type %s does not allow %s as operand 2", Types.getClassName(op1), Types.getClassName(op2)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) < 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '<' does not allow %s as operand 1", Types.getClassName(op1)));
        }
    };
    public static VncFunction lte = new VncFunction("<="){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(<= x y)");
            this.setDoc("Returns true if x is smaller or equal to y");
            this.setExamples("(<= 2 3)", "(<= 3 3)", "(<= 2 3.0)", "(<= 2 3.0M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("<=", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1) || Types.isVncDouble(op1) || Types.isVncBigDecimal(op1)) {
                return op1.compareTo(op2) <= 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '<=' with operand 1 of type %s does not allow %s as operand 2", Types.getClassName(op1), Types.getClassName(op2)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) <= 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '<=' does not allow %s as operand 1", Types.getClassName(op1)));
        }
    };
    public static VncFunction gt = new VncFunction(">"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(> x y)");
            this.setDoc("Returns true if x is greater than y");
            this.setExamples("(> 3 2)", "(> 3 3)", "(> 3.0 2)", "(> 3.0M 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity(">", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1) || Types.isVncDouble(op1) || Types.isVncBigDecimal(op1)) {
                return op1.compareTo(op2) > 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '>' with operand 1 of type %s does not allow %s as operand 2", Types.getClassName(op1), Types.getClassName(op2)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) > 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '>' does not allow %s as operand 1", Types.getClassName(op1)));
        }
    };
    public static VncFunction gte = new VncFunction(">="){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(>= x y)");
            this.setDoc("Returns true if x is greater or equal to y");
            this.setExamples("(>= 3 2)", "(>= 3 3)", "(>= 3.0 2)", "(>= 3.0M 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity(">=", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1) || Types.isVncDouble(op1) || Types.isVncBigDecimal(op1)) {
                return op1.compareTo(op2) >= 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '>=' with operand 1 of type %s does not allow %s as operand 2", Types.getClassName(op1), Types.getClassName(op2)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) >= 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '>=' does not allow %s as operand 1", Types.getClassName(op1)));
        }
    };
    public static VncFunction boolean_cast = new VncFunction("boolean"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(boolean x)");
            this.setDoc("Converts to boolean. Everything except 'false' and 'nil' is true in boolean context.");
            this.setExamples("(boolean false)", "(boolean true)", "(boolean nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("boolean", args, 1);
            VncVal arg = args.nth(0);
            if (arg == Constants.Nil) {
                return Constants.False;
            }
            if (arg == Constants.False) {
                return Constants.False;
            }
            return Constants.True;
        }
    };
    public static VncFunction long_cast = new VncFunction("long"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(long x)");
            this.setDoc("Converts to long");
            this.setExamples("(long 1)", "(long nil)", "(long false)", "(long true)", "(long 1.2)", "(long 1.2M)", "(long \"1.2\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("long", args, 1);
            VncVal op1 = args.nth(0);
            if (op1 == Constants.Nil) {
                return new VncLong(0);
            }
            if (op1 == Constants.False) {
                return new VncLong(0);
            }
            if (op1 == Constants.True) {
                return new VncLong(1);
            }
            if (Types.isVncLong(op1)) {
                return op1;
            }
            if (Types.isVncDouble(op1)) {
                return new VncLong(((VncDouble)op1).getValue().longValue());
            }
            if (Types.isVncBigDecimal(op1)) {
                return new VncLong(((VncBigDecimal)op1).getValue().longValue());
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncLong(Long.parseLong(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'long': the string %s can not be converted to a longs", s));
                }
            }
            throw new VncException(String.format("Function 'long' does not allow %s as operand 1", Types.getClassName(op1)));
        }
    };
    public static VncFunction double_cast = new VncFunction("double"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(double x)");
            this.setDoc("Converts to double");
            this.setExamples("(double 1)", "(double nil)", "(double false)", "(double true)", "(double 1.2)", "(double 1.2M)", "(double \"1.2\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("double", args, 1);
            VncVal op1 = args.nth(0);
            if (op1 == Constants.Nil) {
                return new VncDouble(0.0);
            }
            if (op1 == Constants.False) {
                return new VncDouble(0.0);
            }
            if (op1 == Constants.True) {
                return new VncDouble(1.0);
            }
            if (Types.isVncLong(op1)) {
                return new VncDouble(((VncLong)op1).getValue().doubleValue());
            }
            if (Types.isVncDouble(op1)) {
                return op1;
            }
            if (Types.isVncBigDecimal(op1)) {
                return new VncDouble(((VncBigDecimal)op1).getValue().doubleValue());
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncDouble(Double.parseDouble(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'double': the string %s can not be converted to a double", s));
                }
            }
            throw new VncException(String.format("Function 'double' does not allow %s as operand 1", Types.getClassName(op1)));
        }
    };
    public static VncFunction decimal_cast = new VncFunction("decimal"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(decimal x) (decimal x scale rounding-mode)");
            this.setDoc("Converts to decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(decimal 2)", "(decimal 2 3 :HALF_UP)", "(decimal 2.5787 3 :HALF_UP)", "(decimal \"2.5787\" 3 :HALF_UP)", "(decimal nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            RoundingMode roundingMode;
            FunctionsUtil.assertArity("decimal", args, 1, 3);
            if (args.isEmpty()) {
                return new VncBigDecimal(BigDecimal.ZERO);
            }
            VncVal arg = args.nth(0);
            VncLong scale = args.size() < 3 ? null : Coerce.toVncLong(args.nth(1));
            RoundingMode roundingMode2 = roundingMode = args.size() < 3 ? null : VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (arg == Constants.Nil) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (arg == Constants.False) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (arg == Constants.True) {
                BigDecimal dec = BigDecimal.ONE;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncString(arg)) {
                BigDecimal dec = new BigDecimal(((VncString)arg).getValue());
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncNumber(arg)) {
                BigDecimal dec = Numeric.toDecimal(arg).getValue();
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'decimal' does not allow %s as operand 1", Types.getClassName(arg)));
        }
    };
    public static VncFunction new_list = new VncFunction("list"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(list & items)");
            this.setDoc("Creates a new list containing the items.");
            this.setExamples("(list )", "(list 1 2 3)", "(list 1 2 3 [:a :b])");
        }

        @Override
        public VncVal apply(VncList args) {
            return new VncList(args.getList());
        }
    };
    public static VncFunction new_list_ASTERISK = new VncFunction("list*"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(list* args)", "(list* a args)", "(list* a b args)", "(list* a b c args)", "(list* a b c d & more)");
            this.setDoc("Creates a new list containing the items prepended to the rest, the\nlast of which will be treated as a collection.");
            this.setExamples("(list* 1 [2 3])", "(list* 1 2 3 [4])", "(list* '(1 2) 3 [4])", "(list* nil)", "(list* nil [2 3])", "(list* 1 2 nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("list*", args, 1);
            if (args.size() == 1 && args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            if (args.last() == Constants.Nil) {
                return new VncList(args.slice(0, args.size() - 1).getList());
            }
            if (!Types.isVncList(args.last())) {
                throw new VncException(String.format("Function 'list*' does not allow %s as last argument", Types.getClassName(args.last())));
            }
            VncList list = new VncList(new VncVal[0]);
            list.addAllAtEnd(args.slice(0, args.size() - 1));
            list.addAllAtEnd((VncList)args.last());
            return list;
        }
    };
    public static VncFunction list_Q = new VncFunction("list?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(list? obj)");
            this.setDoc("Returns true if obj is a list");
            this.setExamples("(list? (list 1 2))", "(list? '(1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("list?", args, 1);
            return CoreFunctions.list_Q(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction new_vector = new VncFunction("vector"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(vector & items)");
            this.setDoc("Creates a new vector containing the items.");
            this.setExamples("(vector )", "(vector 1 2 3)", "(vector 1 2 3 [:a :b])");
        }

        @Override
        public VncVal apply(VncList args) {
            return new VncVector(args.getList());
        }
    };
    public static VncFunction vector_Q = new VncFunction("vector?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(vector? obj)");
            this.setDoc("Returns true if obj is a vector");
            this.setExamples("(vector? (vector 1 2))", "(vector? [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("vector?", args, 1);
            return CoreFunctions.vector_Q(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction subvec = new VncFunction("subvec"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(subvec v start) (subvec v start end)");
            this.setDoc("Returns a vector of the items in vector from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count vector)");
            this.setExamples("(subvec [1 2 3 4 5 6] 2)", "(subvec [1 2 3 4 5 6] 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("subvec", args, 2, 3);
            VncVector vec = Coerce.toVncVector(args.nth(0));
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)) : null;
            return new VncVector(to == null ? vec.getList().subList(from.getValue().intValue(), vec.size()) : vec.getList().subList(from.getValue().intValue(), to.getValue().intValue()));
        }
    };
    public static VncFunction bytebuf_Q = new VncFunction("bytebuf?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(bytebuf? x)");
            this.setDoc("Returns true if x is a bytebuf");
            this.setExamples("(bytebuf? (bytebuf [1 2]))", "(bytebuf? [1 2])", "(bytebuf? nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf?", args, 1);
            return Types.isVncByteBuffer(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction bytebuf_cast = new VncFunction("bytebuf"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(bytebuf x)");
            this.setDoc("Converts to bytebuf. x can be a bytebuf, a list/vector of longs, or a string");
            this.setExamples("(bytebuf [0 1 2])", "(bytebuf '(0 1 2))", "(bytebuf \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf", args, 0, 1);
            if (args.isEmpty()) {
                return new VncByteBuffer(ByteBuffer.wrap(new byte[0]));
            }
            VncVal arg = args.nth(0);
            if (Types.isVncString(arg)) {
                try {
                    return new VncByteBuffer(ByteBuffer.wrap(((VncString)arg).getValue().getBytes("UTF-8")));
                }
                catch (Exception ex) {
                    throw new VncException("Failed to coerce string to bytebuf", ex);
                }
            }
            if (Types.isVncJavaObject(arg)) {
                Object delegate = ((VncJavaObject)arg).getDelegate();
                if (delegate.getClass() == byte[].class) {
                    return new VncByteBuffer(ByteBuffer.wrap((byte[])delegate));
                }
                if (delegate instanceof ByteBuffer) {
                    return new VncByteBuffer((ByteBuffer)delegate);
                }
            } else {
                if (Types.isVncByteBuffer(arg)) {
                    return ((VncByteBuffer)arg).copy();
                }
                if (Types.isVncList(arg)) {
                    if (!((VncList)arg).getList().stream().allMatch(v -> Types.isVncLong(v))) {
                        throw new VncException(String.format("Function 'bytebuf' a list as argument must contains long values", new Object[0]));
                    }
                    List<VncVal> list = ((VncList)arg).getList();
                    byte[] buf = new byte[list.size()];
                    for (int ii = 0; ii < list.size(); ++ii) {
                        buf[ii] = (byte)((VncLong)list.get(ii)).getValue().longValue();
                    }
                    return new VncByteBuffer(ByteBuffer.wrap(buf));
                }
            }
            throw new VncException(String.format("Function 'bytebuf' does not allow %s as argument", Types.getClassName(arg)));
        }
    };
    public static VncFunction bytebuf_from_string = new VncFunction("bytebuf-from-string"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(bytebuf-from-string s encoding)");
            this.setDoc("Converts a string to a bytebuf using an optional encoding. The encoding defaults to UTF-8");
            this.setExamples("(bytebuf-from-string \"abcdef\" :UTF-8)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal encVal;
            FunctionsUtil.assertArity("bytebuf-from-string", args, 1, 2);
            String s = Coerce.toVncString(args.first()).getValue();
            VncVal vncVal = encVal = args.size() == 2 ? args.second() : Constants.Nil;
            String encoding = encVal == Constants.Nil ? "UTF-8" : (Types.isVncKeyword(encVal) ? Coerce.toVncKeyword(encVal).getValue() : Coerce.toVncString(encVal).getValue());
            try {
                return new VncByteBuffer(ByteBuffer.wrap(s.getBytes(encoding)));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to convert string to bytebuffer", new Object[0]));
            }
        }
    };
    public static VncFunction bytebuf_to_string = new VncFunction("bytebuf-to-string"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(bytebuf-to-string buf encoding)");
            this.setDoc("Converts a bytebuf to a string using an optional encoding. The encoding defaults to UTF-8");
            this.setExamples("(bytebuf-to-string (bytebuf [97 98 99]) :UTF-8)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal encVal;
            FunctionsUtil.assertArity("bytebuf-to-string", args, 1, 2);
            ByteBuffer buf = Coerce.toVncByteBuffer(args.first()).getValue();
            VncVal vncVal = encVal = args.size() == 2 ? args.second() : Constants.Nil;
            String encoding = encVal == Constants.Nil ? "UTF-8" : (Types.isVncKeyword(encVal) ? Coerce.toVncKeyword(encVal).getValue() : Coerce.toVncString(encVal).getValue());
            try {
                return new VncString(new String(buf.array(), encoding));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to convert bytebuffer to string", new Object[0]));
            }
        }
    };
    public static VncFunction bytebuf_sub = new VncFunction("bytebuf-sub"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(bytebuf-sub x start) (bytebuf-sub x start end)");
            this.setDoc("Returns a byte buffer of the items in buffer from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count bytebuffer)");
            this.setExamples("(bytebuf-sub (bytebuf [1 2 3 4 5 6]) 2)", "(bytebuf-sub (bytebuf [1 2 3 4 5 6]) 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf-sub", args, 2, 3);
            byte[] buf = Coerce.toVncByteBuffer(args.nth(0)).getValue().array();
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)) : null;
            return new VncByteBuffer(to == null ? ByteBuffer.wrap(Arrays.copyOfRange(buf, from.getValue().intValue(), buf.length)) : ByteBuffer.wrap(Arrays.copyOfRange(buf, from.getValue().intValue(), to.getValue().intValue())));
        }
    };
    public static VncFunction new_set = new VncFunction("set"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(set & items)");
            this.setDoc("Creates a new set containing the items.");
            this.setExamples("(set )", "(set nil)", "(set 1)", "(set 1 2 3)", "(set [1 2] 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            return new VncSet(args);
        }
    };
    public static VncFunction set_Q = new VncFunction("set?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(set? obj)");
            this.setDoc("Returns true if obj is a set");
            this.setExamples("(set? (set 1))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("set?", args, 1);
            return Types.isVncSet(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction difference = new VncFunction("difference"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(difference s1)", "(difference s1 s2)", "(difference s1 s2 & sets)");
            this.setDoc("Return a set that is the first set without elements of the remaining sets");
            this.setExamples("(difference (set 1 2 3))", "(difference (set 1 2) (set 2 3))", "(difference (set 1 2) (set 1) (set 1 4) (set 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("difference", args, 1);
            Set<VncVal> set = Coerce.toVncSet(args.first()).getSet();
            for (int ii = 1; ii < args.size(); ++ii) {
                set.removeAll(Coerce.toVncSet(args.nth(ii)).getSet());
            }
            return new VncSet(set);
        }
    };
    public static VncFunction union = new VncFunction("union"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(union s1)", "(union s1 s2)", "(union s1 s2 & sets)");
            this.setDoc("Return a set that is the union of the input sets");
            this.setExamples("(union (set 1 2 3))", "(union (set 1 2) (set 2 3))", "(union (set 1 2 3) (set 1 2) (set 1 4) (set 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("union", args, 1);
            Set<VncVal> set = Coerce.toVncSet(args.first()).getSet();
            for (int ii = 1; ii < args.size(); ++ii) {
                set.addAll(Coerce.toVncSet(args.nth(ii)).getSet());
            }
            return new VncSet(set);
        }
    };
    public static VncFunction intersection = new VncFunction("intersection"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(intersection s1)", "(intersection s1 s2)", "(intersection s1 s2 & sets)");
            this.setDoc("Return a set that is the intersection of the input sets");
            this.setExamples("(intersection (set 1))", "(intersection (set 1 2) (set 2 3))", "(intersection (set 1 2) (set 3 4))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("intersection", args, 1);
            HashSet<VncVal> intersection = new HashSet<VncVal>();
            Set<VncVal> first = Coerce.toVncSet(args.first()).getSet();
            first.forEach(v -> {
                boolean intersect = true;
                for (int ii = 1; ii < args.size(); ++ii) {
                    if (Coerce.toVncSet(args.nth(ii)).getSet().contains(v)) continue;
                    intersect = false;
                    break;
                }
                if (intersect) {
                    intersection.add((VncVal)v);
                }
            });
            return new VncSet(intersection);
        }
    };
    public static VncFunction new_hash_map = new VncFunction("hash-map"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(hash-map & keyvals)", "(hash-map map)");
            this.setDoc("Creates a new hash map containing the items.");
            this.setExamples("(hash-map :a 1 :b 2)", "(hash-map (sorted-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncHashMap(((VncMap)args.nth(0)).getMap());
            }
            if (args.size() == 1 && Types.isVncJavaObject(args.nth(0))) {
                return ((VncJavaObject)args.nth(0)).toVncMap();
            }
            return new VncHashMap(args);
        }
    };
    public static VncFunction new_ordered_map = new VncFunction("ordered-map"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(ordered-map & keyvals)", "(ordered-map map)");
            this.setDoc("Creates a new ordered map containing the items.");
            this.setExamples("(ordered-map :a 1 :b 2)", "(ordered-map (hash-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncOrderedMap(((VncMap)args.nth(0)).getMap());
            }
            return new VncOrderedMap(args);
        }
    };
    public static VncFunction new_sorted_map = new VncFunction("sorted-map"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sorted-map & keyvals)", "(sorted-map map)");
            this.setDoc("Creates a new sorted map containing the items.");
            this.setExamples("(sorted-map :a 1 :b 2)", "(sorted-map (hash-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncSortedMap(((VncMap)args.nth(0)).getMap());
            }
            return new VncSortedMap(args);
        }
    };
    public static VncFunction map_Q = new VncFunction("map?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(map? obj)");
            this.setDoc("Returns true if obj is a map");
            this.setExamples("(map? {:a 1 :b 2})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("map?", args, 1);
            return Types.isVncMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction hash_map_Q = new VncFunction("hash-map?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(hash-map? obj)");
            this.setDoc("Returns true if obj is a hash map");
            this.setExamples("(hash-map? (hash-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("hash-map?", args, 1);
            return Types.isVncHashMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction ordered_map_Q = new VncFunction("ordered-map?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(ordered-map? obj)");
            this.setDoc("Returns true if obj is an ordered map");
            this.setExamples("(ordered-map? (ordered-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("ordered-map?", args, 1);
            return Types.isVncOrderedMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction sorted_map_Q = new VncFunction("sorted-map?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sorted-map? obj)");
            this.setDoc("Returns true if obj is a sorted map");
            this.setExamples("(sorted-map? (sorted-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sorted-map?", args, 1);
            return Types.isVncSortedMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction contains_Q = new VncFunction("contains?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(contains? coll key)");
            this.setDoc("Returns true if key is present in the given collection, otherwise returns false.");
            this.setExamples("(contains? {:a 1 :b 2} :a)", "(contains? [10 11 12] 1)", "(contains? [10 11 12] 5)", "(contains? \"abc\" 1)", "(contains? \"abc\" 5)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("contains?", args, 2);
            VncVal coll = args.nth(0);
            VncVal key = args.nth(1);
            if (Types.isVncMap(coll)) {
                VncMap mhm = (VncMap)coll;
                Map<VncVal, VncVal> hm = mhm.getMap();
                return hm.containsKey(key) ? Constants.True : Constants.False;
            }
            if (Types.isVncVector(coll)) {
                VncVector v = (VncVector)coll;
                VncLong k = (VncLong)key;
                return v.size() > k.getValue().intValue() ? Constants.True : Constants.False;
            }
            if (Types.isVncSet(coll)) {
                VncSet s = (VncSet)coll;
                return s.getSet().contains(key) ? Constants.True : Constants.False;
            }
            if (Types.isVncString(coll)) {
                VncString s = (VncString)coll;
                VncLong k = (VncLong)key;
                return s.getValue().length() > k.getValue().intValue() ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'contains?' does not allow %s as coll", Types.getClassName(coll)));
        }
    };
    public static VncFunction assoc = new VncFunction("assoc"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(assoc coll key val)", "(assoc coll key val & kvs)");
            this.setDoc("When applied to a map, returns a new map of the same type, that contains the mapping of key(s) to val(s). When applied to a vector, returns a new vector that contains val at index. Note - index must be <= (count vector).");
            this.setExamples("(assoc {} :a 1 :b 2)", "(assoc nil :a 1 :b 2)", "(assoc [1 2 3] 0 10)", "(assoc [1 2 3] 3 10)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.nth(0) == Constants.Nil) {
                VncHashMap new_hm = new VncHashMap(new VncVal[0]);
                ((VncMap)new_hm).assoc(args.slice(1));
                return new_hm;
            }
            if (Types.isVncMap(args.nth(0))) {
                VncMap hm = (VncMap)args.nth(0);
                VncMap new_hm = hm.copy();
                new_hm.assoc(args.slice(1));
                return new_hm;
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = ((VncVector)args.nth(0)).copy();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncVal val = keyvals.nth(ii + 1);
                    if (vec.size() > key.getValue().intValue()) {
                        vec.getList().set(key.getValue().intValue(), val);
                        continue;
                    }
                    vec.addAtEnd(val);
                }
                return vec;
            }
            if (Types.isVncString(args.nth(0))) {
                String s = ((VncString)args.nth(0)).getValue();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncString val = Coerce.toVncString(keyvals.nth(ii + 1));
                    int idx = key.getValue().intValue();
                    if (s.length() > idx) {
                        if (idx == 0) {
                            s = "" + val.getValue().charAt(0) + s.substring(1);
                            continue;
                        }
                        if (idx == s.length() - 1) {
                            s = s.substring(0, idx) + val.getValue().charAt(0);
                            continue;
                        }
                        s = s.substring(0, idx) + val.getValue().charAt(0) + s.substring(idx + 1);
                        continue;
                    }
                    s = s + val.getValue().charAt(0);
                }
                return new VncString(s);
            }
            if (Types.isVncThreadLocal(args.nth(0))) {
                VncThreadLocal th = (VncThreadLocal)args.nth(0);
                th.assoc(args.slice(1));
                return th;
            }
            throw new VncException(String.format("Function 'assoc' does not allow %s as collection", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction assoc_in = new VncFunction("assoc-in"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(assoc-in m ks v)");
            this.setDoc("Associates a value in a nested associative structure, where ks is a sequence of keys and v is the new value and returns a new nested structure. If any levels do not exist, hash-maps or vectors will be created.");
            this.setExamples("(do\n   (def users [{:name \"James\" :age 26}  {:name \"John\" :age 43}])\n   (assoc-in users [1 :age] 44))", "(do\n   (def users [{:name \"James\" :age 26}  {:name \"John\" :age 43}])\n   (assoc-in users [2] {:name \"Jack\" :age 19}) )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("assoc-in", args, 3);
            VncCollection coll_copy = Coerce.toVncCollection(args.nth(0)).copy();
            VncList keys = Coerce.toVncList(args.nth(1));
            VncVal new_val = args.nth(2);
            VncCollection coll = coll_copy;
            while (!keys.isEmpty()) {
                VncVal key = keys.first();
                keys = keys.rest();
                if (Types.isVncMap(coll)) {
                    VncVal val = ((VncMap)coll).get(key);
                    if (val == Constants.Nil) {
                        if (keys.isEmpty()) {
                            ((VncMap)coll).assoc(key, new_val);
                            continue;
                        }
                        VncHashMap newMap = new VncHashMap(new VncVal[0]);
                        ((VncMap)coll).assoc(key, newMap);
                        coll = newMap;
                        continue;
                    }
                    if (keys.isEmpty()) {
                        ((VncMap)coll).assoc(key, new_val);
                        continue;
                    }
                    if (!Types.isVncCollection(val)) break;
                    coll = (VncCollection)val;
                    continue;
                }
                if (!Types.isVncLong(key)) break;
                int idx = ((VncLong)key).getValue().intValue();
                int len = ((VncList)coll).size();
                if (idx < 0 || idx > len) {
                    throw new VncException(String.format("Function 'assoc-in' index %d out of bounds.", idx));
                }
                if (idx < len) {
                    if (keys.isEmpty()) {
                        ((VncList)coll).getList().set(idx, new_val);
                        break;
                    }
                    VncVal val = ((VncList)coll).nth(idx);
                    if (!Types.isVncCollection(val)) break;
                    coll = (VncCollection)val;
                    continue;
                }
                ((VncList)coll).addAtEnd(new_val);
                break;
            }
            return coll_copy;
        }
    };
    public static VncFunction dissoc = new VncFunction("dissoc"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(dissoc coll key)", "(dissoc coll key & ks)");
            this.setDoc("Returns a new coll of the same type, that does not contain a mapping for key(s)");
            this.setExamples("(dissoc {:a 1 :b 2 :c 3} :b)", "(dissoc {:a 1 :b 2 :c 3} :c :b)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (Types.isVncMap(args.nth(0))) {
                VncMap hm = (VncMap)args.nth(0);
                VncMap new_hm = hm.copy();
                new_hm.dissoc(args.slice(1));
                return new_hm;
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = ((VncVector)args.nth(0)).copy();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    if (vec.size() <= key.getValue().intValue()) continue;
                    vec.getList().remove(key.getValue().intValue());
                }
                return vec;
            }
            if (Types.isVncString(args.nth(0))) {
                String s = ((VncString)args.nth(0)).getValue();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    int idx = key.getValue().intValue();
                    if (s.length() <= idx) continue;
                    s = idx == 0 ? s.substring(1) : (idx == s.length() - 1 ? s.substring(0, idx) : s.substring(0, idx) + s.substring(idx + 1));
                }
                return new VncString(s);
            }
            if (Types.isVncThreadLocal(args.nth(0))) {
                VncThreadLocal th = (VncThreadLocal)args.nth(0);
                th.dissoc(args.slice(1));
                return th;
            }
            throw new VncException(String.format("Function 'dissoc' does not allow %s as coll", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction get = new VncFunction("get"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(get map key)", "(get map key not-found)");
            this.setDoc("Returns the value mapped to key, not-found or nil if key not present.");
            this.setExamples("(get {:a 1 :b 2} :b)", ";; keywords act like functions on maps \n(:b {:a 1 :b 2})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("get", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncMap(args.nth(0))) {
                VncMap mhm = Coerce.toVncMap(args.nth(0));
                VncVal key = args.nth(1);
                VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
                VncVal value = mhm.get(key);
                return value != Constants.Nil ? value : key_not_found;
            }
            if (Types.isVncThreadLocal(args.nth(0))) {
                VncThreadLocal th = Coerce.toVncThreadLocal(args.nth(0));
                VncKeyword key = Coerce.toVncKeyword(args.nth(1));
                VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
                VncVal value = th.get(key);
                return value != Constants.Nil ? value : key_not_found;
            }
            throw new VncException(String.format("Function 'get' does not allow %s as collection", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction get_in = new VncFunction("get-in"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(get-in m ks)", "(get-in m ks not-found)");
            this.setDoc("Returns the value in a nested associative structure, where ks is a sequence of keys. Returns nil if the key is not present, or the not-found value if supplied.");
            this.setExamples("(get-in {:a 1 :b {:c 2 :d 3}} [:b :c])", "(get-in [:a :b :c] [0])", "(get-in [:a :b [:c :d :e]] [2 1])", "(get-in {:a 1 :b {:c [4 5 6]}} [:b :c 1])");
        }

        @Override
        public VncVal apply(VncList args) {
            VncConstant key_not_found;
            FunctionsUtil.assertArity("get-in", args, 2, 3);
            VncCollection coll = Coerce.toVncCollection(args.nth(0));
            VncList keys = Coerce.toVncList(args.nth(1));
            VncVal vncVal = key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
            while (!keys.isEmpty()) {
                VncVal key = keys.first();
                keys = keys.rest();
                if (Types.isVncMap(coll)) {
                    VncVal val = ((VncMap)coll).get(key);
                    if (val == Constants.Nil) {
                        return key_not_found;
                    }
                    if (keys.isEmpty()) {
                        return val;
                    }
                    if (Types.isVncCollection(val)) {
                        coll = (VncCollection)val;
                        continue;
                    }
                    return key_not_found;
                }
                if (Types.isVncLong(key)) {
                    int index = ((VncLong)key).getValue().intValue();
                    VncVal val = ((VncList)coll).nthOrDefault(index, Constants.Nil);
                    if (val == Constants.Nil) {
                        return key_not_found;
                    }
                    if (keys.isEmpty()) {
                        return val;
                    }
                    if (Types.isVncCollection(val)) {
                        coll = (VncCollection)val;
                        continue;
                    }
                    return key_not_found;
                }
                return key_not_found;
            }
            return key_not_found;
        }
    };
    public static VncFunction find = new VncFunction("find"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(find map key)");
            this.setDoc("Returns the map entry for key, or nil if key not present.");
            this.setExamples("(find {:a 1 :b 2} :b)", "(find {:a 1 :b 2} :z)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal key;
            FunctionsUtil.assertArity("find", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            VncVal value = mhm.get(key = args.nth(1));
            return value == Constants.Nil ? Constants.Nil : new VncVector(key, value);
        }
    };
    public static VncFunction key = new VncFunction("key"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(key e)");
            this.setDoc("Returns the key of the map entry.");
            this.setExamples("(key (find {:a 1 :b 2} :b))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("key", args, 1);
            VncList entry = Coerce.toVncList(args.nth(0));
            return entry.first();
        }
    };
    public static VncFunction keys = new VncFunction("keys"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(keys map)");
            this.setDoc("Returns a collection of the map's keys.");
            this.setExamples("(keys {:a 1 :b 2 :c 3})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keys", args, 1);
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            Map<VncVal, VncVal> hm = mhm.getMap();
            VncList key_lst = new VncList(new VncVal[0]);
            for (VncVal key : hm.keySet()) {
                key_lst.addAtEnd(key);
            }
            return key_lst;
        }
    };
    public static VncFunction val = new VncFunction("val"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(val e)");
            this.setDoc("Returns the val of the map entry.");
            this.setExamples("(val (find {:a 1 :b 2} :b))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("val", args, 1);
            VncList entry = Coerce.toVncList(args.nth(0));
            return entry.second();
        }
    };
    public static VncFunction vals = new VncFunction("vals"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(vals map)");
            this.setDoc("Returns a collection of the map's values.");
            this.setExamples("(vals {:a 1 :b 2 :c 3})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("vals", args, 1);
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            Map<VncVal, VncVal> hm = mhm.getMap();
            VncList val_lst = new VncList(new VncVal[0]);
            for (VncVal val : hm.values()) {
                val_lst.addAtEnd(val);
            }
            return val_lst;
        }
    };
    public static VncFunction update = new VncFunction("update"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(update m k f)");
            this.setDoc("Updates a value in an associative structure, where k is a key and f is a function that will take the old value return the new value. Returns a new structure.");
            this.setExamples("(update [] 0 (fn [x] 5))", "(update [0 1 2] 0 (fn [x] 5))", "(update [0 1 2] 0 (fn [x] (+ x 1)))", "(update {} :a (fn [x] 5))", "(update {:a 0} :b (fn [x] 5))", "(update {:a 0 :b 1} :a (fn [x] 5))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("update", args, 3);
            if (Types.isVncList(args.first())) {
                VncList list = ((VncList)args.first()).copy();
                int idx = Coerce.toVncLong(args.second()).getValue().intValue();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                if (idx < 0 || idx > list.size()) {
                    throw new VncException(String.format("Function 'update' index %d out of bounds", idx));
                }
                if (idx < list.size()) {
                    list.getList().set(idx, (VncVal)fn.apply(new VncList(list.nth(idx))));
                } else {
                    list.addAtEnd((VncVal)fn.apply(new VncList(Constants.Nil)));
                }
                return list;
            }
            if (Types.isVncMap(args.first())) {
                VncMap map = ((VncMap)args.first()).copy();
                VncVal key = args.second();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                map.assoc(key, (VncVal)fn.apply(new VncList(map.get(key))));
                return map;
            }
            throw new VncException(String.format("'update' does not allow %s as associative structure", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction update_BANG = new VncFunction("update!"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(update! m k f)");
            this.setDoc("Updates a value in an associative structure, where k is a key and f is a function that will take the old value return the new value.");
            this.setExamples("(update! [] 0 (fn [x] 5))", "(update! [0 1 2] 0 (fn [x] 5))", "(update! [0 1 2] 0 (fn [x] (+ x 1)))", "(update! {} :a (fn [x] 5))", "(update! {:a 0} :b (fn [x] 5))", "(update! {:a 0 :b 1} :a (fn [x] 5))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("update!", args, 3);
            if (Types.isVncList(args.first())) {
                VncList list = (VncList)args.first();
                int idx = Coerce.toVncLong(args.second()).getValue().intValue();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                if (idx < 0 || idx > list.size()) {
                    throw new VncException(String.format("Function 'update' index %d out of bounds", idx));
                }
                if (idx < list.size()) {
                    list.getList().set(idx, (VncVal)fn.apply(new VncList(list.nth(idx))));
                } else {
                    list.addAtEnd((VncVal)fn.apply(new VncList(Constants.Nil)));
                }
                return list;
            }
            if (Types.isVncMap(args.first())) {
                VncMap map = (VncMap)args.first();
                VncVal key = args.second();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                map.assoc(key, (VncVal)fn.apply(new VncList(map.get(key))));
                return map;
            }
            throw new VncException(String.format("'update' does not allow %s as associative structure", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction split_with = new VncFunction("split-with"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(split-with pred coll)");
            this.setDoc("Splits the collection at the first false/nil predicate result in a vector with two lists");
            this.setExamples("(split-with odd? [1 3 5 6 7 9])", "(split-with odd? [1 3 5])", "(split-with odd? [2 4 6])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("split-with", args, 2);
            if (args.second() == Constants.Nil) {
                return new VncVector(new VncList(new VncVal[0]), new VncList(new VncVal[0]));
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            List<VncVal> items = coll.getList();
            int splitPos = items.size();
            for (int ii = 0; ii < items.size(); ++ii) {
                VncVal val = coll.nth(ii);
                VncVal match = (VncVal)pred.apply(new VncList(val));
                if (match != Constants.False && match != Constants.Nil) continue;
                splitPos = ii;
                break;
            }
            if (splitPos == 0) {
                return new VncVector(new VncList(new VncVal[0]), new VncList(items));
            }
            if (splitPos < items.size()) {
                return new VncVector(new VncList(items.subList(0, splitPos)), new VncList(items.subList(splitPos, items.size())));
            }
            return new VncVector(new VncList(items), new VncList(new VncVal[0]));
        }
    };
    public static VncFunction into = new VncFunction("into"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(into to-coll from-coll)");
            this.setDoc("Returns a new coll consisting of to-coll with all of the items offrom-coll conjoined.");
            this.setExamples("(into (sorted-map) [ [:a 1] [:c 3] [:b 2] ] )", "(into (sorted-map) [ {:a 1} {:c 3} {:b 2} ] )", "(into [] {1 2, 3 4})", "(into '() '(1 2 3))", "(into [1 2 3] '(4 5 6))", "(into '() (bytebuf [0 1 2]))", "(into [] (bytebuf [0 1 2]))", "(into '() \"abc\")", "(into [] \"abc\")", "(into (sorted-map) {:b 2 :c 3 :a 1})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("into", args, 2);
            if (args.second() == Constants.Nil) {
                return args.first();
            }
            VncCollection to = Coerce.toVncCollection(args.first()).copy();
            if (Types.isVncByteBuffer(args.second())) {
                VncList byteList = ((VncByteBuffer)args.second()).toVncList();
                if (Types.isVncVector(to)) {
                    byteList.forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
                } else if (Types.isVncList(to)) {
                    byteList.forEach(v -> ((VncList)to).addAtEnd((VncVal)v));
                } else {
                    throw new VncException(String.format("Function 'into' does only allow list and vector as to-coll if from-coll is a bytebuf", new Object[0]));
                }
                return to;
            }
            if (Types.isVncString(args.second())) {
                VncList charList = ((VncString)args.second()).toVncList();
                if (Types.isVncVector(to)) {
                    charList.forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
                } else if (Types.isVncList(to)) {
                    charList.forEach(v -> ((VncList)to).addAtEnd((VncVal)v));
                } else if (Types.isVncSet(to)) {
                    charList.forEach(v -> ((VncSet)to).add((VncVal)v));
                } else {
                    throw new VncException(String.format("Function 'into' does only allow list, vector, and set as to-coll if from-coll is a string", new Object[0]));
                }
                return to;
            }
            VncCollection from = Coerce.toVncCollection(args.second());
            if (Types.isVncVector(to)) {
                from.toVncList().getList().forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
            } else if (Types.isVncList(to)) {
                from.toVncList().getList().forEach(v -> ((VncList)to).addAtStart((VncVal)v));
            } else if (Types.isVncSet(to)) {
                from.toVncList().getList().forEach(v -> ((VncSet)to).add((VncVal)v));
            } else if (Types.isVncMap(to)) {
                if (Types.isVncSequence(from)) {
                    ((VncList)from).getList().forEach(it -> {
                        if (Types.isVncSequence(it)) {
                            ((VncMap)to).assoc(((VncSequence)it).toVncList());
                        } else if (Types.isVncMap(it)) {
                            ((VncMap)to).getMap().putAll(((VncMap)it).getMap());
                        }
                    });
                } else if (Types.isVncMap(from)) {
                    ((VncMap)to).getMap().putAll(((VncMap)from).getMap());
                }
            } else {
                throw new VncException(String.format("Function 'into' does not allow %s as to-coll", Types.getClassName(args.first())));
            }
            return to;
        }
    };
    public static VncFunction sequential_Q = new VncFunction("sequential?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sequential? obj)");
            this.setDoc("Returns true if obj is a sequential collection");
            this.setExamples("(sequential? '(1))", "(sequential? [1])", "(sequential? {:a 1})", "(sequential? nil)", "(sequential? \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sequential?", args, 1);
            return Types.isVncSequence(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction coll_Q = new VncFunction("coll?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(coll? obj)");
            this.setDoc("Returns true if obj is a collection");
            this.setExamples("(coll? {:a 1})", "(coll? [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("coll?", args, 1);
            return Types.isVncCollection(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction every_Q = new VncFunction("every?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(every? pred coll)");
            this.setDoc("Returns true if the predicate is true for all collection items, false otherwise");
            this.setExamples("(every? (fn [x] (number? x)) nil)", "(every? (fn [x] (number? x)) [])", "(every? (fn [x] (number? x)) [1 2 3 4])", "(every? (fn [x] (number? x)) [1 2 3 :a])", "(every? (fn [x] (>= x 10)) [10 11 12])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("every?", args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.False;
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncCollection coll = Coerce.toVncCollection(args.second());
            if (coll.isEmpty()) {
                return Constants.False;
            }
            return coll.toVncList().getList().stream().allMatch(v -> pred.apply(new VncList((VncVal)v)) == Constants.True) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_every_Q = new VncFunction("not-every?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(not-every? pred coll)");
            this.setDoc("Returns false if the predicate is true for all collection items, true otherwise");
            this.setExamples("(not-every? (fn [x] (number? x)) nil)", "(not-every? (fn [x] (number? x)) [])", "(not-every? (fn [x] (number? x)) [1 2 3 4])", "(not-every? (fn [x] (number? x)) [1 2 3 :a])", "(not-every? (fn [x] (>= x 10)) [10 11 12])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("not-every?", args, 2);
            return every_Q.apply(args) == Constants.True ? Constants.False : Constants.True;
        }
    };
    public static VncFunction any_Q = new VncFunction("any?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(any? pred coll)");
            this.setDoc("Returns true if the predicate is true for at least one collection item, false otherwise");
            this.setExamples("(any? (fn [x] (number? x)) nil)", "(any? (fn [x] (number? x)) [])", "(any? (fn [x] (number? x)) [1 :a :b])", "(any? (fn [x] (number? x)) [1 2 3])", "(any? (fn [x] (>= x 10)) [1 5 10])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("any?", args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.False;
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncCollection coll = Coerce.toVncCollection(args.second());
            if (coll.isEmpty()) {
                return Constants.False;
            }
            return coll.toVncList().getList().stream().anyMatch(v -> pred.apply(new VncList((VncVal)v)) == Constants.True) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_any_Q = new VncFunction("not-any?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(not-any? pred coll)");
            this.setDoc("Returns false if the predicate is true for at least one collection item, true otherwise");
            this.setExamples("(not-any? (fn [x] (number? x)) nil)", "(not-any? (fn [x] (number? x)) [])", "(not-any? (fn [x] (number? x)) [1 :a :b])", "(not-any? (fn [x] (number? x)) [1 2 3])", "(not-any? (fn [x] (>= x 10)) [1 5 10])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("not-any?", args, 2);
            return any_Q.apply(args) == Constants.True ? Constants.False : Constants.True;
        }
    };
    public static VncFunction count = new VncFunction("count"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(count coll)");
            this.setDoc("Returns the number of items in the collection. (count nil) returns 0. Also works on strings, and Java Collections");
            this.setExamples("(count {:a 1 :b 2})", "(count [1 2])", "(count \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("count", args, 1);
            VncVal arg = args.nth(0);
            if (arg == Constants.Nil) {
                return new VncLong(0L);
            }
            if (Types.isVncString(arg)) {
                return new VncLong(((VncString)arg).getValue().length());
            }
            if (Types.isVncByteBuffer(arg)) {
                return new VncLong(((VncByteBuffer)arg).size());
            }
            if (Types.isVncList(arg)) {
                return new VncLong(((VncList)arg).size());
            }
            if (Types.isVncSet(arg)) {
                return new VncLong(((VncSet)arg).size());
            }
            if (Types.isVncMap(arg)) {
                return new VncLong(((VncMap)arg).size());
            }
            if (Types.isVncJavaList(arg)) {
                return new VncLong(((VncJavaList)arg).size());
            }
            if (Types.isVncJavaSet(arg)) {
                return new VncLong(((VncJavaSet)arg).size());
            }
            if (Types.isVncJavaMap(arg)) {
                return new VncLong(((VncJavaMap)arg).size());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'count'", Types.getClassName(arg)));
        }
    };
    public static VncFunction empty = new VncFunction("empty"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(empty coll)");
            this.setDoc("Returns an empty collection of the same category as coll, or nil");
            this.setExamples("(empty {:a 1})", "(empty [1 2])", "(empty '(1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty", args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (coll instanceof VncVector) {
                return ((VncVector)coll).empty();
            }
            if (coll instanceof VncList) {
                return ((VncList)coll).empty();
            }
            if (coll instanceof VncMap) {
                return ((VncMap)coll).empty();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'empty'", Types.getClassName(coll)));
        }
    };
    public static VncFunction empty_Q = new VncFunction("empty?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(empty? x)");
            this.setDoc("Returns true if x is empty");
            this.setExamples("(empty? {})", "(empty? [])", "(empty? '())");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty?", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.True;
            }
            if (exp instanceof VncString && ((VncString)exp).getValue().isEmpty()) {
                return Constants.True;
            }
            if (exp instanceof VncCollection && ((VncCollection)exp).isEmpty()) {
                return Constants.True;
            }
            if (exp instanceof VncByteBuffer && ((VncByteBuffer)exp).size() == 0) {
                return Constants.True;
            }
            return Constants.False;
        }
    };
    public static VncFunction not_empty_Q = new VncFunction("not-empty?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(not-empty? x)");
            this.setDoc("Returns true if x is not empty");
            this.setExamples("(empty? {:a 1})", "(empty? [1 2])", "(empty? '(1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("not-empty?", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.False;
            }
            if (exp instanceof VncString && ((VncString)exp).getValue().isEmpty()) {
                return Constants.False;
            }
            if (exp instanceof VncCollection && ((VncCollection)exp).isEmpty()) {
                return Constants.False;
            }
            if (exp instanceof VncByteBuffer && ((VncByteBuffer)exp).size() != 0) {
                return Constants.True;
            }
            return Constants.True;
        }
    };
    public static VncFunction cons = new VncFunction("cons"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(cons x coll)");
            this.setDoc("Returns a new collection where x is the first element and coll is\nthe rest");
            this.setExamples("(cons 1 '(2 3 4 5 6))", "(cons [1 2] [4 5 6])", "(cons 3 (set 1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("cons", args, 2);
            if (Types.isVncList(args.nth(1))) {
                VncList list = new VncList(new VncVal[0]);
                list.addAtStart(args.nth(0));
                list.addAllAtEnd((VncList)args.nth(1));
                return list;
            }
            if (Types.isVncSet(args.nth(1))) {
                VncSet src_seq = (VncSet)args.nth(1);
                VncSet new_seq = new VncSet(src_seq.toVncList());
                new_seq.add(args.nth(0));
                return new_seq;
            }
            if (Types.isVncMap(args.nth(1)) && Types.isVncMap(args.nth(0))) {
                VncMap map = ((VncMap)args.nth(1)).copy();
                map.getMap().putAll(((VncMap)args.nth(0)).getMap());
                return map;
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cons'", Types.getClassName(args.nth(1))));
        }
    };
    public static VncFunction concat = new VncFunction("concat"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(concat coll)", "(concat coll & colls)");
            this.setDoc("Returns a collection of the concatenation of the elements in the supplied colls.");
            this.setExamples("(concat [1 2])", "(concat [1 2] [4 5 6])", "(concat '(1 2))", "(concat '(1 2) [4 5 6])", "(concat {:a 1})", "(concat {:a 1} {:b 2 c: 3})", "(concat \"abc\")", "(concat \"abc\" \"def\")");
        }

        @Override
        public VncVal apply(VncList args) {
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            args.getList().forEach(val -> {
                if (val != Constants.Nil) {
                    if (Types.isVncString(val)) {
                        String str = ((VncString)val).getValue();
                        for (char ch : str.toCharArray()) {
                            result.add(new VncString(String.valueOf(ch)));
                        }
                    } else if (Types.isVncList(val)) {
                        result.addAll(((VncList)val).getList());
                    } else if (Types.isVncSet(val)) {
                        result.addAll(((VncSet)val).getList());
                    } else if (Types.isVncMap(val)) {
                        result.addAll(((VncMap)val).toVncList().getList());
                    } else if (Types.isVncJavaList(val)) {
                        result.addAll(((VncJavaList)val).toVncList().getList());
                    } else if (Types.isVncJavaSet(val)) {
                        result.addAll(((VncJavaSet)val).toVncList().getList());
                    } else if (Types.isVncJavaMap(val)) {
                        result.addAll(((VncJavaMap)val).toVncList().getList());
                    } else {
                        throw new VncException(String.format("Invalid argument type %s while calling function 'concat'", Types.getClassName(val)));
                    }
                }
            });
            return new VncList(result);
        }
    };
    public static VncFunction interleave = new VncFunction("interleave"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(interleave c1 c2)", "(interleave c1 c2 & colls)");
            this.setDoc("Returns a collection of the first item in each coll, then the second etc.");
            this.setExamples("(interleave [:a :b :c] [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("interleave", args, 2);
            int len = Coerce.toVncList(args.first()).size();
            ArrayList<VncList> lists = new ArrayList<VncList>();
            for (int ii = 0; ii < args.size(); ++ii) {
                VncList l = Coerce.toVncList(args.nth(ii));
                lists.add(l);
                len = Math.min(len, l.size());
            }
            VncList result = new VncList(new VncVal[0]);
            for (int nn = 0; nn < len; ++nn) {
                VncList item = new VncList(new VncVal[0]);
                for (int ii = 0; ii < lists.size(); ++ii) {
                    item.addAtEnd(((VncList)lists.get(ii)).nth(nn));
                }
                result.addAllAtEnd(item);
            }
            return result;
        }
    };
    public static VncFunction interpose = new VncFunction("interpose"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(interpose sep coll)");
            this.setDoc("Returns a collection of the elements of coll separated by sep.");
            this.setExamples("(interpose \", \" [1 2 3])", "(apply str (interpose \", \" [1 2 3]))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("interpose", args, 2);
            VncVal sep = args.first();
            VncList coll = Coerce.toVncList(args.second());
            VncList result = new VncList(new VncVal[0]);
            if (!coll.isEmpty()) {
                result.addAtEnd(coll.first());
                coll.rest().forEach(v -> {
                    result.addAtEnd(sep);
                    result.addAtEnd((VncVal)v);
                });
            }
            return result;
        }
    };
    public static VncFunction first = new VncFunction("first"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(first coll)");
            this.setDoc("Returns the first element of coll.");
            this.setExamples("(first nil)", "(first [])", "(first [1 2 3])", "(first '())", "(first '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("first", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).first();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).first();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'first'", Types.getClassName(val)));
        }
    };
    public static VncFunction second = new VncFunction("second"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(second coll)");
            this.setDoc("Returns the second element of coll.");
            this.setExamples("(second nil)", "(second [])", "(second [1 2 3])", "(second '())", "(second '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("second", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).second();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).second();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'second'", Types.getClassName(val)));
        }
    };
    public static VncFunction nth = new VncFunction("nth"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(nth coll idx)");
            this.setDoc("Returns the nth element of coll.");
            this.setExamples("(nth nil 1)", "(nth [1 2 3] 1)", "(nth '(1 2 3) 1)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nth", args, 2);
            int idx = Coerce.toVncLong(args.nth(1)).getValue().intValue();
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).nth(idx);
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).nth(idx);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'nth'", Types.getClassName(val)));
        }
    };
    public static VncFunction last = new VncFunction("last"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(last coll)");
            this.setDoc("Returns the last element of coll.");
            this.setExamples("(last nil)", "(last [])", "(last [1 2 3])", "(last '())", "(last '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("last", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).last();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).last();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'last'", Types.getClassName(val)));
        }
    };
    public static VncFunction rest = new VncFunction("rest"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(rest coll)");
            this.setDoc("Returns a collection with second to list element");
            this.setExamples("(rest nil)", "(rest [])", "(rest [1])", "(rest [1 2 3])", "(rest '())", "(rest '(1))", "(rest '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rest", args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncVector(coll)) {
                return ((VncVector)coll).rest();
            }
            if (Types.isVncList(coll)) {
                return ((VncList)coll).rest();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'rest'", Types.getClassName(args.first())));
        }
    };
    public static VncFunction butlast = new VncFunction("butlast"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(butlast coll)");
            this.setDoc("Returns a collection with all but the last list element");
            this.setExamples("(butlast nil)", "(butlast [])", "(butlast [1])", "(butlast [1 2 3])", "(butlast '())", "(butlast '(1))", "(butlast '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("butlast", args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncVector(coll)) {
                VncVector vec = (VncVector)coll;
                return vec.size() > 1 ? vec.slice(0, vec.size() - 1) : new VncVector(new VncVal[0]);
            }
            if (Types.isVncList(coll)) {
                VncList list = (VncList)coll;
                return list.size() > 1 ? list.slice(0, list.size() - 1) : new VncList(new VncVal[0]);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'butlast'", Types.getClassName(args.first())));
        }
    };
    public static VncFunction nfirst = new VncFunction("nfirst"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(nfirst coll n)");
            this.setDoc("Returns a collection of the first n items");
            this.setExamples("(nfirst nil 2)", "(nfirst [] 2)", "(nfirst [1] 2)", "(nfirst [1 2 3] 2)", "(nfirst '() 2)", "(nfirst '(1) 2)", "(nfirst '(1 2 3) 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nfirst", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = Coerce.toVncVector(args.nth(0));
                int n = Math.max(0, Math.min(vec.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return vec.isEmpty() ? new VncVector(new VncVal[0]) : new VncVector(vec.getList().subList(0, n));
            }
            if (Types.isVncList(args.nth(0))) {
                VncList list = Coerce.toVncList(args.nth(0));
                int n = Math.max(0, Math.min(list.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return list.isEmpty() ? new VncList(new VncVal[0]) : new VncList(list.getList().subList(0, n));
            }
            throw new VncException(String.format("nfirst: type %s not supported", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction nlast = new VncFunction("nlast"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(nlast coll n)");
            this.setDoc("Returns a collection of the last n items");
            this.setExamples("(nlast nil 2)", "(nlast [] 2)", "(nlast [1] 2)", "(nlast [1 2 3] 2)", "(nlast '() 2)", "(nlast '(1) 2)", "(nlast '(1 2 3) 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nlast", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = Coerce.toVncVector(args.nth(0));
                int n = Math.max(0, Math.min(vec.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return vec.isEmpty() ? new VncVector(new VncVal[0]) : new VncVector(vec.getList().subList(vec.size() - n, vec.size()));
            }
            if (Types.isVncList(args.nth(0))) {
                VncList list = Coerce.toVncList(args.nth(0));
                int n = Math.max(0, Math.min(list.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return list.isEmpty() ? new VncList(new VncVal[0]) : new VncList(list.getList().subList(list.size() - n, list.size()));
            }
            throw new VncException(String.format("nlast: type %s not supported", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction distinct = new VncFunction("distinct"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(distinct coll)");
            this.setDoc("Returns a collection with all duplicates removed");
            this.setExamples("(distinct [1 2 3 4 2 3 4])", "(distinct '(1 2 3 4 2 3 4))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("distinct", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList result = ((VncList)args.nth(0)).empty();
            result.getList().addAll(Coerce.toVncList(args.nth(0)).getList().stream().distinct().collect(Collectors.toList()));
            return result;
        }
    };
    public static VncFunction dedupe = new VncFunction("dedupe"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(dedupe coll)");
            this.setDoc("Returns a collection with all consecutive duplicates removed");
            this.setExamples("(dedupe [1 2 2 2 3 4 4 2 3])", "(dedupe '(1 2 2 2 3 4 4 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dedupe", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList result = ((VncList)args.nth(0)).empty();
            VncVal seen = null;
            for (VncVal val : Coerce.toVncList(args.nth(0)).getList()) {
                if (seen != null && val.equals(seen)) continue;
                result.addAtEnd(val);
                seen = val;
            }
            return result;
        }
    };
    public static VncFunction partition = new VncFunction("partition"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(partition n coll)", "(partition n step coll)", "(partition n step padcoll coll)");
            this.setDoc("Returns a collection of lists of n items each, at offsets step apart. If step is not supplied, defaults to n, i.e. the partitions do not overlap. If a padcoll collection is supplied, use its elements as necessary to complete last partition upto n items. In case there are not enough padding elements, return a partition with less than n items.");
            this.setExamples("(partition 4 (range 20))", "(partition 4 6 (range 20))", "(partition 3 6 [\"a\"] (range 20))", "(partition 4 6 [\"a\" \"b\" \"c\" \"d\"] (range 20))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("partition", args, 2, 3, 4);
            int n = Coerce.toVncLong(args.nth(0)).getValue().intValue();
            int step = args.size() > 2 ? Coerce.toVncLong(args.nth(1)).getValue().intValue() : n;
            ArrayList padcoll = args.size() > 3 ? Coerce.toVncList(args.nth(2)).getList() : new ArrayList();
            List<VncVal> coll = Coerce.toVncList(args.nth(args.size() - 1)).getList();
            if (n <= 0) {
                throw new VncException(String.format("partition: n must be a positive number", new Object[0]));
            }
            if (step <= 0) {
                throw new VncException(String.format("partition: step must be a positive number", new Object[0]));
            }
            ArrayList<List<VncVal>> splits = new ArrayList<List<VncVal>>();
            for (int ii = 0; ii < coll.size(); ii += step) {
                splits.add(coll.subList(ii, Math.min(ii + step, coll.size())));
            }
            VncList result = new VncList(new VncVal[0]);
            for (List list : splits) {
                if (n == list.size()) {
                    result.addAtEnd(new VncList(list));
                    continue;
                }
                if (n < list.size()) {
                    result.addAtEnd(new VncList(list.subList(0, n)));
                    continue;
                }
                ArrayList<VncVal> split_ = new ArrayList<VncVal>(list);
                for (int ii = 0; ii < n - list.size() && ii < padcoll.size(); ++ii) {
                    split_.add((VncVal)padcoll.get(ii));
                }
                result.addAtEnd(new VncList(split_));
            }
            return result;
        }
    };
    public static VncFunction coalesce = new VncFunction("coalesce"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(coalesce args*)");
            this.setDoc("Returns the first non nil arg");
            this.setExamples("(coalesce )", "(coalesce 1 2)", "(coalesce nil)", "(coalesce nil 1 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.stream().filter(v -> v != Constants.Nil).findFirst().orElse(Constants.Nil);
        }
    };
    public static VncFunction emptyToNil = new VncFunction("empty-to-nil"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(empty-to-nil x)");
            this.setDoc("Returns nil if x is empty");
            this.setExamples("(empty-to-nil \"\")", "(empty-to-nil [])", "(empty-to-nil '())", "(empty-to-nil {})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty-to-nil", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncString(arg)) {
                return ((VncString)arg).getValue().isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncVector(arg)) {
                return ((VncVector)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncList(arg)) {
                return ((VncList)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncMap(arg)) {
                return ((VncMap)arg).isEmpty() ? Constants.Nil : arg;
            }
            return arg;
        }
    };
    public static VncFunction className = new VncFunction("class"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(class x)");
            this.setDoc("Returns the class of x");
            this.setExamples("(class 5)", "(class [1 2])", "(class (. :java.time.ZonedDateTime :now))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("class", args, 1);
            return Types.getClassName(args.nth(0));
        }
    };
    public static VncFunction pop = new VncFunction("pop"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(pop coll)");
            this.setDoc("For a list, returns a new list without the first item, for a vector, returns a new vector without the last item.");
            this.setExamples("(pop '(1 2 3 4))", "(pop [1 2 3 4])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pop", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList ml = Coerce.toVncList(exp);
            if (Types.isVncVector(ml)) {
                return ml.size() < 2 ? new VncVector(new VncVal[0]) : ((VncVector)ml).slice(0, ml.size() - 1);
            }
            return ml.isEmpty() ? new VncList(new VncVal[0]) : ml.slice(1);
        }
    };
    public static VncFunction peek = new VncFunction("peek"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(peek coll)");
            this.setDoc("For a list, same as first, for a vector, same as last");
            this.setExamples("(peek '(1 2 3 4))", "(peek [1 2 3 4])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("peek", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.Nil;
            }
            VncList ml = Coerce.toVncList(exp);
            if (Types.isVncVector(ml)) {
                return ml.isEmpty() ? Constants.Nil : ((VncVector)ml).nth(ml.size() - 1);
            }
            return ml.isEmpty() ? Constants.Nil : ml.nth(0);
        }
    };
    public static VncFunction take_while = new VncFunction("take-while"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(take-while predicate coll)");
            this.setDoc("Returns a list of successive items from coll while (predicate item) returns logical true.");
            this.setExamples("(take-while neg? [-2 -1 0 1 2 3])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("take-while", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = (VncVal)predicate.apply(new VncList(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(0, i);
            }
            return coll;
        }
    };
    public static VncFunction take = new VncFunction("take"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(take n coll)");
            this.setDoc("Returns a collection of the first n items in coll, or all items if there are fewer than n.");
            this.setExamples("(take 3 [1 2 3 4 5])", "(take 10 [1 2 3 4 5])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("take", args, 2);
            VncLong n = Coerce.toVncLong(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            return coll.slice(0, (int)Math.min(n.getValue(), (long)coll.size()));
        }
    };
    public static VncFunction drop_while = new VncFunction("drop-while"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(drop-while predicate coll)");
            this.setDoc("Returns a list of the items in coll starting from the first item for which (predicate item) returns logical false.");
            this.setExamples("(drop-while neg? [-2 -1 0 1 2 3])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("drop-while", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = (VncVal)predicate.apply(new VncList(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(i);
            }
            return coll.empty();
        }
    };
    public static VncFunction drop = new VncFunction("drop"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(drop n coll)");
            this.setDoc("Returns a collection of all but the first n items in coll");
            this.setExamples("(drop 3 [1 2 3 4 5])", "(drop 10 [1 2 3 4 5])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("drop", args, 2);
            VncLong n = Coerce.toVncLong(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            return coll.slice((int)Math.min(n.getValue() + 1L, (long)coll.size()));
        }
    };
    public static VncFunction flatten = new VncFunction("flatten"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(flatten coll)");
            this.setDoc("Takes any nested combination of collections (lists, vectors, etc.) and returns their contents as a single, flat sequence. (flatten nil) returns an empty list.");
            this.setExamples("(flatten [])", "(flatten [[1 2 3] [4 5 6] [7 8 9]])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("flatten", args, 1);
            VncList coll = Coerce.toVncList(args.nth(0));
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            CoreFunctions.flatten(coll, result);
            return Types.isVncVector(coll) ? new VncVector(result) : new VncList(result);
        }
    };
    public static VncFunction reverse = new VncFunction("reverse"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(reverse coll)");
            this.setDoc("Returns a collection of the items in coll in reverse order");
            this.setExamples("(reverse [1 2 3 4 5 6])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reverse", args, 1);
            VncList coll = Coerce.toVncList(args.nth(0));
            VncList result = coll.empty();
            for (int ii = coll.size() - 1; ii >= 0; --ii) {
                result.addAtEnd(coll.nth(ii));
            }
            return result;
        }
    };
    public static VncFunction sort = new VncFunction("sort"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sort coll)", "(sort comparefn coll)");
            this.setDoc("Returns a sorted list of the items in coll. If no compare function comparefn is supplied, uses the natural compare. The compare function takes two arguments and returns -1, 0, or 1");
            this.setExamples("(sort [3 2 5 4 1 6])", "(sort compare [3 2 5 4 1 6])", "; reversed\n(sort (comp (partial * -1) compare) [3 2 5 4 1 6])", "(sort {:c 3 :a 1 :b 2})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sort", args, 1, 2);
            if (args.size() == 1) {
                return CoreFunctions.sort("sort", args, args.nth(0), (x, y) -> Coerce.toVncLong((VncVal)compare.apply(new VncList((VncVal)x, (VncVal)y))).getIntValue());
            }
            if (args.size() == 2) {
                VncFunction compfn = Coerce.toVncFunction(args.nth(0));
                return CoreFunctions.sort("sort", args, args.nth(1), (x, y) -> Coerce.toVncLong((VncVal)compfn.apply(new VncList((VncVal)x, (VncVal)y))).getIntValue());
            }
            throw new VncException("sort: args not supported");
        }
    };
    public static VncFunction sort_by = new VncFunction("sort-by"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sort-by keyfn coll)", "(sort-by keyfn compfn coll)");
            this.setDoc("Returns a sorted sequence of the items in coll, where the sort order is determined by comparing (keyfn item).  If no comparator is supplied, uses compare.");
            this.setExamples("(sort-by count [\"aaa\" \"bb\" \"c\"])", "; reversed\n(sort-by count (comp (partial * -1) compare) [\"aaa\" \"bb\" \"c\"])", "(sort-by first [[1 2] [3 4] [2 3]])", "; reversed\n(sort-by first (comp (partial * -1) compare) [[1 2] [3 4] [2 3]])", "(sort-by (fn [x] (get x :rank)) [{:rank 2} {:rank 3} {:rank 1}])", "; reversed\n(sort-by (fn [x] (get x :rank)) (comp (partial * -1) compare) [{:rank 2} {:rank 3} {:rank 1}])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sort-by", args, 2, 3);
            if (args.size() == 2) {
                VncFunction keyfn = Coerce.toVncFunction(args.nth(0));
                return CoreFunctions.sort("sort-by", args, args.nth(1), (x, y) -> Coerce.toVncLong((VncVal)compare.apply(new VncList((VncVal)keyfn.apply(new VncList((VncVal)x)), (VncVal)keyfn.apply(new VncList((VncVal)y))))).getIntValue());
            }
            if (args.size() == 3) {
                VncFunction keyfn = Coerce.toVncFunction(args.nth(0));
                VncFunction compfn = Coerce.toVncFunction(args.nth(1));
                return CoreFunctions.sort("sort-by", args, args.nth(2), (x, y) -> Coerce.toVncLong((VncVal)compfn.apply(new VncList((VncVal)keyfn.apply(new VncList((VncVal)x)), (VncVal)keyfn.apply(new VncList((VncVal)y))))).getIntValue());
            }
            throw new VncException("sort-by: args not supported");
        }
    };
    public static VncFunction group_by = new VncFunction("group-by"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(group-by f coll)");
            this.setDoc("Returns a map of the elements of coll keyed by the result of f on each element. The value at each key will be a vector of the corresponding elements, in the order they appeared in coll.");
            this.setExamples("(group-by count [\"a\" \"as\" \"asd\" \"aa\" \"asdf\" \"qwer\"])", "(group-by odd? (range 10))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("group-by", args, 2);
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncOrderedMap map = new VncOrderedMap(new VncVal[0]);
            coll.getList().stream().forEach(v -> {
                VncVal key = (VncVal)fn.apply(new VncList((VncVal)v));
                VncList val = Coerce.toVncList(map.getMap().get(key));
                if (val == null) {
                    map.getMap().put(key, new VncVector((VncVal)v));
                } else {
                    map.getMap().put(key, val.addAtEnd((VncVal)v));
                }
            });
            return map;
        }
    };
    public static VncFunction apply = new VncFunction("apply"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(apply f args* coll)");
            this.setDoc("Applies f to all arguments composed of args and coll");
            this.setExamples("(apply str [1 2 3 4 5])");
        }

        @Override
        public VncVal apply(VncList args) {
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList fn_args = args.slice(1, args.size() - 1);
            VncVal coll = args.last();
            if (coll == Constants.Nil) {
                fn_args.getList().add(Constants.Nil);
            } else {
                List<VncVal> tailArgs = Coerce.toVncList(args.last()).getList();
                fn_args.getList().addAll(tailArgs);
            }
            return (VncVal)fn.apply(fn_args);
        }
    };
    public static VncFunction comp = new VncFunction("comp"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(comp f*)");
            this.setDoc("Takes a set of functions and returns a fn that is the composition of those fns. The returned fn takes a variable number of args, applies the rightmost of fns to the args, the next fn (right-to-left) to the result, etc. ");
            this.setExamples("((comp str +) 8 8 8)", "(map (comp - (partial + 3) (partial * 2)) [1 2 3 4])", "((reduce comp [(partial + 1) (partial * 2) (partial + 3)]) 100)", "(filter (comp not zero?) [0 1 0 2 0 3 0 4])", "(do \n   (def fifth (comp first rest rest rest rest)) \n   (fifth [1 2 3 4 5]))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("comp", args, 1);
            final List fns = args.getList().stream().map(v -> Coerce.toVncFunction(v)).collect(Collectors.toList());
            return new VncFunction(){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncList args_ = args;
                    VncVal result = Constants.Nil;
                    for (int ii = fns.size() - 1; ii >= 0; --ii) {
                        VncFunction fn = (VncFunction)fns.get(ii);
                        result = (VncVal)fn.apply(args_);
                        args_ = new VncList(result);
                    }
                    return result;
                }
            };
        }
    };
    public static VncFunction compare = new VncFunction("compare"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(compare x y)");
            this.setDoc("Comparator. Returns -1, 0, or 1 when x is logically 'less than', 'equal to', or 'greater than' y.");
            this.setExamples("(compare nil 0)", "(compare 0 nil)", "(compare 1 0)", "(compare 1 1)", "(compare 1 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("compare", args, 2);
            return new VncLong(args.first().compareTo(args.second()));
        }
    };
    public static VncFunction partial = new VncFunction("partial"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(partial f args*)");
            this.setDoc("Takes a function f and fewer than the normal arguments to f, and returns a fn that takes a variable number of additional args. When called, the returned function calls f with args + additional args.");
            this.setExamples("((partial * 2) 3)", "(map (partial * 2) [1 2 3 4])", "(do \n   (def hundred-times (partial * 100)) \n   (hundred-times 5))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("partial", args, 2);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            final VncList fnArgs = args.slice(1);
            return new VncFunction(){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    return (VncVal)fn.apply(fnArgs.copy().addAllAtEnd(args));
                }
            };
        }
    };
    public static VncFunction map = new VncFunction("map"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(map f coll colls*)");
            this.setDoc("Applys f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted.  Any remaining items in other colls are ignored. ");
            this.setExamples("(map inc [1 2 3 4])");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() < 2) {
                return Constants.Nil;
            }
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList lists = FunctionsUtil.removeNilValues(args.slice(1));
            VncList result = new VncList(new VncVal[0]);
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                VncList fnArgs = new VncList(new VncVal[0]);
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncList nthList = Coerce.toVncList(lists.nth(ii));
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.addAtEnd(nthList.nth(index));
                }
                if (!hasMore) continue;
                VncVal val = (VncVal)fn.apply(fnArgs);
                result.getList().add(val);
                ++index;
            }
            return result;
        }
    };
    public static VncFunction mapv = new VncFunction("mapv"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(mapv f coll colls*)");
            this.setDoc("Returns a vector consisting of the result of applying f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted.  Any remaining items in other colls are ignored. ");
            this.setExamples("(mapv inc [1 2 3 4])");
        }

        @Override
        public VncVal apply(VncList args) {
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList lists = FunctionsUtil.removeNilValues(args.slice(1));
            VncVector result = new VncVector(new VncVal[0]);
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                VncList fnArgs = new VncList(new VncVal[0]);
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncList nthList = Coerce.toVncList(lists.nth(ii));
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.addAtEnd(nthList.nth(index));
                }
                if (!hasMore) continue;
                result.getList().add((VncVal)fn.apply(fnArgs));
                ++index;
            }
            return result;
        }
    };
    public static VncFunction keep = new VncFunction("keep"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(keep f coll)");
            this.setDoc("Returns a sequence of the non-nil results of (f item). Note, this means false return values will be included. f must be free of side-effects.");
            this.setExamples("(keep even? (range 1 4))", "(keep (fn [x] (if (odd? x) x)) (range 4))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keep", args, 2);
            VncVal result = (VncVal)map.apply(args);
            return result == Constants.Nil ? Constants.Nil : FunctionsUtil.removeNilValues(Coerce.toVncList(result));
        }
    };
    public static VncFunction docoll = new VncFunction("docoll"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(docoll f coll)");
            this.setDoc("Applies f to the items of the collection presumably for side effects. Returns nil. ");
            this.setExamples("(docoll \n   (fn [x] (println x)) \n   [1 2 3 4])", "(docoll \n    (fn [[k v]] (println (pr-str k v)))  \n    {:a 1 :b 2 :c 3 :d 4})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("docoll", args, 2);
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncVal coll = args.second();
            if (coll != Constants.Nil) {
                if (Types.isVncList(coll)) {
                    ((VncList)coll).forEach(v -> {
                        VncVal cfr_ignored_0 = (VncVal)fn.apply(new VncList((VncVal)v));
                    });
                } else if (Types.isVncJavaList(coll)) {
                    ((VncJavaList)coll).forEach(v -> {
                        VncVal cfr_ignored_0 = (VncVal)fn.apply(new VncList((VncVal)v));
                    });
                } else if (Types.isVncMap(coll)) {
                    ((VncMap)coll).entries().forEach(v -> {
                        VncVal cfr_ignored_0 = (VncVal)fn.apply(new VncList(new VncVector((VncVal)v.getKey(), (VncVal)v.getValue())));
                    });
                } else {
                    throw new VncException(String.format("docoll: collection type %s not supported", Types.getClassName(coll)));
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction mapcat = new VncFunction("mapcat"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(mapcat fn & colls)");
            this.setDoc("Returns the result of applying concat to the result of applying map to fn and colls. Thus function fn should return a collection.");
            this.setExamples("(mapcat reverse [[3 2 1 0] [6 5 4] [9 8 7]])");
        }

        @Override
        public VncVal apply(VncList args) {
            return (VncVal)concat.apply(Coerce.toVncList((VncVal)map.apply(args)));
        }
    };
    public static VncFunction filter = new VncFunction("filter"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(filter predicate coll)");
            this.setDoc("Returns a collection of the items in coll for which (predicate item) returns logical true. ");
            this.setExamples("(filter even? [1 2 3 4 5 6 7])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("filter", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncList result = coll.empty();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = (VncVal)predicate.apply(new VncList(val));
                if (keep == Constants.False || keep == Constants.Nil) continue;
                result.getList().add(val);
            }
            return result;
        }
    };
    public static VncFunction remove = new VncFunction("remove"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(remove predicate coll)");
            this.setDoc("Returns a collection of the items in coll for which (predicate item) returns logical false. ");
            this.setExamples("(filter even? [1 2 3 4 5 6 7])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("remove", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncList result = coll.empty();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = (VncVal)predicate.apply(new VncList(val));
                if (keep != Constants.False) continue;
                result.getList().add(val);
            }
            return result;
        }
    };
    public static VncFunction reduce = new VncFunction("reduce"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(reduce f coll)", "(reduce f val coll)");
            this.setDoc("f should be a function of 2 arguments. If val is not supplied, returns the result of applying f to the first 2 items in coll, then applying f to that result and the 3rd item, etc. If coll contains no items, f must accept no arguments as well, and reduce returns the result of calling f with no arguments.  If coll has only 1 item, it is returned and f is not called.  If val is supplied, returns the result of applying f to val and the first item in coll, then applying f to that result and the 2nd item, etc. If coll contains no items, returns val and f is not called.");
            this.setExamples("(reduce (fn [x y] (+ x y)) [1 2 3 4 5 6 7])", "(reduce (fn [x y] (+ x y)) 10 [1 2 3 4 5 6 7])", "((reduce comp [(partial + 1) (partial * 2) (partial + 3)]) 100)", "(reduce (fn [m [k v]] (assoc m v k)) {} {:b 2 :a 1 :c 3})");
        }

        @Override
        public VncVal apply(VncList args) {
            List<VncVal> coll;
            FunctionsUtil.assertArity("reduce", args, 2, 3);
            boolean twoArguments = args.size() < 3;
            VncFunction reduceFn = Coerce.toVncFunction(args.nth(0));
            if (twoArguments) {
                List<VncVal> coll2;
                if (Types.isVncList(args.nth(1))) {
                    coll2 = Coerce.toVncList(args.nth(1)).getList();
                } else if (Types.isVncMap(args.nth(1))) {
                    coll2 = Coerce.toVncMap(args.nth(1)).toVncList().getList();
                } else {
                    throw new VncException(String.format("Function 'reduce' does not allow %s as coll parameter", Types.getClassName(args.nth(1))));
                }
                if (coll2.isEmpty()) {
                    return (VncVal)reduceFn.apply(new VncList(new VncVal[0]));
                }
                VncVal value = coll2.get(0);
                for (int ii = 1; ii < coll2.size(); ++ii) {
                    value = (VncVal)reduceFn.apply(new VncList(value, coll2.get(ii)));
                }
                return value;
            }
            if (Types.isVncList(args.nth(2))) {
                coll = Coerce.toVncList(args.nth(2)).getList();
            } else if (Types.isVncMap(args.nth(2))) {
                coll = Coerce.toVncMap(args.nth(2)).toVncList().getList();
            } else {
                throw new VncException(String.format("Function 'reduce' does not allow %s as coll parameter", Types.getClassName(args.nth(2))));
            }
            if (coll.isEmpty()) {
                return args.nth(1);
            }
            if (coll.size() == 1) {
                return (VncVal)reduceFn.apply(new VncList(args.nth(1), coll.get(0)));
            }
            VncVal value = args.nth(1);
            for (int ii = 0; ii < coll.size(); ++ii) {
                value = (VncVal)reduceFn.apply(new VncList(value, coll.get(ii)));
            }
            return value;
        }
    };
    public static VncFunction reduce_kv = new VncFunction("reduce-kv"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(reduce-kv f init coll))");
            this.setDoc("Reduces an associative collection. f should be a function of 3 arguments. Returns the result of applying f to init, the first key and the first value in coll, then applying f to that result and the 2nd key and value, etc. If coll contains no entries, returns init and f is not called. Note that reduce-kv is supported on vectors, where the keys will be the ordinals.");
            this.setExamples("(reduce-kv (fn [x y z] (assoc x z y)) {} {:a 1 :b 2 :c 3})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reduce-kv", args, 3);
            VncFunction reduceFn = Coerce.toVncFunction(args.nth(0));
            Set<Map.Entry<VncVal, VncVal>> values = Coerce.toVncHashMap(args.nth(2)).entries();
            VncMap value = (VncMap)args.nth(1);
            if (values.isEmpty()) {
                return value;
            }
            for (Map.Entry<VncVal, VncVal> entry : values) {
                VncVal key = entry.getKey();
                VncVal val = entry.getValue();
                value = Coerce.toVncMap((VncVal)reduceFn.apply(new VncList(value, key, val)));
            }
            return value;
        }
    };
    public static VncFunction merge = new VncFunction("merge"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(merge & maps)");
            this.setDoc("Returns a map that consists of the rest of the maps conj-ed onto the first.  If a key occurs in more than one map, the mapping from the latter (left-to-right) will be the mapping in the result.");
            this.setExamples("(merge {:a 1 :b 2 :c 3} {:b 9 :d 4})", "(merge {:a 1} nil)", "(merge nil {:a 1})", "(merge nil nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("merge", args, 1);
            List maps = args.stream().filter(v -> v != Constants.Nil).collect(Collectors.toList());
            if (maps.isEmpty()) {
                return Constants.Nil;
            }
            HashMap<VncVal, VncVal> map = new HashMap<VncVal, VncVal>();
            maps.stream().forEach(v -> map.putAll(Coerce.toVncMap(v).getMap()));
            return new VncHashMap(map);
        }
    };
    public static VncFunction conj = new VncFunction("conj"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(conj coll x)", "(conj coll x & xs)");
            this.setDoc("Returns a new collection with the x, xs 'added'. (conj nil item) returns (item).  The 'addition' may happen at different 'places' depending on the concrete type.");
            this.setExamples("(conj [1 2 3] 4)", "(conj '(1 2 3) 4)", "(conj (set 1 2 3) 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("conj", args, 2);
            if (Types.isVncVector(args.nth(0))) {
                VncVector new_seq = new VncVector(new VncVal[0]);
                VncList src_seq = (VncList)args.nth(0);
                new_seq.getList().addAll(src_seq.getList());
                for (int i = 1; i < args.size(); ++i) {
                    new_seq.addAtEnd(args.nth(i));
                }
                return new_seq;
            }
            if (Types.isVncList(args.nth(0))) {
                VncList new_seq = new VncList(new VncVal[0]);
                VncList src_seq = (VncList)args.nth(0);
                new_seq.getList().addAll(src_seq.getList());
                for (int i = 1; i < args.size(); ++i) {
                    new_seq.addAtStart(args.nth(i));
                }
                return new_seq;
            }
            if (Types.isVncSet(args.nth(0))) {
                VncSet src_seq = (VncSet)args.nth(0);
                VncSet new_seq = new VncSet(src_seq.toVncList());
                new_seq.getList().addAll(src_seq.getList());
                for (int i = 1; i < args.size(); ++i) {
                    new_seq.add(args.nth(i));
                }
                return new_seq;
            }
            if (Types.isVncMap(args.nth(0))) {
                VncMap src_map = (VncMap)args.nth(0);
                VncMap new_map = src_map.copy();
                if (Types.isVncVector(args.nth(1)) && ((VncVector)args.nth(1)).size() == 2) {
                    return new_map.assoc(new VncList(((VncVector)args.nth(1)).nth(0), ((VncVector)args.nth(1)).nth(1)));
                }
                if (Types.isVncMap(args.nth(1))) {
                    new_map.getMap().putAll(((VncMap)args.nth(1)).getMap());
                    return new_map;
                }
                throw new VncException(String.format("Invalid x %s while calling function 'conj'", Types.getClassName(args.nth(1))));
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'conj'", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction disj = new VncFunction("disj"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(disj coll x)", "(disj coll x & xs)");
            this.setDoc("Returns a new set with the x, xs removed.");
            this.setExamples("(disj (set 1 2 3) 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("disj", args, 2);
            if (args.nth(0) instanceof VncSet) {
                VncSet src_seq = (VncSet)args.nth(0);
                VncSet new_seq = new VncSet(src_seq.toVncList());
                for (int i = 1; i < args.size(); ++i) {
                    new_seq.remove(args.nth(i));
                }
                return new_seq;
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'disj'", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction seq = new VncFunction("seq"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(seq coll)");
            this.setDoc("Returns a seq on the collection. If the collection is empty, returns nil. (seq nil) returns nil. seq also works on Strings.");
            this.setExamples("(seq nil)", "(seq [1 2 3])", "(seq '(1 2 3))", "(seq {:a 1 :b 2})", "(seq \"abcd\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("seq", args, 1);
            VncVal val = args.nth(0);
            if (Types.isVncMap(val)) {
                if (((VncMap)val).isEmpty()) {
                    return Constants.Nil;
                }
                return new VncList(((VncMap)val).entries().stream().map(e -> new VncVector((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
            }
            if (Types.isVncVector(val)) {
                if (((VncVector)val).isEmpty()) {
                    return Constants.Nil;
                }
                return new VncList(((VncVector)val).getList());
            }
            if (Types.isVncList(val)) {
                if (((VncList)val).isEmpty()) {
                    return Constants.Nil;
                }
                return val;
            }
            if (Types.isVncString(val)) {
                String s = ((VncString)val).getValue();
                if (s.length() == 0) {
                    return Constants.Nil;
                }
                ArrayList<VncVal> lst = new ArrayList<VncVal>();
                for (char c : s.toCharArray()) {
                    lst.add(new VncString(String.valueOf(c)));
                }
                return new VncList(lst);
            }
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            throw new VncException("seq: called on non-sequence");
        }
    };
    public static VncFunction repeat = new VncFunction("repeat"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(repeat n x)");
            this.setDoc("Returns a collection with the value x repeated n times");
            this.setExamples("(repeat 5 [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("repeat", args, 2);
            if (!Types.isVncLong(args.nth(0))) {
                throw new VncException("repeat: the count must be a long");
            }
            long repeat = ((VncLong)args.nth(0)).getValue();
            if (repeat < 0L) {
                throw new VncException("repeat: a count n must be grater or equal to 0");
            }
            VncVal val = args.nth(1);
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < repeat) {
                values.add(val.copy());
                ++ii;
            }
            return new VncList(values);
        }
    };
    public static VncFunction repeatedly = new VncFunction("repeatedly"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(repeatedly n fn)");
            this.setDoc("Takes a function of no args, presumably with side effects, and returns a collection of n calls to it");
            this.setExamples("(repeatedly 5 #(rand-long 11))", ";; compare with repeat, which only calls the 'rand-long'\n;; function once, repeating the value five times. \n(repeat 5 (rand-long 11))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("repeatedly", args, 2);
            long repeat = Coerce.toVncLong(args.first()).getValue();
            VncFunction fn = Coerce.toVncFunction(args.second());
            if (repeat < 0L) {
                throw new VncException("repeatedly: a count n must be grater or equal to 0");
            }
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < repeat) {
                values.add((VncVal)fn.apply(new VncList(new VncVal[0])));
                ++ii;
            }
            return new VncList(values);
        }
    };
    public static VncFunction meta = new VncFunction("meta"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(meta obj)");
            this.setDoc("Returns the metadata of obj, returns nil if there is no metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("meta", args, 1);
            return args.nth(0).getMeta();
        }
    };
    public static VncFunction with_meta = new VncFunction("with-meta"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(with-meta obj m)");
            this.setDoc("Returns a copy of the object obj, with a map m as its metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("meta", args, 2);
            if (!Types.isVncMap(args.nth(1))) {
                throw new VncException("with-meta: the meta data for the object must be a map");
            }
            VncVal new_obj = args.nth(0).copy();
            new_obj.setMeta(args.nth(1));
            return new_obj;
        }
    };
    public static VncFunction vary_meta = new VncFunction("vary-meta"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(vary-meta obj f & args)");
            this.setDoc("Returns a copy of the object obj, with (apply f (meta obj) args) as its metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("vary-meta", args, 2);
            if (!Types.isVncFunction(args.nth(1))) {
                throw new VncException("var-meta requires a function as second argument");
            }
            VncVal meta = args.nth(0).getMeta();
            VncFunction fn = (VncFunction)args.nth(1);
            VncList fnArgs = args.slice(2);
            fnArgs.addAtStart(meta == Constants.Nil ? new VncHashMap(new VncVal[0]) : meta);
            VncVal new_obj = args.nth(0).copy();
            new_obj.setMeta((VncVal)fn.apply(fnArgs));
            return new_obj;
        }
    };
    public static VncFunction gensym = new VncFunction("gensym"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(gensym)", "(gensym prefix)");
            this.setDoc("Generates a symbol.");
            this.setExamples("(gensym )", "(gensym \"prefix_\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("gensym", args, 0, 1);
            String prefix = args.isEmpty() ? "G__" : (Types.isVncSymbol(args.nth(0)) ? Coerce.toVncSymbol(args.nth(0)).getName() : Coerce.toVncString(args.nth(0)).getValue());
            return new VncSymbol(prefix + String.valueOf(gensymValue.incrementAndGet()));
        }
    };
    public static VncFunction name = new VncFunction("name"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(name x)");
            this.setDoc("Returns the name String of a string, symbol or keyword.");
            this.setExamples("(name :x)", "(name 'x)", "(name \"x\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("name", args, 1);
            VncVal arg = args.first();
            if (Types.isVncKeyword(arg)) {
                return new VncString(((VncKeyword)arg).getValue());
            }
            if (Types.isVncSymbol(arg)) {
                return new VncString(((VncSymbol)arg).getName());
            }
            if (Types.isVncString(arg)) {
                return arg;
            }
            throw new VncException(String.format("Function 'name' does not allow %s as parameter", Types.getClassName(arg)));
        }
    };
    public static VncFunction type = new VncFunction("type"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(type x)");
            this.setDoc("Returns the type of x.");
            this.setExamples("(type 5)", "(type (. :java.time.ZonedDateTime :now))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("type", args, 1);
            return Types.getClassName(args.first());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("throw", (VncVal)throw_ex).put("nil?", (VncVal)nil_Q).put("some?", (VncVal)some_Q).put("true?", (VncVal)true_Q).put("false?", (VncVal)false_Q).put("boolean?", (VncVal)boolean_Q).put("long?", (VncVal)long_Q).put("double?", (VncVal)double_Q).put("decimal?", (VncVal)decimal_Q).put("number?", (VncVal)number_Q).put("bytebuf?", (VncVal)bytebuf_Q).put("string?", (VncVal)string_Q).put("symbol", (VncVal)symbol).put("symbol?", (VncVal)symbol_Q).put("keyword", (VncVal)keyword).put("keyword?", (VncVal)keyword_Q).put("fn?", (VncVal)fn_Q).put("macro?", (VncVal)macro_Q).put("pr-str", (VncVal)pr_str).put("str", (VncVal)str).put("readline", (VncVal)readline).put("read-string", (VncVal)read_string).put("==", (VncVal)equal_Q).put("!=", (VncVal)not_equal_Q).put("<", (VncVal)lt).put("<=", (VncVal)lte).put(">", (VncVal)gt).put(">=", (VncVal)gte).put("match", (VncVal)match_Q).put("match-not", (VncVal)match_not_Q).put("boolean", (VncVal)boolean_cast).put("long", (VncVal)long_cast).put("double", (VncVal)double_cast).put("decimal", (VncVal)decimal_cast).put("bytebuf", (VncVal)bytebuf_cast).put("bytebuf-to-string", (VncVal)bytebuf_to_string).put("bytebuf-from-string", (VncVal)bytebuf_from_string).put("list", (VncVal)new_list).put("list*", (VncVal)new_list_ASTERISK).put("list?", (VncVal)list_Q).put("vector", (VncVal)new_vector).put("vector?", (VncVal)vector_Q).put("map?", (VncVal)map_Q).put("hash-map?", (VncVal)hash_map_Q).put("ordered-map?", (VncVal)ordered_map_Q).put("sorted-map?", (VncVal)sorted_map_Q).put("hash-map", (VncVal)new_hash_map).put("ordered-map", (VncVal)new_ordered_map).put("sorted-map", (VncVal)new_sorted_map).put("assoc", (VncVal)assoc).put("assoc-in", (VncVal)assoc_in).put("dissoc", (VncVal)dissoc).put("contains?", (VncVal)contains_Q).put("find", (VncVal)find).put("get", (VncVal)get).put("get-in", (VncVal)get_in).put("key", (VncVal)key).put("keys", (VncVal)keys).put("val", (VncVal)val).put("vals", (VncVal)vals).put("update", (VncVal)update).put("update!", (VncVal)update_BANG).put("subvec", (VncVal)subvec).put("bytebuf-sub", (VncVal)bytebuf_sub).put("empty", (VncVal)empty).put("set?", (VncVal)set_Q).put("set", (VncVal)new_set).put("difference", (VncVal)difference).put("union", (VncVal)union).put("intersection", (VncVal)intersection).put("split-with", (VncVal)split_with).put("into", (VncVal)into).put("sequential?", (VncVal)sequential_Q).put("coll?", (VncVal)coll_Q).put("cons", (VncVal)cons).put("co", (VncVal)cons).put("concat", (VncVal)concat).put("interpose", (VncVal)interpose).put("interleave", (VncVal)interleave).put("mapcat", (VncVal)mapcat).put("keep", (VncVal)keep).put("docoll", (VncVal)docoll).put("nth", (VncVal)nth).put("first", (VncVal)first).put("second", (VncVal)second).put("last", (VncVal)last).put("rest", (VncVal)rest).put("butlast", (VncVal)butlast).put("nfirst", (VncVal)nfirst).put("nlast", (VncVal)nlast).put("empty-to-nil", (VncVal)emptyToNil).put("pop", (VncVal)pop).put("peek", (VncVal)peek).put("empty?", (VncVal)empty_Q).put("not-empty?", (VncVal)not_empty_Q).put("every?", (VncVal)every_Q).put("not-every?", (VncVal)not_every_Q).put("any?", (VncVal)any_Q).put("not-any?", (VncVal)not_any_Q).put("count", (VncVal)count).put("compare", (VncVal)compare).put("apply", (VncVal)apply).put("comp", (VncVal)comp).put("partial", (VncVal)partial).put("map", (VncVal)map).put("mapv", (VncVal)mapv).put("filter", (VncVal)filter).put("distinct", (VncVal)distinct).put("dedupe", (VncVal)dedupe).put("partition", (VncVal)partition).put("remove", (VncVal)remove).put("reduce", (VncVal)reduce).put("reduce-kv", (VncVal)reduce_kv).put("take", (VncVal)take).put("take-while", (VncVal)take_while).put("drop", (VncVal)drop).put("drop-while", (VncVal)drop_while).put("flatten", (VncVal)flatten).put("reverse", (VncVal)reverse).put("group-by", (VncVal)group_by).put("sort", (VncVal)sort).put("sort-by", (VncVal)sort_by).put("merge", (VncVal)merge).put("conj", (VncVal)conj).put("disj", (VncVal)disj).put("seq", (VncVal)seq).put("repeat", (VncVal)repeat).put("repeatedly", (VncVal)repeatedly).put("meta", (VncVal)meta).put("with-meta", (VncVal)with_meta).put("vary-meta", (VncVal)vary_meta).put("coalesce", (VncVal)coalesce).put("gensym", (VncVal)gensym).put("name", (VncVal)name).put("type", (VncVal)type).put("class", (VncVal)className).put("load-core-module", (VncVal)loadCoreModule).put("load-classpath-venice", (VncVal)loadClasspathVenice).toMap();
    private static final AtomicLong gensymValue = new AtomicLong(0L);

    public static boolean list_Q(VncVal mv) {
        return mv.getClass().equals(VncList.class);
    }

    public static boolean vector_Q(VncVal mv) {
        return mv.getClass().equals(VncVector.class);
    }

    private static void flatten(VncVal value, List<VncVal> result) {
        if (Types.isVncList(value)) {
            ((VncList)value).getList().forEach(v -> CoreFunctions.flatten(v, result));
        } else if (Types.isVncHashMap(value)) {
            ((VncHashMap)value).entries().forEach(e -> {
                result.add((VncVal)e.getKey());
                CoreFunctions.flatten((VncVal)e.getValue(), result);
            });
        } else {
            result.add(value);
        }
    }

    private static VncVal sort(String fnName, VncVal fnArgs, VncVal coll, Comparator<VncVal> c) {
        if (Types.isVncVector(coll)) {
            return new VncVector(((VncVector)coll).getList().stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncList(coll)) {
            return new VncList(((VncList)coll).getList().stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncSet(coll)) {
            return new VncList(((VncSet)coll).getList().stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncMap(coll)) {
            return new VncList(((VncMap)coll).toVncList().getList().stream().sorted(c).collect(Collectors.toList()));
        }
        throw new VncException(String.format("%s: collection type %s not supported", fnName, Types.getClassName(coll)));
    }
}

