/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.CallFrameBuilder;
import com.github.jlangch.venice.impl.util.IOStreamUtil;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.ThreadPoolUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class ShellFunctions {
    public static VncFunction sh = new VncFunction("sh"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sh & args)");
            this.setDoc("Passes the given strings to Runtime.exec() to launch a sub-process.\n\n Options are\n  :in        may be given followed by input source as InputStream,\n             Reader, File, ByteBuf, or String, to be fed to the\n             sub-process's stdin.\n  :in-enc    option may be given followed by a String, used as a\n             character encoding name (for example \"UTF-8\" or\n             \"ISO-8859-1\") to convert the input string specified\n             by the :in option to the sub-process's stdin. Defaults\n             to UTF-8. If the :in option provides a byte array,\n             then the bytes are passed unencoded, and this option\n             is ignored.\n  :out-enc   option may be given followed by :bytes or a String. If\n             a String is given, it will be used as a character\n             encoding name (for example \"UTF-8\" or \"ISO-8859-1\")\n             to convert the sub-process's stdout to a String which is\n             returned. If :bytes is given, the sub-process's stdout\n             will be stored in a Bytebuf and returned. Defaults to\n             UTF-8.\n  :env       override the process env with a map.\n  :dir       override the process dir with a String or java.io.File.\n  :throw-ex  If true throw an exception if the exit code is not equal\n             to zero, if false returns the exit code. Defaults to\n             false. It's recommended to use (with-sh-throw (sh \"foo\"))\n             instead.\n\nYou can bind :env, :dir for multiple operations using with-sh-env or\nwith-sh-dir. with-sh-throw is binds :throw-ex as true.\n\n sh returns a map of\n  :exit => sub-process's exit code\n  :out  => sub-process's stdout (as Bytebuf or String)\n  :err  => sub-process's stderr (String via platform default encoding)");
            this.setExamples("(println (sh \"ls\" \"-l\"))", "(println (sh \"ls\" \"-l\" \"/tmp\"))", "(println (sh \"sed\" \"s/[aeiou]/oo/g\" :in \"hello there\\n\"))", "(println (sh \"cat\" :in \"x\\u25bax\\n\"))", "(println (sh \"echo\" \"x\\u25bax\"))", "(println (sh \"/bin/sh\" \"-c\" \"ls -l\"))", ";; reads 4 single-byte chars\n(println (sh \"echo\" \"x\\u25bax\" :out-enc \"ISO-8859-1\"))", ";; reads binary file into bytes[]\n(println (sh \"cat\" \"birds.jpg\" :out-enc :bytes))", ";; working directory\n(println (with-sh-dir \"/tmp\" (sh \"ls\" \"-l\") (sh \"pwd\")))", "(println (sh \"pwd\" :dir \"/tmp\"))", ";; throw an exception if the shell's subprocess exit code is not equal to 0\n(println (with-sh-throw (sh \"ls\" \"-l\")))", "(println (sh \"ls\" \"-l\" :throw-ex true))", ";; windows\n(println (sh \"cmd\" \"/c dir 1>&2\"))");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("sh");
            FunctionsUtil.assertMinArity("sh", args, 1);
            ShellFunctions.validateArgs(args);
            VncVector v = ShellFunctions.parseArgs(args);
            VncList cmd = Coerce.toVncList(v.first());
            VncMap opts = Coerce.toVncMap(v.second());
            MetaUtil.copyTokenPos(args, cmd);
            MetaUtil.copyTokenPos(args, opts);
            ExecutorService executor = Executors.newFixedThreadPool(3, ThreadPoolUtil.createThreadFactory("venice-shell-pool-%d", threadPoolCounter, true));
            try {
                VncVal vncVal = ShellFunctions.exec(cmd, opts, executor);
                return vncVal;
            }
            finally {
                executor.shutdownNow();
            }
        }
    };
    private static final AtomicLong threadPoolCounter = new AtomicLong(0L);
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("sh", (VncVal)sh).toMap();

    /*
     * Exception decompiling
     */
    private static VncVal exec(VncList cmd, VncMap opts, ExecutorService executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File toFile(VncVal dir) {
        Object delegate;
        if (dir == Constants.Nil) {
            return null;
        }
        if (Types.isVncString(dir)) {
            return new File(((VncString)dir).getValue());
        }
        if (Types.isVncJavaObject(dir) && (delegate = ((VncJavaObject)dir).getDelegate()) instanceof File) {
            return (File)delegate;
        }
        return null;
    }

    private static String[] toStringArray(VncList list) {
        return list.getList().stream().map(it -> (VncVal)CoreFunctions.name.apply(new VncList((VncVal)it))).map(it -> ((VncString)it).getValue()).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static String[] toEnvStrings(VncVal envMap) {
        if (envMap == Constants.Nil) {
            return null;
        }
        return ((VncMap)envMap).entries().stream().map(e -> String.format("%s=%s", CoreFunctions.name.apply(new VncList((VncVal)e.getKey())), ((VncVal)e.getValue()).toString())).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static void validateArgs(VncList args) {
        args.forEach(arg -> {
            if (!(Types.isVncString(arg) || Types.isVncKeyword(arg) || Types.isVncBoolean(arg))) {
                ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal("sh", arg));
                throw new VncException(String.format("sh: accepts strings, keywords, and booleans only. Got an argument of type %s", Types.getClassName(arg)));
            }
        });
    }

    private static VncVector parseArgs(VncList args) {
        VncThreadLocal th = new VncThreadLocal();
        VncHashMap defaultOptions = new VncHashMap(new VncKeyword(":out-enc"), new VncString("UTF-8"), new VncKeyword(":in-enc"), new VncString("UTF-8"), new VncKeyword(":dir"), th.get(":*sh-dir*"), new VncKeyword(":throw-ex"), th.get(":*sh-throw-ex*"));
        VncMap defaultEnv = (VncMap)th.get(":*sh-env*", (VncVal)new VncHashMap(new VncVal[0]));
        VncVector v = Coerce.toVncVector((VncVal)CoreFunctions.split_with.apply(new VncList(CoreFunctions.string_Q, args)));
        VncList cmd = Coerce.toVncList(v.first());
        VncHashMap sh_opts = new VncHashMap((VncList)v.second());
        VncMap opts = (VncMap)CoreFunctions.merge.apply(new VncList(defaultOptions, sh_opts));
        opts = opts.assoc(new VncKeyword(":env"), (VncVal)CoreFunctions.merge.apply(new VncList(defaultEnv, ((VncMap)sh_opts).get(new VncKeyword(":env")))));
        return new VncVector(cmd, opts);
    }

    private static String getEncoding(VncVal enc) {
        return enc == Constants.Nil ? Charset.defaultCharset().name() : ((VncString)CoreFunctions.name.apply(new VncList(enc))).getValue();
    }

    private static Object copyAndClose(VncString data, String encoding, OutputStream os) throws IOException {
        IOStreamUtil.copyStringToOS(data.getValue(), os, encoding);
        os.flush();
        os.close();
        return null;
    }

    private static Object copyAndClose(VncByteBuffer data, OutputStream os) throws IOException {
        IOStreamUtil.copyByteArrayToOS(data.getValue().array(), os);
        os.flush();
        os.close();
        return null;
    }

    private static Object copyAndClose(File data, OutputStream os) throws IOException {
        IOStreamUtil.copyFileToOS(data, os);
        os.flush();
        os.close();
        return null;
    }

    private static /* synthetic */ VncVal lambda$exec$4(InputStream stderr) throws Exception {
        return new VncString(IOStreamUtil.copyIStoString(stderr, null));
    }

    private static /* synthetic */ VncVal lambda$exec$3(String enc, InputStream stdout) throws Exception {
        return "bytes".equals(enc) ? new VncByteBuffer(IOStreamUtil.copyIStoByteArray(stdout)) : new VncString(IOStreamUtil.copyIStoString(stdout, enc));
    }

    private static /* synthetic */ Object lambda$exec$2(VncVal in, OutputStream stdin) throws Exception {
        return ShellFunctions.copyAndClose((File)((VncJavaObject)in).getDelegate(), stdin);
    }

    private static /* synthetic */ Object lambda$exec$1(VncVal in, OutputStream stdin) throws Exception {
        return ShellFunctions.copyAndClose((VncByteBuffer)in, stdin);
    }

    private static /* synthetic */ Object lambda$exec$0(VncVal in, VncVal inEnc, OutputStream stdin) throws Exception {
        return ShellFunctions.copyAndClose((VncString)in, ShellFunctions.getEncoding(inEnc), stdin);
    }
}

