/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;

public class JavaInterop {
    private static final ThreadLocal<IInterceptor> threadInterceptor = ThreadLocal.withInitial(() -> new AcceptAllInterceptor());

    public static void enableReflectionCache(boolean enable) {
        ReflectionAccessor.enableCache(enable);
    }

    public static boolean isReflectionCacheEnabled() {
        return ReflectionAccessor.isCacheEnabled();
    }

    public static boolean isSandboxed() {
        return !(JavaInterop.getInterceptor() instanceof AcceptAllInterceptor);
    }

    public static void register(IInterceptor interceptor) {
        threadInterceptor.set(interceptor == null ? new AcceptAllInterceptor() : interceptor);
    }

    public static void unregister() {
        try {
            threadInterceptor.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IInterceptor getInterceptor() {
        return threadInterceptor.get();
    }
}

