/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import com.github.jlangch.venice.javainterop.DynamicInvocationHandler;

public class JavaInteropProxifyFn
extends VncFunction {
    private static final long serialVersionUID = -1848883965231344442L;
    private final JavaImports javaImports;

    public JavaInteropProxifyFn(JavaImports javaImports) {
        super("proxify");
        this.javaImports = javaImports;
        this.setArgLists("(proxify classname method-map)");
        this.setDoc("Proxifies a Java interface to be passed as a Callback object to Java functions. The interface's methods are implemented by Venice functions.");
        this.setExamples("(do \n   (import :java.io.File :java.io.FilenameFilter) \n\n   (def file-filter \n        (fn [dir name] (str/ends-with? name \".xxx\"))) \n\n   (let [dir (io/tmp-dir )] \n        ;; create a dynamic proxy for the interface FilenameFilter\n        ;; and implement its function 'accept' by 'file-filter'\n        (. dir :list (proxify :FilenameFilter {:accept file-filter}))) \n)");
    }

    @Override
    public VncVal apply(VncList args) {
        if (args.size() != 2) {
            throw new ArityException(args, 2, "proxify");
        }
        VncVal clazzVal = args.first();
        String className = Types.isVncKeyword(clazzVal) ? Coerce.toVncKeyword(clazzVal).getValue() : Coerce.toVncString(clazzVal).getValue();
        Class<?> clazz = ReflectionUtil.classForName(this.javaImports.resolveClassName(className));
        return new VncJavaObject(DynamicInvocationHandler.proxify(clazz, Coerce.toVncMap(args.second())));
    }
}

