/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.concurrent.atomic.AtomicReference;

public class VncAtom
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final AtomicReference<VncVal> state = new AtomicReference();

    public VncAtom(VncVal value) {
        this.state.set(value);
    }

    @Override
    public VncAtom copy() {
        VncAtom v = new VncAtom(this.state.get());
        v.setMeta(this.getMeta());
        return v;
    }

    public VncVal reset(VncVal newVal) {
        this.state.set(newVal);
        return newVal;
    }

    public VncVal deref() {
        return this.state.get();
    }

    public VncVal swap(VncFunction fn, VncList args) {
        VncList new_args;
        VncVal newValue;
        VncVal oldValue;
        do {
            oldValue = this.deref();
            new_args = new VncList(new VncVal[0]);
            new_args.getList().addAll(args.getList());
            new_args.getList().add(0, oldValue);
        } while (!this.state.compareAndSet(oldValue, newValue = (VncVal)fn.apply(new_args)));
        return this.state.get();
    }

    public VncVal compare_and_set(VncVal expectValue, VncVal newValue) {
        VncVal oldValue = this.deref();
        if (oldValue.equals(expectValue)) {
            return this.state.compareAndSet(oldValue, newValue) ? Constants.True : Constants.False;
        }
        return Constants.False;
    }

    public String toString() {
        return "(atom " + Printer._pr_str(this.state.get(), true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(atom " + Printer._pr_str(this.state.get(), print_readably) + ")";
    }
}

