/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;

public class VncSymbol
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final String value;

    public VncSymbol(String v) {
        this.value = v;
    }

    public VncSymbol(VncString v) {
        this.value = v.getValue();
    }

    @Override
    public VncSymbol copy() {
        VncSymbol v = new VncSymbol(this.value);
        v.setMeta(this.getMeta());
        return v;
    }

    public String getName() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncSymbol(o)) {
            return this.getName().compareTo(((VncSymbol)o).getName());
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncSymbol other = (VncSymbol)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value;
    }
}

