/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.impl.util.IOStreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;

public class FileUtil {
    private static final int MAX_DIR_LEVELS = 32;

    private FileUtil() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File source, File destination, boolean overwrite) {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            if (overwrite && destination.exists() && !destination.delete()) {
                throw new RuntimeException("Failed to delete existing destination file: " + destination);
            }
            inStream = new FileInputStream(source);
            outStream = new FileOutputStream(destination);
            IOStreamUtil.copy(inStream, outStream);
            outStream.close();
            outStream = null;
        }
        catch (IOException ex) {
            try {
                throw new FileException("Failed to copy file from <" + source + "> to <" + destination + ">.", ex);
                catch (RuntimeException ex2) {
                    throw new FileException("Failed to copy file from <" + source + "> to <" + destination + ">.", ex2);
                }
            }
            catch (Throwable throwable) {
                FileUtil.silentClose(inStream);
                FileUtil.silentClose(outStream);
                throw throwable;
            }
        }
        FileUtil.silentClose(inStream);
        FileUtil.silentClose(outStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] load(File source) {
        byte[] byArray;
        FileInputStream inStream = null;
        ByteArrayOutputStream outStream = null;
        try {
            inStream = new FileInputStream(source);
            outStream = new ByteArrayOutputStream();
            IOStreamUtil.copy(inStream, outStream);
            outStream.flush();
            byArray = outStream.toByteArray();
        }
        catch (IOException ex) {
            try {
                throw new FileException("Failed to load file <" + source + ">.", ex);
                catch (RuntimeException ex2) {
                    throw new FileException("Failed to load file <" + source + ">.", ex2);
                }
            }
            catch (Throwable throwable) {
                FileUtil.silentClose(inStream);
                FileUtil.silentClose(outStream);
                throw throwable;
            }
        }
        FileUtil.silentClose(inStream);
        FileUtil.silentClose(outStream);
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void save(byte[] data, File destination, boolean overwrite) {
        FileOutputStream outStream = null;
        try {
            if (overwrite && destination.exists() && !destination.delete()) {
                throw new RuntimeException("Failed to delete existing destination file: " + destination);
            }
            outStream = new FileOutputStream(destination);
            ((OutputStream)outStream).write(data, 0, data.length);
            outStream.flush();
            ((OutputStream)outStream).close();
            outStream = null;
        }
        catch (IOException ex) {
            try {
                throw new FileException("Failed to save to file <" + destination + ">.", ex);
                catch (RuntimeException ex2) {
                    throw new FileException("Failed to save to file <" + destination + ">.", ex2);
                }
            }
            catch (Throwable throwable) {
                FileUtil.silentClose(outStream);
                throw throwable;
            }
        }
        FileUtil.silentClose(outStream);
    }

    public static void append(byte[] data, File destination) {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(destination, true);
            ((OutputStream)outStream).write(data, 0, data.length);
            outStream.flush();
            ((OutputStream)outStream).close();
            outStream = null;
        }
        catch (Exception ex) {
            try {
                throw new FileException("Failed to append to file <" + destination + ">.", ex);
            }
            catch (Throwable throwable) {
                FileUtil.silentClose(outStream);
                throw throwable;
            }
        }
        FileUtil.silentClose(outStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void save(InputStream inStream, File destination, boolean overwrite) {
        FileOutputStream outStream = null;
        try {
            if (overwrite && destination.exists() && !destination.delete()) {
                throw new RuntimeException("Failed to delete existing destination file: " + destination);
            }
            outStream = new FileOutputStream(destination);
            IOStreamUtil.copy(inStream, outStream);
            outStream.flush();
            ((OutputStream)outStream).close();
            outStream = null;
        }
        catch (IOException ex) {
            try {
                throw new FileException("Failed to data to file <" + destination + ">.", ex);
                catch (RuntimeException ex2) {
                    throw new FileException("Failed to data to file <" + destination + ">.", ex2);
                }
            }
            catch (Throwable throwable) {
                FileUtil.silentClose(outStream);
                throw throwable;
            }
        }
        FileUtil.silentClose(outStream);
    }

    public static void save(String text, File destination, boolean overwrite) {
        try {
            FileUtil.save(text.getBytes("utf-8"), destination, overwrite);
        }
        catch (UnsupportedEncodingException ex) {
            throw new FileException("Failed to save to file <" + destination + ">.", ex);
        }
    }

    public static int deleteFiles(File path, FilenameFilter filter) {
        if (path == null) {
            throw new IllegalArgumentException("A path must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("A filter must not be null");
        }
        int count = 0;
        File[] files = path.listFiles(filter);
        if (files != null) {
            for (int ii = 0; ii < files.length; ++ii) {
                if (!files[ii].delete()) continue;
                ++count;
            }
        }
        return count;
    }

    public static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static String getCurrentWorkDir() {
        File f = new File(".");
        String cwd = f.getAbsolutePath();
        return cwd.substring(0, cwd.length() - 2);
    }

    public static boolean isAbsoultePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("A 'path' must not be <null>");
        }
        if (path.startsWith("/") || path.startsWith("\\")) {
            return true;
        }
        return path.matches("^[A-Z]:.*");
    }

    public static void touch(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        FileUtil.touch(file, System.currentTimeMillis());
    }

    public static void touch(File file, long modificationTime) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new FileException("File <" + file + "> existed already");
                }
            }
            catch (IOException ex) {
                throw new FileException("Failed to create new file <" + file + ">.", ex);
            }
        }
        if (!file.canWrite()) {
            throw new FileException("Can not change modification date of read-only-file <" + file + ">.");
        }
        if (!file.setLastModified(modificationTime)) {
            throw new FileException("Can not change modification date of file <" + file + ">.");
        }
    }

    public static void delete(File file) {
        boolean deleted;
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (file.exists() && !(deleted = file.delete())) {
            throw new FileException("Failed to delete " + (file.isDirectory() ? "directory" : "file") + " <" + file + ">.");
        }
    }

    public static void mkdir(File dir) {
        boolean created;
        if (dir == null) {
            throw new IllegalArgumentException("A dir must not be null");
        }
        if (!dir.isDirectory() && !(created = dir.mkdir())) {
            throw new FileException("Failed to create directory <" + dir + ">.");
        }
    }

    public static void mkdirs(File dir) {
        boolean created;
        if (dir == null) {
            throw new IllegalArgumentException("A dir must not be null");
        }
        if (!dir.isDirectory() && !(created = dir.mkdirs())) {
            throw new FileException("Failed to create directory <" + dir + "> with its nonexistent parent directories.");
        }
    }

    public static void rmdir(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("A dir must not be null");
        }
        try {
            FileUtil.doRmDir(dir, 0);
        }
        catch (Exception ex) {
            throw new FileException("Failed to delete directory <" + dir + ">.", ex);
        }
    }

    public static void copydir(File srcdir, File dstdir) {
        if (srcdir == null) {
            throw new IllegalArgumentException("A source dir must not be null");
        }
        if (dstdir == null) {
            throw new IllegalArgumentException("A destination dir must not be null");
        }
        try {
            FileUtil.doCopyDir(srcdir, dstdir, 0);
        }
        catch (RuntimeException ex) {
            throw new FileException("Failed to copy directory <" + srcdir + ">.", ex);
        }
    }

    public static Date getFileCreationDate(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return new Date(attr.creationTime().toMillis());
        }
        catch (Exception ex) {
            throw new FileException("Failed to get file creation date. File " + file.getPath(), ex);
        }
    }

    public static String replaceFileExt(String fileName, String fileExt) {
        if (fileName == null) {
            throw new IllegalArgumentException("A fileName must not be null");
        }
        if (fileExt == null) {
            throw new IllegalArgumentException("A fileExt must not be null");
        }
        String extension = fileExt;
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        int pos = fileName.lastIndexOf(46);
        return (pos < 0 ? fileName : fileName.substring(0, pos)) + "." + extension;
    }

    public static String getFileExt(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("A fileName must not be null");
        }
        int pos = fileName.lastIndexOf(46);
        return pos < 0 ? null : fileName.substring(pos + 1);
    }

    public static String getFileBaseName(String fileName) {
        int pos = fileName.lastIndexOf(46);
        return pos < 0 ? null : fileName.substring(0, pos);
    }

    public static String getFileExtensionLowerCase(String fileName) {
        String ext = FileUtil.getFileExt(fileName);
        return ext == null ? null : ext.toLowerCase();
    }

    private static void doRmDir(File dir, int level) {
        if (level > 32) {
            throw new FileException("Reached max dir level (32)");
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                FileUtil.doRmDir(file, level + 1);
                continue;
            }
            if (file.delete()) continue;
            throw new RuntimeException("Could not delete file " + file.getAbsolutePath());
        }
        if (!dir.delete()) {
            throw new RuntimeException("Could not delete directory " + dir.getAbsolutePath());
        }
    }

    private static void doCopyDir(File srcdir, File dstdir, int level) {
        if (level > 32) {
            throw new FileException("Reached max dir level (32)");
        }
        if (!dstdir.exists()) {
            FileUtil.mkdir(dstdir);
        }
        for (File file : srcdir.listFiles()) {
            if (file.isDirectory()) {
                FileUtil.doCopyDir(new File(srcdir, file.getName()), new File(dstdir, file.getName()), level + 1);
                continue;
            }
            FileUtil.copy(file, new File(dstdir, file.getName()), true);
        }
    }

    private static void silentClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void silentClose(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

