/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SandboxRules {
    private static final List<String> DEFAULT_CLASS_RULES = Arrays.asList("com.github.jlangch.venice.impl.javainterop.DynamicInvocationHandler*:*", "com.github.jlangch.venice.util.CapturingPrintStream:*", "com.github.jlangch.venice.impl.ValueException:*", "com.github.jlangch.venice.impl.types.collections.VncVector", "com.github.jlangch.venice.impl.util.Delay:*", "com.github.jlangch.venice.impl.util.Agent:*", "com.sun.proxy.$Proxy*:*", "java.lang.IllegalArgumentException:*", "java.lang.RuntimeException:*", "java.lang.Exception:*", "java.lang.SecurityException:*", "java.io.IOException:*", "java.io.PrintStream:append", "java.io.InputStream", "java.io.OutputStream", "java.lang.Object", "java.lang.Object:class", "java.lang.Character", "java.lang.String", "java.lang.Boolean", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Byte", "java.lang.StringBuffer", "java.lang.StringBuilder", "java.time.ZonedDateTime:*", "java.time.LocalDateTime:*", "java.time.LocalDate:*", "java.math.BigInteger", "java.math.BigDecimal", "java.nio.ByteBuffer", "java.nio.HeapByteBuffer:*", "java.util.Date:*", "java.util.ArrayList:*", "java.util.HashSet:*", "java.util.HashMap:*", "java.util.LinkedHashMap:*", "java.util.Locale:*");
    public static final Set<String> DEFAULT_SYSTEM_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("file.separator", "java.home", "java.vendor", "java.vendor.url", "java.version", "line.separator", "os.arch", "os.name", "os.version", "path.separator", "user.dir", "user.home", "user.name")));
    private final Set<String> rules = new HashSet<String>();

    public SandboxRules() {
        this(true);
    }

    private SandboxRules(boolean withDefaults) {
        if (withDefaults) {
            this.withDefaultClasses();
        }
    }

    public static SandboxRules noDefaults() {
        return new SandboxRules(false);
    }

    public SandboxRules withClasses(String ... rules) {
        if (rules != null) {
            this.withClasses(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withClasses(List<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> "class:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withClasses(Class<?> ... classes) {
        if (classes != null) {
            this.withClasses((Collection<Class<?>>)Arrays.asList(classes));
        }
        return this;
    }

    public SandboxRules withClasses(Collection<Class<?>> classes) {
        if (classes != null) {
            this.withClasses(classes.stream().map(c -> c.getName() + ":*").collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withDefaultClasses() {
        this.withClasses(DEFAULT_CLASS_RULES);
        return this;
    }

    public SandboxRules withClasspathResources(String ... rules) {
        if (rules != null) {
            this.withClasspathResources(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withClasspathResources(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> "classpath:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withSystemProperties(String ... rules) {
        if (rules != null) {
            this.withSystemProperties(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withSystemProperties(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> "system.property:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withBlacklistedVeniceFn(String ... rules) {
        if (rules != null) {
            this.withBlacklistedVeniceFn(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withBlacklistedVeniceFn(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> "blacklist:venice:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules rejectAllVeniceIoFunctions() {
        if (this.rules != null) {
            this.withBlacklistedVeniceFn("*io*");
        }
        return this;
    }

    public SandboxRules allowAccessToStandardSystemProperties() {
        this.withSystemProperties(DEFAULT_SYSTEM_PROPERTIES);
        return this;
    }

    public SandboxRules allowAccessToAllSystemProperties() {
        this.withSystemProperties("*");
        return this;
    }

    public SandboxRules merge(SandboxRules other) {
        SandboxRules merged = new SandboxRules();
        merged.rules.addAll(this.rules);
        merged.rules.addAll(other.rules);
        return merged;
    }

    public Set<String> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    public static List<String> getDefaultRules() {
        return new SandboxRules().getRules().stream().sorted().collect(Collectors.toList());
    }

    public String toString() {
        return new ArrayList<String>(this.rules).stream().sorted().collect(Collectors.joining("\n"));
    }
}

