/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import com.github.jlangch.venice.util.CallFrame;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class CallStack {
    private final ConcurrentLinkedQueue<CallFrame> queue = new ConcurrentLinkedQueue();

    public void push(CallFrame frame) {
        this.queue.offer(frame);
    }

    public CallFrame pop() {
        return this.queue.poll();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void clear() {
        this.queue.clear();
    }

    public CallStack copy() {
        CallStack stack = new CallStack();
        this.queue.forEach(f -> stack.queue.add((CallFrame)f));
        return stack;
    }

    public List<String> toList() {
        List<String> callstack = Arrays.stream(this.queue.toArray(new CallFrame[0])).map(f -> f.toString()).collect(Collectors.toList());
        Collections.reverse(callstack);
        return callstack;
    }

    public List<CallFrame> callstack() {
        List<CallFrame> callstack = Arrays.asList(this.queue.toArray(new CallFrame[0]));
        Collections.reverse(callstack);
        return callstack;
    }

    public String toString() {
        return this.toList().stream().collect(Collectors.joining("\n"));
    }
}

