/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.JavaValueException;
import com.github.jlangch.venice.PreCompiled;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.ValueException;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.Callable;

public class Venice {
    private final IInterceptor interceptor;

    public Venice() {
        this(null);
    }

    public Venice(IInterceptor interceptor) {
        this.interceptor = interceptor == null ? new AcceptAllInterceptor() : interceptor;
    }

    public PreCompiled precompile(String scriptName, String script) {
        if (StringUtil.isBlank(scriptName)) {
            throw new IllegalArgumentException("A 'scriptName' must not be blank");
        }
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        VeniceInterpreter venice = new VeniceInterpreter();
        Env env = this.createEnv(venice, null);
        Env root = env.getRootEnv();
        root.setGlobal(new DynamicVar(new VncSymbol("*out*"), Constants.Nil));
        return new PreCompiled(scriptName, venice.READ(script, scriptName), env);
    }

    public Object eval(PreCompiled precompiled) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        return this.eval(precompiled, null);
    }

    public Object eval(PreCompiled precompiled, Map<String, Object> params) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        Env root = precompiled.getEnv().getRootEnv();
        root.setGlobal(new DynamicVar(new VncSymbol("*out*"), new VncJavaObject(new PrintStream(System.out, true))));
        return this.runWithSandbox(() -> {
            VeniceInterpreter venice = new VeniceInterpreter();
            Env env = this.addParams(new Env(precompiled.getEnv()), params);
            VncVal result = venice.EVAL((VncVal)precompiled.getPrecompiled(), env);
            return JavaInteropUtil.convertToJavaObject(result);
        });
    }

    public Object eval(String script) {
        return this.eval(null, script, null);
    }

    public Object eval(String scriptName, String script) {
        return this.eval(scriptName, script, null);
    }

    public Object eval(String script, Map<String, Object> params) {
        return this.eval(null, script, params);
    }

    public Object eval(String scriptName, String script, Map<String, Object> params) {
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        return this.runWithSandbox(() -> {
            VeniceInterpreter venice = new VeniceInterpreter();
            Env env = this.createEnv(venice, params);
            VncVal result = venice.RE(script, scriptName, env);
            return JavaInteropUtil.convertToJavaObject(result);
        });
    }

    public static String getVersion() {
        return "1.1.1";
    }

    public void enableJavaInteropReflectionCache(boolean enable) {
        ReflectionAccessor.enableCache(enable);
    }

    public boolean isJavaInteropReflectionCacheEnabled() {
        return ReflectionAccessor.isCacheEnabled();
    }

    private Env createEnv(VeniceInterpreter venice, Map<String, Object> params) {
        Env env = venice.createEnv();
        this.addParams(env, params);
        return env;
    }

    private Env addParams(Env env, Map<String, Object> params) {
        if (params != null) {
            params.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                VncSymbol symbol = new VncSymbol(key);
                if (key.equals("*out*")) {
                    env.setGlobal(new DynamicVar(symbol, JavaInteropUtil.convertToVncVal(this.buildStdOutPrintStream(val))));
                } else {
                    env.setGlobal(new Var(symbol, JavaInteropUtil.convertToVncVal(val)));
                }
            });
        }
        return env;
    }

    private PrintStream buildStdOutPrintStream(Object val) {
        if (val == null) {
            return new PrintStream(new NullOutputStream());
        }
        if (val instanceof PrintStream) {
            return (PrintStream)val;
        }
        if (val instanceof OutputStream) {
            return new PrintStream((OutputStream)val, true);
        }
        throw new VncException("The *out* parameter value must be either null or an instance of PrintStream or OutputStream");
    }

    private Object runWithSandbox(Callable<Object> callable) {
        try {
            JavaInterop.register(this.interceptor);
            Object object = callable.call();
            return object;
        }
        catch (ValueException ex) {
            throw new JavaValueException(JavaInteropUtil.convertToJavaObject(ex.getValue()));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            ThreadLocalMap.remove();
            JavaInterop.unregister();
        }
    }
}

