/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.util.CallFrame;
import com.github.jlangch.venice.util.CallStack;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.stream.Collectors;

public class VncException
extends RuntimeException {
    private static final long serialVersionUID = 5439694361809280080L;
    private final CallStack callstack = ThreadLocalMap.getCallStack().copy();

    public VncException() {
    }

    public VncException(String message) {
        super(message);
    }

    public VncException(String message, Throwable cause) {
        super(message, cause);
    }

    public VncException(Throwable cause) {
        super(cause);
    }

    public boolean hasCallStack() {
        return !this.callstack.isEmpty();
    }

    public List<CallFrame> getCallStack() {
        return this.callstack.callstack();
    }

    public List<String> getCallStackAsStringList() {
        return this.getCallStack().stream().map(v -> this.callFrameToString((CallFrame)v)).collect(Collectors.toList());
    }

    public String getCallStackAsString(String indent) {
        return this.getCallStack().stream().map(v -> (indent == null ? "" : indent) + this.callFrameToString((CallFrame)v)).collect(Collectors.joining("\n"));
    }

    public void printVeniceStackTrace() {
        this.printVeniceStackTrace(System.out);
    }

    public void printVeniceStackTrace(PrintStream ps) {
        this.printVeniceStackTrace(new PrintWriter(ps));
    }

    public void printVeniceStackTrace(PrintWriter pw) {
        pw.println(String.format("Exception in thread \"%s\" %s: %s", Thread.currentThread().getName(), this.getClass().getSimpleName(), this.getMessage()));
        if (this.hasCallStack()) {
            pw.println(this.getCallStackAsString("    at: "));
        }
        if (this.getCause() != null) {
            this.printVeniceCauseStackTrace(pw, this.getCause());
        }
        pw.flush();
    }

    public String printVeniceStackTraceToString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printVeniceStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private void printVeniceCauseStackTrace(PrintWriter pw, Throwable ex) {
        VncException vncEx;
        pw.println(String.format("Caused by: %s: %s", ex instanceof VncException ? ex.getClass().getSimpleName() : ex.getClass().getName(), ex.getMessage()));
        if (ex instanceof VncException && (vncEx = (VncException)ex).hasCallStack()) {
            pw.println(vncEx.getCallStackAsString("    at: "));
        }
        if (ex.getCause() != null) {
            this.printVeniceCauseStackTrace(pw, ex.getCause());
        }
    }

    private String callFrameToString(CallFrame callFrame) {
        return callFrame.getFnName() == null ? String.format("%s: line %d, col %d", callFrame.getFile(), callFrame.getLine(), callFrame.getCol()) : String.format("%s (%s: line %d, col %d)", callFrame.getFnName(), callFrame.getFile(), callFrame.getLine(), callFrame.getCol());
    }
}

