/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.util.CallStack;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class SystemFunctions {
    public static VncFunction version = new VncFunction("version"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(version)");
            this.setDoc("Returns the version.");
            this.setExamples("(version )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("version", args, 0);
            return new VncString("1.1.1");
        }
    };
    public static VncFunction uuid = new VncFunction("uuid"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(uuid)");
            this.setDoc("Generates a UUID.");
            this.setExamples("(uuid )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("uuid", args, 0);
            return new VncString(UUID.randomUUID().toString());
        }
    };
    public static VncFunction objid = new VncFunction("oobjid"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(objid)");
            this.setDoc("Returns the original unique hash code for the given object.");
            this.setExamples("(objid x)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("objid", args, 1);
            return new VncLong(System.identityHashCode(args.first()));
        }
    };
    public static VncFunction current_time_millis = new VncFunction("current-time-millis"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(current-time-millis)");
            this.setDoc("Returns the current time in milliseconds.");
            this.setExamples("(current-time-millis)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("current-time-millis", args, 0);
            return new VncLong(System.currentTimeMillis());
        }
    };
    public static VncFunction nano_time = new VncFunction("nano-time"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(nano-time)");
            this.setDoc("Returns the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds.");
            this.setExamples("(nano-time)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nano-time", args, 0);
            return new VncLong(System.nanoTime());
        }
    };
    public static VncFunction sleep = new VncFunction("sleep"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sleep n)");
            this.setDoc("Sleep for n milliseconds.");
            this.setExamples("(sleep 30)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sleep", args, 1);
            try {
                Thread.sleep(Coerce.toVncLong(args.first()).getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Constants.Nil;
        }
    };
    public static VncFunction callstack = new VncFunction("callstack"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(callstack )");
            this.setDoc("Returns the current callstack.");
            this.setExamples("(do                             \n   (defn f1 [x] (f2 x))         \n   (defn f2 [x] (f3 x))         \n   (defn f3 [x] (f4 x))         \n   (defn f4 [x] (callstack))    \n   (f1 100))                      ");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("callstack", args, 0);
            CallStack stack = ThreadLocalMap.getCallStack();
            return new VncVector(stack.callstack().stream().map(f -> new VncOrderedMap(CALLSTACK_KEY_FN_NAME, f.getFnName() == null ? Constants.Nil : new VncString(f.getFnName()), CALLSTACK_KEY_FILE, new VncString(f.getFile()), CALLSTACK_KEY_LINE, new VncLong(f.getLine()), CALLSTACK_KEY_COL, new VncLong(f.getCol()))).collect(Collectors.toList()));
        }
    };
    public static VncFunction os = new VncFunction("os"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(os)");
            this.setDoc("Returns the OS type");
            this.setExamples("(os)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("os", args, 0);
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                return new VncKeyword("windows");
            }
            if (osName.startsWith("Mac OS X")) {
                return new VncKeyword("mac-osx");
            }
            if (osName.startsWith("LINUX")) {
                return new VncKeyword("linux");
            }
            return new VncKeyword("unknown");
        }
    };
    public static VncFunction os_Q = new VncFunction("os?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(os? type)");
            this.setDoc("Returns true if the OS id of the type otherwise false. Type is one of :windows, :mac-osx, or :linux");
            this.setExamples("(os? :mac-osx)", "(os? :windows)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("os?", args, 1);
            String type = Coerce.toVncKeyword(args.first()).getValue();
            String osName = System.getProperty("os.name");
            switch (type) {
                case "windows": {
                    return osName.startsWith("Windows") ? Constants.True : Constants.False;
                }
                case "mac-osx": {
                    return osName.startsWith("Mac OS X") ? Constants.True : Constants.False;
                }
                case "linux": {
                    return osName.startsWith("LINUX") ? Constants.True : Constants.False;
                }
            }
            return Constants.False;
        }
    };
    public static VncFunction sandboxed_Q = new VncFunction("sandboxed?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sandboxed? )");
            this.setDoc("Returns true if there is a sandbox otherwise false");
            this.setExamples("(sandboxed? )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sandboxed?", args, 0);
            return JavaInterop.isSandboxed() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction system_prop = new VncFunction("system-prop"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(system-prop name default-val)");
            this.setDoc("Returns the system property with the given name. Returns the default-val if the property does not exist or it's value is nil");
            this.setExamples("(system-prop :os.name)", "(system-prop :foo.org \"abc\")", "(system-prop \"os.name\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("system-prop", args, 1, 2);
            VncString key = Coerce.toVncString((VncVal)CoreFunctions.name.apply(new VncList(args.first())));
            VncVal defaultVal = args.size() == 2 ? args.second() : Constants.Nil;
            String val = JavaInterop.getInterceptor().onReadSystemProperty(key.getValue());
            return val == null ? defaultVal : new VncString(val);
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("uuid", (VncVal)uuid).put("objid", (VncVal)objid).put("current-time-millis", (VncVal)current_time_millis).put("nano-time", (VncVal)nano_time).put("sandboxed?", (VncVal)sandboxed_Q).put("sleep", (VncVal)sleep).put("callstack", (VncVal)callstack).put("os", (VncVal)os).put("os?", (VncVal)os_Q).put("version", (VncVal)version).put("system-prop", (VncVal)system_prop).toMap();
    public static final VncKeyword CALLSTACK_KEY_FN_NAME = new VncKeyword(":fn-name");
    public static final VncKeyword CALLSTACK_KEY_FILE = new VncKeyword(":file");
    public static final VncKeyword CALLSTACK_KEY_LINE = new VncKeyword(":line");
    public static final VncKeyword CALLSTACK_KEY_COL = new VncKeyword(":col");
}

