/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TimeFunctions {
    public static VncFunction date = new VncFunction("time/date"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/date)", "(time/date x)");
            this.setDoc("Creates a new date. A date is represented by 'java.util.Date'");
            this.setExamples("(time/date)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/date", args, 0, 1);
            if (args.size() == 0) {
                return new VncJavaObject(new Date());
            }
            VncVal val = args.first();
            if (Types.isVncLong(val)) {
                long millis = ((VncLong)val).getValue();
                return new VncJavaObject(new Date(millis));
            }
            if (Types.isVncJavaObject(val)) {
                Object date = ((VncJavaObject)val).getDelegate();
                if (date instanceof Date) {
                    return new VncJavaObject(new Date(((Date)date).getTime()));
                }
                if (date instanceof LocalDate) {
                    return new VncJavaObject(new Date(((LocalDate)date).atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
                }
                if (date instanceof LocalDateTime) {
                    return new VncJavaObject(new Date(((LocalDateTime)date).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
                }
                if (date instanceof ZonedDateTime) {
                    return new VncJavaObject(new Date(((ZonedDateTime)date).toInstant().toEpochMilli()));
                }
            }
            throw new VncException(String.format("Function 'time/date' does not allow %s as parameter", Types.getClassName(val)));
        }
    };
    public static VncFunction date_Q = new VncFunction("time/date?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/date? date)");
            this.setDoc("Returns true if date is a date else false");
            this.setExamples("(time/date? (time/date))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/date?", args, 1);
            return Types.isVncJavaObject(args.first(), Date.class) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction local_date = new VncFunction("time/local-date"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/local-date)", "(time/local-date year month day)", "(time/local-date date)");
            this.setDoc("Creates a new local-date. A local-date is represented by 'java.time.LocalDate'");
            this.setExamples("(time/local-date)", "(time/local-date 2018 8 1)", "(time/local-date \"2018-08-01\")", "(time/local-date 1375315200000)", "(time/local-date (. :java.util.Date :new))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/local-date", args, 0, 1, 3);
            if (args.size() == 0) {
                return new VncJavaObject(LocalDate.now());
            }
            if (args.size() == 1) {
                VncVal val = args.first();
                if (Types.isVncJavaObject(val)) {
                    Object obj = ((VncJavaObject)val).getDelegate();
                    if (obj instanceof Date) {
                        long millis = ((Date)obj).getTime();
                        return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDate());
                    }
                    if (obj instanceof ZonedDateTime) {
                        return new VncJavaObject(((ZonedDateTime)obj).toLocalDate());
                    }
                    if (obj instanceof LocalDateTime) {
                        return new VncJavaObject(((LocalDateTime)obj).toLocalDate());
                    }
                    if (obj instanceof LocalDate) {
                        return val;
                    }
                    throw new VncException(String.format("Function 'time/local-date' does not allow %s as parameters", Types.getClassName(val)));
                }
                if (Types.isVncString(val)) {
                    String s = ((VncString)val).getValue();
                    return new VncJavaObject(LocalDate.parse(s));
                }
                if (Types.isVncLong(val)) {
                    long millis = ((VncLong)val).getValue();
                    return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDate());
                }
                throw new VncException(String.format("Function 'time/local-date' does not allow %s as parameter", Types.getClassName(val)));
            }
            return new VncJavaObject(LocalDate.of(Coerce.toVncLong(args.nth(0)).getValue().intValue(), Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue()));
        }
    };
    public static VncFunction local_date_Q = new VncFunction("time/local-date?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/local-date? date)");
            this.setDoc("Returns true if date is a locale date else false");
            this.setExamples("(time/local-date? (time/local-date))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/local-date?", args, 1);
            return Types.isVncJavaObject(args.first(), LocalDate.class) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction local_date_parse = new VncFunction("time/local-date-parse"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/local-date-parse str format locale?");
            this.setDoc("Parses a local-date.");
            this.setExamples("(time/local-date-parse \"2018-08-01\" \"yyyy-MM-dd\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/local-date-parse", args, 2, 3);
            VncString date = Coerce.toVncString(args.first());
            DateTimeFormatter formatter = TimeFunctions.getDateTimeFormatter(args.second());
            Locale locale = args.size() == 3 ? TimeFunctions.getLocale(args.nth(2)) : null;
            return new VncJavaObject(LocalDate.parse(date.getValue(), TimeFunctions.localize(formatter, locale)));
        }
    };
    public static VncFunction local_date_time = new VncFunction("time/local-date-time"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/local-date-time)", "(time/local-date-time year month day)", "(time/local-date-time year month day hour minute second)", "(time/local-date-time year month day hour minute second millis)", "(time/local-date-time date)");
            this.setDoc("Creates a new local-date-time. A local-date-time is represented by 'java.time.LocalDateTime'");
            this.setExamples("(time/local-date-time)", "(time/local-date-time 2018 8 1)", "(time/local-date-time 2018 8 1 14 20 10)", "(time/local-date-time 2018 8 1 14 20 10 200)", "(time/local-date-time \"2018-08-01T14:20:10.200\")", "(time/local-date-time 1375315200000)", "(time/local-date-time (. :java.util.Date :new))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/local-date-time", args, 0, 1, 3, 6, 7);
            if (args.size() == 0) {
                return new VncJavaObject(LocalDateTime.now());
            }
            if (args.size() == 1) {
                VncVal val = args.first();
                if (Types.isVncJavaObject(val)) {
                    Object obj = ((VncJavaObject)val).getDelegate();
                    if (obj instanceof Date) {
                        long millis = ((Date)obj).getTime();
                        return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime());
                    }
                    if (obj instanceof ZonedDateTime) {
                        return new VncJavaObject(((ZonedDateTime)obj).toLocalDateTime());
                    }
                    if (obj instanceof LocalDateTime) {
                        return val;
                    }
                    if (obj instanceof LocalDate) {
                        return new VncJavaObject(((LocalDate)obj).atTime(0, 0, 0));
                    }
                    throw new VncException(String.format("Function 'time/local-date-time' does not allow %s as parameters", Types.getClassName(val)));
                }
                if (Types.isVncString(val)) {
                    String s = ((VncString)val).getValue();
                    return new VncJavaObject(LocalDateTime.parse(s));
                }
                if (Types.isVncLong(val)) {
                    long millis = ((VncLong)val).getValue();
                    return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime());
                }
                throw new VncException(String.format("Function 'time/local-date-time' does not allow %s as parameter", Types.getClassName(val)));
            }
            if (args.size() == 3) {
                return new VncJavaObject(LocalDateTime.of(Coerce.toVncLong(args.nth(0)).getValue().intValue(), Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), 0, 0, 0, 0));
            }
            if (args.size() == 6) {
                return new VncJavaObject(LocalDateTime.of(Coerce.toVncLong(args.nth(0)).getValue().intValue(), Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), Coerce.toVncLong(args.nth(3)).getValue().intValue(), Coerce.toVncLong(args.nth(4)).getValue().intValue(), Coerce.toVncLong(args.nth(5)).getValue().intValue(), 0));
            }
            return new VncJavaObject(LocalDateTime.of(Coerce.toVncLong(args.nth(0)).getValue().intValue(), Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), Coerce.toVncLong(args.nth(3)).getValue().intValue(), Coerce.toVncLong(args.nth(4)).getValue().intValue(), Coerce.toVncLong(args.nth(5)).getValue().intValue(), Coerce.toVncLong(args.nth(6)).getValue().intValue() * 1000000));
        }
    };
    public static VncFunction local_date_time_Q = new VncFunction("time/local-date-time?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/local-date-time? date)");
            this.setDoc("Returns true if date is a local-date-time else false");
            this.setExamples("(time/local-date-time? (time/local-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/local-date-time?", args, 1);
            return Types.isVncJavaObject(args.first(), LocalDateTime.class) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction local_date_time_parse = new VncFunction("time/local-date-time-parse"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/local-date-time-parse str format locale?");
            this.setDoc("Parses a local-date-time.");
            this.setExamples("(time/local-date-time-parse \"2018-08-01 14:20\" \"yyyy-MM-dd HH:mm\")", "(time/local-date-time-parse \"2018-08-01 14:20:01.000\" \"yyyy-MM-dd HH:mm:ss.SSS\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/local-date-time-parse", args, 2, 3);
            VncString date = Coerce.toVncString(args.first());
            DateTimeFormatter formatter = TimeFunctions.getDateTimeFormatter(args.second());
            Locale locale = args.size() == 3 ? TimeFunctions.getLocale(args.nth(2)) : null;
            return new VncJavaObject(LocalDateTime.parse(date.getValue(), TimeFunctions.localize(formatter, locale)));
        }
    };
    public static VncFunction zoned_date_time = new VncFunction("time/zoned-date-time"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/zoned-date-time )", "(time/zoned-date-time year month day)", "(time/zoned-date-time year month day hour minute second)", "(time/zoned-date-time year month day hour minute second millis)", "(time/zoned-date-time date)", "(time/zoned-date-time zone-id)", "(time/zoned-date-time zone-id year month day)", "(time/zoned-date-time zone-id year month day hour minute second)", "(time/zoned-date-time zone-id year month day hour minute second millis)", "(time/zoned-date-time zone-id date)");
            this.setDoc("Creates a new zoned-date-time. A zoned-date-time is represented by 'java.time.ZonedDateTime'");
            this.setExamples("(time/zoned-date-time)", "(time/zoned-date-time 2018 8 1)", "(time/zoned-date-time 2018 8 1 14 20 10)", "(time/zoned-date-time 2018 8 1 14 20 10 200)", "(time/zoned-date-time \"2018-08-01T14:20:10.200+01:00\")", "(time/zoned-date-time 1375315200000)", "(time/zoned-date-time (. :java.util.Date :new))", "(time/zoned-date-time :UTC)", "(time/zoned-date-time :UTC 2018 8 1)", "(time/zoned-date-time :UTC 2018 8 1 14 20 10)", "(time/zoned-date-time :UTC 2018 8 1 14 20 10 200)", "(time/zoned-date-time :UTC \"2018-08-01T14:20:10.200+01:00\")", "(time/zoned-date-time :UTC 1375315200000)", "(time/zoned-date-time :UTC (. :java.util.Date :new))");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal val;
            FunctionsUtil.assertArity("time/zoned-date-time", args, 0, 1, 2, 3, 4, 6, 7, 8);
            ZoneId zoneId = null;
            VncList argList = args;
            if (args.size() > 0 && Types.isVncKeyword(val = args.first())) {
                zoneId = ZoneId.of(((VncKeyword)val).getValue());
                argList = args.slice(1);
            }
            if (argList.size() == 0) {
                return new VncJavaObject(ZonedDateTime.now(TimeFunctions.orDefaultZone(zoneId)));
            }
            if (argList.size() == 1) {
                val = argList.first();
                if (Types.isVncJavaObject(val)) {
                    Object obj = ((VncJavaObject)val).getDelegate();
                    if (obj instanceof Date) {
                        long millis = ((Date)obj).getTime();
                        return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(TimeFunctions.orDefaultZone(zoneId)));
                    }
                    if (obj instanceof ZonedDateTime) {
                        return new VncJavaObject(((ZonedDateTime)obj).withZoneSameInstant(TimeFunctions.orDefaultZone(zoneId)));
                    }
                    if (obj instanceof LocalDateTime) {
                        return new VncJavaObject(((LocalDateTime)obj).atZone(TimeFunctions.orDefaultZone(zoneId)));
                    }
                    if (obj instanceof LocalDate) {
                        return new VncJavaObject(((LocalDate)obj).atTime(0, 0, 0).atZone(TimeFunctions.orDefaultZone(zoneId)));
                    }
                    throw new VncException(String.format("Function 'time/zoned-date-time' does not allow %s as parameter", Types.getClassName(val)));
                }
                if (Types.isVncString(val)) {
                    String s = ((VncString)val).getValue();
                    return new VncJavaObject(ZonedDateTime.parse(s, TimeFunctions.zone(DateTimeFormatter.ISO_ZONED_DATE_TIME, zoneId)));
                }
                if (Types.isVncLong(val)) {
                    long millis = ((VncLong)val).getValue();
                    return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(TimeFunctions.orDefaultZone(zoneId)));
                }
                throw new VncException(String.format("Function 'time/zoned-date-time' does not allow %s as parameter", Types.getClassName(val)));
            }
            if (argList.size() == 3) {
                return new VncJavaObject(ZonedDateTime.of(Coerce.toVncLong(argList.nth(0)).getValue().intValue(), Coerce.toVncLong(argList.nth(1)).getValue().intValue(), Coerce.toVncLong(argList.nth(2)).getValue().intValue(), 0, 0, 0, 0, TimeFunctions.orDefaultZone(zoneId)));
            }
            if (argList.size() == 6) {
                return new VncJavaObject(ZonedDateTime.of(Coerce.toVncLong(argList.nth(0)).getValue().intValue(), Coerce.toVncLong(argList.nth(1)).getValue().intValue(), Coerce.toVncLong(argList.nth(2)).getValue().intValue(), Coerce.toVncLong(argList.nth(3)).getValue().intValue(), Coerce.toVncLong(argList.nth(4)).getValue().intValue(), Coerce.toVncLong(argList.nth(5)).getValue().intValue(), 0, TimeFunctions.orDefaultZone(zoneId)));
            }
            return new VncJavaObject(ZonedDateTime.of(Coerce.toVncLong(argList.nth(0)).getValue().intValue(), Coerce.toVncLong(argList.nth(1)).getValue().intValue(), Coerce.toVncLong(argList.nth(2)).getValue().intValue(), Coerce.toVncLong(argList.nth(3)).getValue().intValue(), Coerce.toVncLong(argList.nth(4)).getValue().intValue(), Coerce.toVncLong(argList.nth(5)).getValue().intValue(), Coerce.toVncLong(argList.nth(6)).getValue().intValue() * 1000000, TimeFunctions.orDefaultZone(zoneId)));
        }
    };
    public static VncFunction zoned_date_time_Q = new VncFunction("time/zoned-date-time?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/zoned-date-time? date)");
            this.setDoc("Returns true if date is a zoned-date-time else false");
            this.setExamples("(time/zoned-date-time? (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/zoned-date-time?", args, 1);
            VncVal val = args.first();
            return Types.isVncJavaObject(val, ZonedDateTime.class) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction zoned_date_time_parse = new VncFunction("time/zoned-date-time-parse"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/zoned-date-time-parse str format locale?");
            this.setDoc("Parses a zoned-date-time.");
            this.setExamples("(time/zoned-date-time-parse \"2018-08-01T14:20:01+01:00\" \"yyyy-MM-dd'T'HH:mm:ssz\")", "(time/zoned-date-time-parse \"2018-08-01T14:20:01.000+01:00\" \"yyyy-MM-dd'T'HH:mm:ss.SSSz\")", "(time/zoned-date-time-parse \"2018-08-01T14:20:01.000+01:00\" :ISO_OFFSET_DATE_TIME)", "(time/zoned-date-time-parse \"2018-08-01 14:20:01.000 +01:00\" \"yyyy-MM-dd' 'HH:mm:ss.SSS' 'z\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/zoned-date-time-parse", args, 2, 3);
            VncString date = Coerce.toVncString(args.first());
            DateTimeFormatter formatter = TimeFunctions.getDateTimeFormatter(args.second());
            Locale locale = args.size() == 3 ? TimeFunctions.getLocale(args.nth(2)) : null;
            return new VncJavaObject(ZonedDateTime.parse(date.getValue(), TimeFunctions.localize(formatter, locale)));
        }
    };
    public static VncFunction after_Q = new VncFunction("time/after?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/after? date1 date2)");
            this.setDoc("Returns true if date1 is after date2 else false");
            this.setExamples("(time/after? (time/local-date) (time/minus (time/local-date) :days 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/after?", args, 2);
            Object date1 = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object date2 = Coerce.toVncJavaObject(args.second()).getDelegate();
            if (date1 instanceof ZonedDateTime && date2 instanceof ZonedDateTime) {
                return ((ZonedDateTime)date1).isAfter((ZonedDateTime)date2) ? Constants.True : Constants.False;
            }
            if (date1 instanceof LocalDateTime && date2 instanceof LocalDateTime) {
                return ((LocalDateTime)date1).isAfter((LocalDateTime)date2) ? Constants.True : Constants.False;
            }
            if (date1 instanceof LocalDate && date2 instanceof LocalDate) {
                return ((LocalDate)date1).isAfter((LocalDate)date2) ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'time/after?' does not allow %s %s as date1 / date2 parameter", Types.getClassName(args.first()), Types.getClassName(args.second())));
        }
    };
    public static VncFunction not_after_Q = new VncFunction("time/not-after?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/not-after? date1 date2)");
            this.setDoc("Returns true if date1 is not-after date2 else false");
            this.setExamples("(time/not-after? (time/local-date) (time/minus (time/local-date) :days 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/not-after?", args, 2);
            Object date1 = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object date2 = Coerce.toVncJavaObject(args.second()).getDelegate();
            if (date1 instanceof ZonedDateTime && date2 instanceof ZonedDateTime) {
                return ((ZonedDateTime)date1).isAfter((ZonedDateTime)date2) ? Constants.False : Constants.True;
            }
            if (date1 instanceof LocalDateTime && date2 instanceof LocalDateTime) {
                return ((LocalDateTime)date1).isAfter((LocalDateTime)date2) ? Constants.False : Constants.True;
            }
            if (date1 instanceof LocalDate && date2 instanceof LocalDate) {
                return ((LocalDate)date1).isAfter((LocalDate)date2) ? Constants.False : Constants.True;
            }
            throw new VncException(String.format("Function 'time/not-after?' does not allow %s %s as date1 / date2 parameter", Types.getClassName(args.first()), Types.getClassName(args.second())));
        }
    };
    public static VncFunction before_Q = new VncFunction("time/before?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/before? date1 date2)");
            this.setDoc("Returns true if date1 is before date2 else false");
            this.setExamples("(time/before? (time/local-date) (time/minus (time/local-date) :days 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/before?", args, 2);
            Object date1 = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object date2 = Coerce.toVncJavaObject(args.second()).getDelegate();
            if (date1 instanceof ZonedDateTime && date2 instanceof ZonedDateTime) {
                return ((ZonedDateTime)date1).isBefore((ZonedDateTime)date2) ? Constants.True : Constants.False;
            }
            if (date1 instanceof LocalDateTime && date2 instanceof LocalDateTime) {
                return ((LocalDateTime)date1).isBefore((LocalDateTime)date2) ? Constants.True : Constants.False;
            }
            if (date1 instanceof LocalDate && date2 instanceof LocalDate) {
                return ((LocalDate)date1).isBefore((LocalDate)date2) ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'time/before?' does not allow %s %s as date1 / date2 parameter", Types.getClassName(args.first()), Types.getClassName(args.second())));
        }
    };
    public static VncFunction not_before_Q = new VncFunction("time/not-before?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/not-before? date1 date2)");
            this.setDoc("Returns true if date1 is not-before date2 else false");
            this.setExamples("(time/not-before? (time/local-date) (time/minus (time/local-date) :days 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/not-before?", args, 2);
            Object date1 = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object date2 = Coerce.toVncJavaObject(args.second()).getDelegate();
            if (date1 instanceof ZonedDateTime && date2 instanceof ZonedDateTime) {
                return ((ZonedDateTime)date1).isBefore((ZonedDateTime)date2) ? Constants.False : Constants.True;
            }
            if (date1 instanceof LocalDateTime && date2 instanceof LocalDateTime) {
                return ((LocalDateTime)date1).isBefore((LocalDateTime)date2) ? Constants.False : Constants.True;
            }
            if (date1 instanceof LocalDate && date2 instanceof LocalDate) {
                return ((LocalDate)date1).isBefore((LocalDate)date2) ? Constants.False : Constants.True;
            }
            throw new VncException(String.format("Function 'time/not-before?' does not allow %s %s as date1 / date2 parameter", Types.getClassName(args.first()), Types.getClassName(args.second())));
        }
    };
    public static VncFunction plus = new VncFunction("time/plus"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/plus date unit n)");
            this.setDoc("Adds the n units to the date. Units: {:years :months :weeks :days :hours :minutes :seconds :milliseconds}");
            this.setExamples("(time/plus (time/local-date) :days 2)", "(time/plus (time/local-date-time) :days 2)", "(time/plus (time/zoned-date-time) :days 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/plus", args, 3);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            ChronoUnit unit = TimeFunctions.toChronoUnit(Coerce.toVncKeyword(args.second()).getValue());
            long n = Coerce.toVncLong(args.nth(2)).getValue();
            if (unit == null) {
                throw new VncException(String.format("Function 'time/plus' invalid time unit %s", Coerce.toVncKeyword(args.second()).getValue()));
            }
            if (date instanceof ZonedDateTime) {
                return new VncJavaObject(((ZonedDateTime)date).plus(n, unit));
            }
            if (date instanceof LocalDateTime) {
                return new VncJavaObject(((LocalDateTime)date).plus(n, unit));
            }
            if (date instanceof LocalDate) {
                return new VncJavaObject(((LocalDate)date).plus(n, unit));
            }
            throw new VncException(String.format("Function 'time/plus' does not allow %s as date parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction minus = new VncFunction("time/minus"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/minus date unit n)");
            this.setDoc("Subtracts the n units from the date. Units: {:years :months :weeks :days :hours :minutes :seconds :milliseconds}");
            this.setExamples("(time/minus (time/local-date) :days 2)", "(time/minus (time/local-date-time) :days 2)", "(time/minus (time/zoned-date-time) :days 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/minus", args, 3);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            ChronoUnit unit = TimeFunctions.toChronoUnit(Coerce.toVncKeyword(args.second()).getValue());
            long n = Coerce.toVncLong(args.nth(2)).getValue();
            if (unit == null) {
                throw new VncException(String.format("Function 'time/minus' invalid time unit %ss", Coerce.toVncKeyword(args.second()).getValue()));
            }
            if (date instanceof ZonedDateTime) {
                return new VncJavaObject(((ZonedDateTime)date).minus(n, unit));
            }
            if (date instanceof LocalDateTime) {
                return new VncJavaObject(((LocalDateTime)date).minus(n, unit));
            }
            if (date instanceof LocalDate) {
                return new VncJavaObject(((LocalDate)date).minus(n, unit));
            }
            throw new VncException(String.format("Function 'time/minus' does not allow %s as date parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction period = new VncFunction("time/period"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/period from to unit)");
            this.setDoc("Returns the period interval of two dates in the specified unit. Units: {:years :months :weeks :days :hours :minutes :seconds :milliseconds}");
            this.setExamples("(time/period (time/local-date) (time/plus (time/local-date) :days 3) :days)", "(time/period (time/local-date-time) (time/plus (time/local-date-time) :days 3) :days)", "(time/period (time/zoned-date-time) (time/plus (time/zoned-date-time) :days 3) :days)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/period", args, 3);
            Object from = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object to = Coerce.toVncJavaObject(args.second()).getDelegate();
            ChronoUnit unit = TimeFunctions.toChronoUnit(Coerce.toVncKeyword(args.nth(2)).getValue());
            if (unit == null) {
                throw new VncException(String.format("Function 'time/period' invalid time unit %s", Coerce.toVncKeyword(args.second()).getValue()));
            }
            if (from instanceof ZonedDateTime && to instanceof ZonedDateTime) {
                return new VncLong(unit.between((ZonedDateTime)from, (ZonedDateTime)to));
            }
            if (from instanceof LocalDateTime && to instanceof LocalDateTime) {
                return new VncLong(unit.between((LocalDateTime)from, (LocalDateTime)to));
            }
            if (from instanceof LocalDate && to instanceof LocalDate) {
                return new VncLong(unit.between((LocalDate)from, (LocalDate)to));
            }
            throw new VncException(String.format("Function 'time/period' does not allow %s %s as from / to parameter", Types.getClassName(args.first()), Types.getClassName(args.second())));
        }
    };
    public static VncFunction year = new VncFunction("time/year"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/year date)");
            this.setDoc("Returns the year of the date");
            this.setExamples("(time/year (time/local-date))", "(time/year (time/local-date-time))", "(time/year (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/year", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getYear());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getYear());
            }
            if (date instanceof LocalDate) {
                return new VncLong(((LocalDate)date).getYear());
            }
            throw new VncException(String.format("Function 'time/year' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction month = new VncFunction("time/month"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/month date)");
            this.setDoc("Returns the month of the date 1..12");
            this.setExamples("(time/month (time/local-date))", "(time/month (time/local-date-time))", "(time/month (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/month", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getMonth().getValue());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getMonth().getValue());
            }
            if (date instanceof LocalDate) {
                return new VncLong(((LocalDate)date).getMonth().getValue());
            }
            throw new VncException(String.format("Function 'time/month' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction day_of_week = new VncFunction("time/day-of-week"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/day-of-week date)");
            this.setDoc("Returns the day of the week (:MONDAY ... :SUNDAY)");
            this.setExamples("(time/day-of-week (time/local-date))", "(time/day-of-week (time/local-date-time))", "(time/day-of-week (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/day-of-week", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncKeyword(((ZonedDateTime)date).getDayOfWeek().name());
            }
            if (date instanceof LocalDateTime) {
                return new VncKeyword(((LocalDateTime)date).getDayOfWeek().name());
            }
            if (date instanceof LocalDate) {
                return new VncKeyword(((LocalDate)date).getDayOfWeek().name());
            }
            throw new VncException(String.format("Function 'time/day-of-week' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction day_of_month = new VncFunction("time/day-of-month"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/day-of-month date)");
            this.setDoc("Returns the day of the month (1..31)");
            this.setExamples("(time/day-of-month (time/local-date))", "(time/day-of-month (time/local-date-time))", "(time/day-of-month (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/day-of-month", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getDayOfMonth());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getDayOfMonth());
            }
            if (date instanceof LocalDate) {
                return new VncLong(((LocalDate)date).getDayOfMonth());
            }
            throw new VncException(String.format("Function 'time/day-of-month' does not allow %s as parameters", Types.getClassName(args.first())));
        }
    };
    public static VncFunction day_of_year = new VncFunction("time/day-of-year"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/day-of-year date)");
            this.setDoc("Returns the day of the year (1..366)");
            this.setExamples("(time/day-of-year (time/local-date))", "(time/day-of-year (time/local-date-time))", "(time/day-of-year (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/day-of-year", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getDayOfYear());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getDayOfYear());
            }
            if (date instanceof LocalDate) {
                return new VncLong(((LocalDate)date).getDayOfYear());
            }
            throw new VncException(String.format("Function 'time/day-of-year' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction first_day_of_month = new VncFunction("time/first-day-of-month"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/first-day-of-month date)");
            this.setDoc("Returns the first day of a month as a local-date.");
            this.setExamples("(time/first-day-of-month (time/local-date))", "(time/first-day-of-month (time/local-date-time))", "(time/first-day-of-month (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/first-day-of-month", args, 1);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                LocalDate date = ((ZonedDateTime)dt).toLocalDateTime().toLocalDate();
                return new VncJavaObject(date.withDayOfMonth(1));
            }
            if (dt instanceof LocalDateTime) {
                LocalDate date = ((LocalDateTime)dt).toLocalDate();
                return new VncJavaObject(date.withDayOfMonth(1));
            }
            if (dt instanceof LocalDate) {
                LocalDate date = (LocalDate)dt;
                return new VncJavaObject(date.withDayOfMonth(1));
            }
            throw new VncException(String.format("Function 'time/first-day-of-month' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction last_day_of_month = new VncFunction("time/last-day-of-month"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/last-day-of-month date)");
            this.setDoc("Returns the last day of a month as a local-date.");
            this.setExamples("(time/last-day-of-month (time/local-date))", "(time/last-day-of-month (time/local-date-time))", "(time/last-day-of-month (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/last-day-of-month", args, 1);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                LocalDate date = ((ZonedDateTime)dt).toLocalDateTime().toLocalDate();
                return new VncJavaObject(date.withDayOfMonth(date.lengthOfMonth()));
            }
            if (dt instanceof LocalDateTime) {
                LocalDate date = ((LocalDateTime)dt).toLocalDate();
                return new VncJavaObject(date.withDayOfMonth(date.lengthOfMonth()));
            }
            if (dt instanceof LocalDate) {
                LocalDate date = (LocalDate)dt;
                return new VncJavaObject(date.withDayOfMonth(date.lengthOfMonth()));
            }
            throw new VncException(String.format("Function 'time/last-day-of-month' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction hour = new VncFunction("time/hour"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/hour date)");
            this.setDoc("Returns the hour of the date 1..24");
            this.setExamples("(time/hour (time/local-date))", "(time/hour (time/local-date-time))", "(time/hour (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/hour", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getHour());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getHour());
            }
            if (date instanceof LocalDate) {
                return new VncLong(0);
            }
            throw new VncException(String.format("Function 'time/hour' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction minute = new VncFunction("time/minute"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/minute date)");
            this.setDoc("Returns the minute of the date 0..59");
            this.setExamples("(time/minute (time/local-date))", "(time/minute (time/local-date-time))", "(time/minute (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/minute", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getMinute());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getMinute());
            }
            if (date instanceof LocalDate) {
                return new VncLong(0);
            }
            throw new VncException(String.format("Function 'time/minute' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction second = new VncFunction("time/second"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/second date)");
            this.setDoc("Returns the second of the date 0..59");
            this.setExamples("(time/second (time/local-date))", "(time/second (time/local-date-time))", "(time/second (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/second", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getSecond());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getSecond());
            }
            if (date instanceof LocalDate) {
                return new VncLong(0);
            }
            throw new VncException(String.format("Function 'time/second' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction length_of_year = new VncFunction("time/length-of-year"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/length-of-year date)");
            this.setDoc("Returns the length of the year represented by this date.");
            this.setExamples("(time/length-of-year (time/local-date 2000 1 1))", "(time/length-of-year (time/local-date 2001 1 1))", "(time/length-of-year (time/local-date-time))", "(time/length-of-year (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/length-of-year", args, 1);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)dt).toLocalDateTime().toLocalDate().lengthOfYear());
            }
            if (dt instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)dt).toLocalDate().lengthOfYear());
            }
            if (dt instanceof LocalDate) {
                return new VncLong(((LocalDate)dt).lengthOfYear());
            }
            throw new VncException(String.format("Function 'time/length-of-year' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction length_of_month = new VncFunction("time/length-of-month"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/length-of-month date)");
            this.setDoc("Returns the length of the month represented by this date.");
            this.setExamples("(time/length-of-month (time/local-date 2000 2 1))", "(time/length-of-month (time/local-date 2001 2 1))", "(time/length-of-month (time/local-date-time))", "(time/length-of-month (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/length-of-month", args, 1);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)dt).toLocalDateTime().toLocalDate().lengthOfMonth());
            }
            if (dt instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)dt).toLocalDate().lengthOfMonth());
            }
            if (dt instanceof LocalDate) {
                return new VncLong(((LocalDate)dt).lengthOfMonth());
            }
            throw new VncException(String.format("Function 'time/length-of-month' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction leap_yearQ = new VncFunction("time/leap-year?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/leap-year? date)");
            this.setDoc("Checks if the year is a leap year.");
            this.setExamples("(time/leap-year? 2000)", "(time/leap-year? (time/local-date 2000 1 1))", "(time/leap-year? (time/local-date-time))", "(time/leap-year? (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/leap-year?", args, 1);
            if (args.first() instanceof VncLong) {
                return LocalDate.of(Coerce.toVncLong(args.first()).getValue().intValue(), 1, 1).isLeapYear() ? Constants.True : Constants.False;
            }
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                return ((ZonedDateTime)dt).toLocalDateTime().toLocalDate().isLeapYear() ? Constants.True : Constants.False;
            }
            if (dt instanceof LocalDateTime) {
                return ((LocalDateTime)dt).toLocalDate().isLeapYear() ? Constants.True : Constants.False;
            }
            if (dt instanceof LocalDate) {
                return ((LocalDate)dt).isLeapYear() ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'time/leap-year?' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction with_time = new VncFunction("time/with-time"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/with-time date hour minute second)", "(time/with-time date hour minute second millis)");
            this.setDoc("Sets the time of a date. Returns a new date");
            this.setExamples("(time/with-time (time/local-date) 22 00 15 333)", "(time/with-time (time/local-date-time) 22 00 15 333)", "(time/with-time (time/zoned-date-time) 22 00 15 333)");
        }

        @Override
        public VncVal apply(VncList args) {
            int nanos;
            FunctionsUtil.assertArity("time/with-time", args, 4, 5);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            int n = nanos = args.size() == 5 ? Coerce.toVncLong(args.nth(4)).getValue().intValue() * 1000000 : 0;
            if (dt instanceof ZonedDateTime) {
                ZonedDateTime date = (ZonedDateTime)dt;
                return new VncJavaObject(date.withHour(Coerce.toVncLong(args.nth(1)).getValue().intValue()).withMinute(Coerce.toVncLong(args.nth(2)).getValue().intValue()).withSecond(Coerce.toVncLong(args.nth(3)).getValue().intValue()).withNano(nanos));
            }
            if (dt instanceof LocalDateTime) {
                return new VncJavaObject(((LocalDateTime)dt).toLocalDate().atTime(Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), Coerce.toVncLong(args.nth(3)).getValue().intValue(), nanos));
            }
            if (dt instanceof LocalDate) {
                return new VncJavaObject(((LocalDate)dt).atTime(Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), Coerce.toVncLong(args.nth(3)).getValue().intValue(), nanos));
            }
            throw new VncException(String.format("Function 'time/with-time' does not allow %s as parameters", Types.getClassName(args.first())));
        }
    };
    public static VncFunction latest = new VncFunction("time/latest"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/latest coll)");
            this.setDoc("Returns the latest date from a collection of dates. All dates must be of equal type. The coll may be empty or nil.");
            this.setExamples("(time/latest [(time/local-date 2018 8 1) (time/local-date 2018 8 3)])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/latest", args, 1);
            List dates = TimeFunctions.toJavaList(args, "time/latest");
            if (dates.isEmpty()) {
                return Constants.Nil;
            }
            if (dates.size() == 1) {
                return (VncVal)dates.get(0);
            }
            VncVal latest = (VncVal)dates.get(0);
            for (VncVal date : dates.subList(0, dates.size())) {
                if (after_Q.apply(new VncList(date, latest)) != Constants.True) continue;
                latest = date;
            }
            return latest;
        }
    };
    public static VncFunction earliest = new VncFunction("time/earliest"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/earliest coll)");
            this.setDoc("Returns the earliest date from a collection of dates. All dates must be of equal type. The coll may be empty or nil.");
            this.setExamples("(time/earliest [(time/local-date 2018 8 4) (time/local-date 2018 8 3)])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/earliest", args, 1);
            List dates = TimeFunctions.toJavaList(args, "time/earliest");
            if (dates.isEmpty()) {
                return Constants.Nil;
            }
            if (dates.size() == 1) {
                return (VncVal)dates.get(0);
            }
            VncVal latest = (VncVal)dates.get(0);
            for (VncVal date : dates.subList(0, dates.size())) {
                if (before_Q.apply(new VncList(date, latest)) != Constants.True) continue;
                latest = date;
            }
            return latest;
        }
    };
    public static VncFunction within_Q = new VncFunction("time/within?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/within? date start end)");
            this.setDoc("Returns true if the date is after or equal to the start and is before or equal to the end. All three dates must be of the same type.");
            this.setExamples("(time/within? (time/local-date 2018 8 4) (time/local-date 2018 8 1) (time/local-date 2018 8 31))", "(time/within? (time/local-date 2018 7 4) (time/local-date 2018 8 1) (time/local-date 2018 8 31))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/within?", args, 3);
            Object dt = Coerce.toVncJavaObject(args.nth(0)).getDelegate();
            Object start = Coerce.toVncJavaObject(args.nth(1)).getDelegate();
            Object end = Coerce.toVncJavaObject(args.nth(2)).getDelegate();
            if (dt instanceof ZonedDateTime) {
                ZonedDateTime date = (ZonedDateTime)dt;
                return date.isBefore((ZonedDateTime)start) || date.isAfter((ZonedDateTime)end) ? Constants.False : Constants.True;
            }
            if (dt instanceof LocalDateTime) {
                LocalDateTime date = (LocalDateTime)dt;
                return date.isBefore((LocalDateTime)start) || date.isAfter((LocalDateTime)end) ? Constants.False : Constants.True;
            }
            if (dt instanceof LocalDate) {
                LocalDate date = (LocalDate)dt;
                return date.isBefore((LocalDate)start) || date.isAfter((LocalDate)end) ? Constants.False : Constants.True;
            }
            throw new VncException(String.format("Function 'time/within?' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction zone = new VncFunction("time/zone"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/zone date)");
            this.setDoc("Returns the zone of the date");
            this.setExamples("(time/zone (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/zone", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncKeyword(((ZonedDateTime)date).getZone().getId());
            }
            if (date instanceof LocalDateTime) {
                return Constants.Nil;
            }
            if (date instanceof LocalDate) {
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'time/zone' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction zone_offset = new VncFunction("time/zone-offset"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/zone-offset date)");
            this.setDoc("Returns the zone-offset of the date in minutes");
            this.setExamples("(time/zone-offset (time/zoned-date-time))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/zone-offset", args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getOffset().getTotalSeconds() / 60);
            }
            if (date instanceof LocalDateTime) {
                return Constants.Nil;
            }
            if (date instanceof LocalDate) {
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'time/zone-offset' does not allow %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction formatter = new VncFunction("time/formatter"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/formatter format locale?)");
            this.setDoc("Creates a formatter");
            this.setExamples("(time/formatter \"dd-MM-yyyy\")", "(time/formatter \"dd-MM-yyyy\" :en_EN)", "(time/formatter \"dd-MM-yyyy\" \"en_EN\")", "(time/formatter \"yyyy-MM-dd'T'HH:mm:ss.SSSz\")", "(time/formatter :ISO_OFFSET_DATE_TIME)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/formatter", args, 1, 2);
            Locale locale = args.size() == 2 ? TimeFunctions.getLocale(args.nth(1)) : null;
            return new VncJavaObject(TimeFunctions.localize(TimeFunctions.getDateTimeFormatter(args.first()), locale));
        }
    };
    public static VncFunction format = new VncFunction("time/format"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/format date format locale?)", "(time/format date formatter locale?)");
            this.setDoc("Formats a date with a format");
            this.setExamples("(time/format (time/local-date) \"dd-MM-yyyy\")", "(time/format (time/zoned-date-time) \"yyyy-MM-dd'T'HH:mm:ss.SSSz\")", "(time/format (time/zoned-date-time) :ISO_OFFSET_DATE_TIME)", "(time/format (time/zoned-date-time) (time/formatter \"yyyy-MM-dd'T'HH:mm:ss.SSSz\"))", "(time/format (time/zoned-date-time) (time/formatter :ISO_OFFSET_DATE_TIME))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/format", args, 2, 3);
            if (!Types.isVncJavaObject(args.first())) {
                throw new VncException(String.format("Function 'time/format' does not allow %s as date parameter", Types.getClassName(date)));
            }
            Locale locale = args.size() == 3 ? TimeFunctions.getLocale(args.nth(2)) : null;
            DateTimeFormatter formatter = TimeFunctions.localize(TimeFunctions.getDateTimeFormatter(args.second()), locale);
            Object date = ((VncJavaObject)args.first()).getDelegate();
            if (date instanceof Date) {
                ZonedDateTime dt = Instant.ofEpochMilli(((Date)date).getTime()).atZone(ZoneId.systemDefault());
                return new VncString(dt.format(formatter));
            }
            if (date instanceof ZonedDateTime) {
                return new VncString(((ZonedDateTime)date).format(formatter));
            }
            if (date instanceof LocalDateTime) {
                return new VncString(((LocalDateTime)date).format(formatter));
            }
            if (date instanceof LocalDate) {
                return new VncString(((LocalDate)date).format(formatter));
            }
            throw new VncException(String.format("Function 'time/format' does not allow %s as date parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction zone_ids = new VncFunction("time/zone-ids"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/zone-ids)");
            this.setDoc("Returns all available zone ids with time offset");
            this.setExamples("(nfirst (seq (time/zone-ids)) 10)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/zone-ids", args, 0);
            VncOrderedMap map = new VncOrderedMap(new VncVal[0]);
            ArrayList<String> zoneList = new ArrayList<String>(ZoneId.getAvailableZoneIds());
            Map allZoneIds = TimeFunctions.getAllZoneIds(zoneList);
            allZoneIds.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> map.assoc(new VncKeyword((String)e.getKey()), new VncString((String)e.getValue())));
            return map;
        }
    };
    public static VncFunction to_millis = new VncFunction("time/to-millis"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(time/to-millis date)");
            this.setDoc("Converts the passed date to milliseconds since epoch");
            this.setExamples("(time/to-millis (time/local-date))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("time/to-millis", args, 1);
            VncVal val = args.first();
            if (Types.isVncJavaObject(val)) {
                Object date = ((VncJavaObject)val).getDelegate();
                if (date instanceof Date) {
                    return new VncLong(((Date)date).getTime());
                }
                if (date instanceof LocalDate) {
                    return new VncLong(((LocalDate)date).atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
                }
                if (date instanceof LocalDateTime) {
                    return new VncLong(((LocalDateTime)date).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
                }
                if (date instanceof ZonedDateTime) {
                    return new VncLong(((ZonedDateTime)date).toInstant().toEpochMilli());
                }
            }
            throw new VncException(String.format("Function 'time/to-millis' does not allow %s as parameter", Types.getClassName(val)));
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("time/date", (VncVal)date).put("time/date?", (VncVal)date_Q).put("time/local-date", (VncVal)local_date).put("time/local-date?", (VncVal)local_date_Q).put("time/local-date-parse", (VncVal)local_date_parse).put("time/local-date-time", (VncVal)local_date_time).put("time/local-date-time?", (VncVal)local_date_time_Q).put("time/local-date-time-parse", (VncVal)local_date_time_parse).put("time/zoned-date-time", (VncVal)zoned_date_time).put("time/zoned-date-time?", (VncVal)zoned_date_time_Q).put("time/zoned-date-time-parse", (VncVal)zoned_date_time_parse).put("time/with-time", (VncVal)with_time).put("time/zone-ids", (VncVal)zone_ids).put("time/to-millis", (VncVal)to_millis).put("time/formatter", (VncVal)formatter).put("time/format", (VncVal)format).put("time/plus", (VncVal)plus).put("time/minus", (VncVal)minus).put("time/period", (VncVal)period).put("time/year", (VncVal)year).put("time/month", (VncVal)month).put("time/day-of-week", (VncVal)day_of_week).put("time/day-of-month", (VncVal)day_of_month).put("time/day-of-year", (VncVal)day_of_year).put("time/first-day-of-month", (VncVal)first_day_of_month).put("time/last-day-of-month", (VncVal)last_day_of_month).put("time/hour", (VncVal)hour).put("time/minute", (VncVal)minute).put("time/second", (VncVal)second).put("time/leap-year?", (VncVal)leap_yearQ).put("time/length-of-year", (VncVal)length_of_year).put("time/length-of-month", (VncVal)length_of_month).put("time/zone", (VncVal)zone).put("time/zone-offset", (VncVal)zone_offset).put("time/after?", (VncVal)after_Q).put("time/not-after?", (VncVal)not_after_Q).put("time/before?", (VncVal)before_Q).put("time/not-before?", (VncVal)not_before_Q).put("time/earliest", (VncVal)earliest).put("time/latest", (VncVal)latest).put("time/within?", (VncVal)within_Q).toMap();

    private static Map<String, String> getAllZoneIds(List<String> zoneList) {
        HashMap<String, String> result = new HashMap<String, String>();
        LocalDateTime dt = LocalDateTime.now();
        for (String zoneId : zoneList) {
            ZoneId zone = ZoneId.of(zoneId);
            ZonedDateTime zdt = dt.atZone(zone);
            ZoneOffset zos = zdt.getOffset();
            String offset = zos.getId().replaceAll("Z", "+00:00");
            result.put(zone.toString(), offset);
        }
        return result;
    }

    private static Locale getLocale(VncVal locale) {
        if (locale == Constants.Nil) {
            return Locale.getDefault();
        }
        if (Types.isVncKeyword(locale)) {
            String[] e = ((VncKeyword)locale).getValue().split("_");
            switch (e.length) {
                case 0: {
                    return Locale.getDefault();
                }
                case 1: {
                    return new Locale(e[0]);
                }
                case 2: {
                    return new Locale(e[0], e[1]);
                }
            }
            return new Locale(e[0], e[1], e[2]);
        }
        if (Types.isVncString(locale)) {
            String[] e = ((VncString)locale).getValue().split("_");
            switch (e.length) {
                case 0: {
                    return Locale.getDefault();
                }
                case 1: {
                    return new Locale(e[0]);
                }
                case 2: {
                    return new Locale(e[0], e[1]);
                }
            }
            return new Locale(e[0], e[1], e[2]);
        }
        if (Types.isVncJavaObject(locale, Locale.class)) {
            return (Locale)((VncJavaObject)locale).getDelegate();
        }
        throw new VncException(String.format("The type %s does not define a Locale. %s", Types.getClassName(locale), ErrorMessage.buildErrLocation(locale)));
    }

    private static DateTimeFormatter getDateTimeFormatter(VncVal fmt) {
        if (Types.isVncKeyword(fmt)) {
            return TimeFunctions.getPredefinedDateTimeFormatter((VncKeyword)fmt);
        }
        if (Types.isVncString(fmt)) {
            return DateTimeFormatter.ofPattern(((VncString)fmt).getValue());
        }
        if (Types.isVncJavaObject(fmt, DateTimeFormatter.class)) {
            return (DateTimeFormatter)((VncJavaObject)fmt).getDelegate();
        }
        throw new VncException(String.format("Function 'time/format' does not allow %s as format parameter. %s", Types.getClassName(fmt), ErrorMessage.buildErrLocation(fmt)));
    }

    private static DateTimeFormatter getPredefinedDateTimeFormatter(VncKeyword fmt) {
        String fmtName = fmt.getValue();
        try {
            return (DateTimeFormatter)ReflectionAccessor.getStaticField(DateTimeFormatter.class, fmtName);
        }
        catch (Exception ex) {
            throw new VncException(String.format("'%s' is not a predefined DateTimeFormatter. %s", fmtName, ErrorMessage.buildErrLocation(fmt)));
        }
    }

    private static DateTimeFormatter localize(DateTimeFormatter formatter, Locale locale) {
        return locale == null ? formatter : formatter.withLocale(locale);
    }

    private static DateTimeFormatter zone(DateTimeFormatter formatter, ZoneId zoneId) {
        return zoneId == null ? formatter : formatter.withZone(zoneId);
    }

    private static ZoneId orDefaultZone(ZoneId zoneId) {
        return zoneId == null ? ZoneId.systemDefault() : zoneId;
    }

    private static ChronoUnit toChronoUnit(String unit) {
        switch (unit) {
            case "years": {
                return ChronoUnit.YEARS;
            }
            case "month": {
                return ChronoUnit.MONTHS;
            }
            case "weeks": {
                return ChronoUnit.WEEKS;
            }
            case "days": {
                return ChronoUnit.DAYS;
            }
            case "hours": {
                return ChronoUnit.HOURS;
            }
            case "minutes": {
                return ChronoUnit.MINUTES;
            }
            case "seconds": {
                return ChronoUnit.SECONDS;
            }
            case "millis": {
                return ChronoUnit.MILLIS;
            }
        }
        return null;
    }

    private static List<VncVal> toJavaList(VncList args, String fnName) {
        ArrayList<VncVal> dates = new ArrayList<VncVal>();
        if (args.first() == Constants.Nil) {
            return dates;
        }
        if (Types.isVncSequence(args.first())) {
            dates.addAll(((VncSequence)args.first()).getList());
        } else if (Types.isVncSet(args.first())) {
            dates.addAll(((VncSet)args.first()).getList());
        } else {
            throw new VncException(String.format("Function '%s' does not allow %s as parameter. %s", fnName, Types.getClassName(args.first()), ErrorMessage.buildErrLocation(args)));
        }
        return dates;
    }
}

