/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.util.CallFrame;

public class CallFrameBuilder {
    public static CallFrame fromVal(String fnName, VncVal val) {
        return CallFrameBuilder.build(fnName, val.getMetaVal(MetaUtil.FILE), val.getMetaVal(MetaUtil.LINE), val.getMetaVal(MetaUtil.COLUMN));
    }

    public static CallFrame fromVal(VncVal val) {
        return CallFrameBuilder.build(null, val.getMetaVal(MetaUtil.FILE), val.getMetaVal(MetaUtil.LINE), val.getMetaVal(MetaUtil.COLUMN));
    }

    public static CallFrame fromFunction(VncFunction fn, VncVal fnSym) {
        if (Types.isVncSymbol(fnSym)) {
            return CallFrameBuilder.build(fn.getName(), fnSym.getMetaVal(MetaUtil.FILE), fnSym.getMetaVal(MetaUtil.LINE), fnSym.getMetaVal(MetaUtil.COLUMN));
        }
        return CallFrameBuilder.build(fn.getName(), Constants.Nil, Constants.Nil, Constants.Nil);
    }

    public static CallFrame build(String fnName, VncVal file, VncVal line, VncVal column) {
        return new CallFrame(fnName, file == Constants.Nil ? null : Coerce.toVncString(file).getValue(), line == Constants.Nil ? null : Integer.valueOf(Coerce.toVncLong(line).getValue().intValue()), column == Constants.Nil ? null : Integer.valueOf(Coerce.toVncLong(column).getValue().intValue()));
    }
}

