/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.impl.Env;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PreCompiled
implements Serializable {
    private static final long serialVersionUID = -3044466744877602703L;
    private final String name;
    private final Object precompiled;
    private final Env env;
    private final String version;

    public PreCompiled(String name, Object precompiled, Env env) {
        this.name = name;
        this.precompiled = precompiled;
        this.env = env;
        this.version = "1.1.2";
    }

    public String getName() {
        return this.name;
    }

    public Object getPrecompiled() {
        return this.precompiled;
    }

    public Env getEnv() {
        return this.env;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)baos, true);){
            new ObjectOutputStream(gzos).writeObject(this);
            gzos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to serialize pre-compiled Venice script", ex);
        }
    }

    public static PreCompiled deserialize(byte[] precompiled) {
        PreCompiled preCompiled = PreCompiled.deserialize_(precompiled);
        if (!preCompiled.version.equals("1.1.2")) {
            throw new RuntimeException(String.format("Failed to deserialize pre-compiled Venice script. The pre-compiled version %s does not match this Venice version %s", preCompiled.version, "1.1.2"));
        }
        return preCompiled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PreCompiled deserialize_(byte[] precompiled) {
        ByteArrayInputStream bais = new ByteArrayInputStream(precompiled);
        try (GZIPInputStream gzis = new GZIPInputStream(bais);){
            PreCompiled preCompiled = (PreCompiled)new ObjectInputStream(gzis).readObject();
            return preCompiled;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to deserialize pre-compiled Venice script", ex);
        }
    }
}

