/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AnonymousFnArgs {
    private final Set<String> possibleFnArgs = new HashSet<String>(Arrays.asList("%1", "%2", "%3", "%4", "%5", "%6", "%7", "%8", "%9", "%10", "%", "%&"));
    private final Set<String> fnArgs = new HashSet<String>();
    private boolean capturing = false;

    public boolean isCapturing() {
        return this.capturing;
    }

    public void startCapture() {
        this.capturing = true;
        this.fnArgs.clear();
    }

    public void stopCapture() {
        this.capturing = false;
        this.fnArgs.clear();
    }

    public boolean isFnArgSymbol(VncSymbol sym) {
        return this.possibleFnArgs.contains(sym.getName());
    }

    public void addSymbol(VncSymbol sym) {
        if (this.isFnArgSymbol(sym)) {
            this.fnArgs.add(sym.getName());
        }
    }

    public VncVector buildArgDef() {
        VncVector argDef = new VncVector(new VncVal[0]);
        if (this.fnArgs.size() == 1 && this.fnArgs.contains("%")) {
            argDef.addAtEnd(new VncSymbol("%"));
        } else {
            for (int ii = 1; ii <= this.getMaArgxPos(); ++ii) {
                argDef.addAtEnd(new VncSymbol("%" + ii));
            }
            if (this.fnArgs.contains("%&")) {
                argDef.addAtEnd(new VncSymbol("&"));
                argDef.addAtEnd(new VncSymbol("%&"));
            }
        }
        return argDef;
    }

    private int getMaArgxPos() {
        return this.fnArgs.stream().filter(s -> s.matches("%[1-9][0-9]*")).map(s -> Integer.parseInt(s.substring(1))).max(Integer::compareTo).orElse(-1);
    }
}

