/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class CapturingPrintStream
extends PrintStream {
    private final String encoding;
    private final ByteArrayOutputStream boas;

    private CapturingPrintStream(String encoding, ByteArrayOutputStream boas) throws UnsupportedEncodingException {
        super((OutputStream)boas, true, encoding);
        this.encoding = encoding;
        this.boas = boas;
    }

    public static CapturingPrintStream create(String encoding) {
        try {
            return new CapturingPrintStream(encoding, new ByteArrayOutputStream());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding: " + encoding, ex);
        }
    }

    public static CapturingPrintStream create() {
        return CapturingPrintStream.create(Charset.defaultCharset().name());
    }

    public void reset() {
        this.boas.reset();
    }

    public boolean isEmpty() {
        return this.boas.size() == 0;
    }

    public String getOutput() {
        try {
            return this.boas.toString(this.encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding: " + this.encoding, ex);
        }
    }

    public byte[] getOutputAsBytes() {
        return this.boas.toByteArray();
    }
}

