/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.impl.AnonymousFnArgs;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.Token;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Reader {
    private static final Pattern atom_pattern = Pattern.compile("(?s)(^-?[0-9]+$)|(^-?[0-9][0-9.]*$)|(^-?[0-9][0-9.]*M$)|(^nil$)|(^true$)|(^false$)|^\"(.*)\"$|:(.*)|(^[^\"]*$)");
    private static final Pattern tokenize_pattern = Pattern.compile("[\\s ,]*(~@|[\\[\\]{}()'`~@]|\"(?:[\\\\].|[^\\\\\"])*\"|;.*|[^\\s \\[\\]{}()'\"`~@,;]*)");
    private ArrayList<Token> tokens;
    private int position;
    private final AnonymousFnArgs anonymousFnArgs = new AnonymousFnArgs();

    public Reader(ArrayList<Token> tokens) {
        this.tokens = tokens;
        this.position = 0;
    }

    public static VncVal read_str(String str, String filename) {
        return Reader.read_form(new Reader(Reader.tokenize(str, filename)));
    }

    private Token peek() {
        return this.position >= this.tokens.size() ? null : this.tokens.get(this.position);
    }

    private Token next() {
        return this.tokens.get(this.position++);
    }

    private static ArrayList<Token> tokenize(String str, String filename) {
        char[] strArr = str.toCharArray();
        Matcher matcher = tokenize_pattern.matcher(str);
        int[] lastPos = new int[]{1, 1};
        int lastStartPos = 0;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (matcher.find()) {
            String token = matcher.group(1);
            if (token == null || token.equals("") || token.charAt(0) == ';') continue;
            int tokenStartPos = matcher.start(1);
            int[] pos = Reader.getTextPosition(strArr, tokenStartPos, lastStartPos, lastPos[0], lastPos[1]);
            tokens.add(new Token(token, filename, pos[0], pos[1]));
            lastStartPos = tokenStartPos;
            lastPos = pos;
        }
        return tokens;
    }

    private static VncVal read_atom(Reader rdr) {
        Token token = rdr.next();
        Matcher matcher = atom_pattern.matcher(token.getToken());
        if (!matcher.find()) {
            throw new ParseError(String.format("Unrecognized token '%s'. %s", token.getToken(), ErrorMessage.buildErrLocation(token)));
        }
        if (matcher.group(1) != null) {
            return MetaUtil.withTokenPos(new VncLong(Long.parseLong(matcher.group(1))), token);
        }
        if (matcher.group(2) != null) {
            return MetaUtil.withTokenPos(new VncDouble(Double.parseDouble(matcher.group(2))), token);
        }
        if (matcher.group(3) != null) {
            String dec = matcher.group(3);
            dec = dec.substring(0, dec.length() - 1);
            return MetaUtil.withTokenPos(new VncBigDecimal(new BigDecimal(dec)), token);
        }
        if (matcher.group(4) != null) {
            return Constants.Nil;
        }
        if (matcher.group(5) != null) {
            return Constants.True;
        }
        if (matcher.group(6) != null) {
            return Constants.False;
        }
        if (matcher.group(7) != null) {
            return MetaUtil.withTokenPos(new VncString(StringUtil.unescape(StringUtil.decodeUnicode(matcher.group(7)))), token);
        }
        if (matcher.group(8) != null) {
            return MetaUtil.withTokenPos(new VncKeyword(matcher.group(8)), token);
        }
        if (matcher.group(9) != null) {
            VncSymbol sym = new VncSymbol(matcher.group(9));
            rdr.anonymousFnArgs.addSymbol(sym);
            return MetaUtil.withTokenPos(sym, token);
        }
        throw new ParseError(String.format("Unrecognized '%s'. %s", matcher.group(0), ErrorMessage.buildErrLocation(token)));
    }

    private static VncList read_list(Reader rdr, VncList lst, char start, char end) {
        Token lstToken = rdr.next();
        MetaUtil.withTokenPos(lst, lstToken);
        if (lstToken.charAt(0) != start) {
            throw new ParseError(String.format("Expected '%s'. %s", Character.valueOf(start), ErrorMessage.buildErrLocation(lstToken)));
        }
        Token token = lstToken;
        while ((token = rdr.peek()) != null && token.charAt(0) != end) {
            lst.addAtEnd(Reader.read_form(rdr));
        }
        if (token == null) {
            throw new ParseError(String.format("Expected '" + end + "', got EOF. %s", ErrorMessage.buildErrLocation(lstToken)));
        }
        rdr.next();
        return lst;
    }

    private static VncHashMap read_hash_map(Reader rdr) {
        Token refToken = rdr.peek();
        VncList lst = Reader.read_list(rdr, new VncList(new VncVal[0]), '{', '}');
        return (VncHashMap)MetaUtil.withTokenPos(new VncHashMap(lst), refToken);
    }

    private static VncVal read_form(Reader rdr) {
        VncVal form;
        Token token = rdr.peek();
        if (token == null) {
            throw new ContinueException();
        }
        switch (token.charAt(0)) {
            case '\'': {
                rdr.next();
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("quote"), Reader.read_form(rdr)), token);
            }
            case '`': {
                rdr.next();
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("quasiquote"), Reader.read_form(rdr)), token);
            }
            case '~': {
                if (token.equals("~")) {
                    rdr.next();
                    return MetaUtil.withTokenPos(new VncList(new VncSymbol("unquote"), Reader.read_form(rdr)), token);
                }
                rdr.next();
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("splice-unquote"), Reader.read_form(rdr)), token);
            }
            case '^': {
                rdr.next();
                VncVal meta = Reader.read_form(rdr);
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("with-meta"), Reader.read_form(rdr), meta), token);
            }
            case '@': {
                rdr.next();
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("deref"), Reader.read_form(rdr)), token);
            }
            case '#': {
                rdr.next();
                Token t = rdr.peek();
                if (t.charAt(0) == '{') {
                    form = new VncSet(Reader.read_list(rdr, new VncList(new VncVal[0]), '{', '}'));
                    break;
                }
                if (t.charAt(0) == '(') {
                    if (rdr.anonymousFnArgs.isCapturing()) {
                        throw new ParseError(String.format(" #() forms cannot be nested. %s", ErrorMessage.buildErrLocation(t)));
                    }
                    rdr.anonymousFnArgs.startCapture();
                    VncList body = Reader.read_list(rdr, new VncList(new VncVal[0]), '(', ')');
                    VncVector argsDef = rdr.anonymousFnArgs.buildArgDef();
                    form = new VncList(new VncSymbol("fn"), argsDef, body);
                    rdr.anonymousFnArgs.stopCapture();
                    break;
                }
                throw new ParseError(String.format("Expected '{' or '('. %s", ErrorMessage.buildErrLocation(t)));
            }
            case '(': {
                form = Reader.read_list(rdr, new VncList(new VncVal[0]), '(', ')');
                break;
            }
            case ')': {
                throw new ParseError(String.format("Unexpected ')'. %s", ErrorMessage.buildErrLocation(token)));
            }
            case '[': {
                form = Reader.read_list(rdr, new VncVector(new VncVal[0]), '[', ']');
                break;
            }
            case ']': {
                throw new ParseError(String.format("Unexpected ']'. %s", ErrorMessage.buildErrLocation(token)));
            }
            case '{': {
                form = Reader.read_hash_map(rdr);
                break;
            }
            case '}': {
                throw new ParseError(String.format("Unexpected '}'. %s", ErrorMessage.buildErrLocation(token)));
            }
            default: {
                form = Reader.read_atom(rdr);
            }
        }
        return form;
    }

    private static int[] getTextPosition(char[] text, int pos, int startPos, int startRow, int startCol) {
        int row = startRow;
        int col = startCol;
        block5: for (int ii = startPos; ii < pos; ++ii) {
            switch (text[ii]) {
                case '\n': {
                    ++row;
                    col = 1;
                    continue block5;
                }
                case '\r': {
                    continue block5;
                }
                case '\t': {
                    col += 4;
                    continue block5;
                }
                default: {
                    ++col;
                }
            }
        }
        return new int[]{row, col};
    }
}

