/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.functions.IOFnBlacklisted;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.Interceptor;
import java.util.Set;

public class RejectAllInterceptor
extends Interceptor {
    private final Set<String> blacklistedVeniceFunctions = IOFnBlacklisted.getAllIoFunctions();

    @Override
    public Object onInvokeInstanceMethod(IInvoker invoker, Object receiver, String method, Object ... args) throws SecurityException {
        throw new SecurityException(String.format("Access denied to target %s", receiver.getClass().getName()));
    }

    @Override
    public Object onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        throw new SecurityException(String.format("Access denied to target %s", receiver.getName()));
    }

    @Override
    public Object onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        throw new SecurityException(String.format("Access denied to target %s", receiver.getName()));
    }

    @Override
    public Object onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        throw new SecurityException(String.format("Access denied to target %s", receiver.getClass().getName()));
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        throw new SecurityException(String.format("Access denied to target %s", receiver.getClass().getName()));
    }

    @Override
    public Object onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        throw new SecurityException(String.format("Access denied to target %s", receiver.getName()));
    }

    @Override
    public Object onGetInstanceField(IInvoker invoker, Object receiver, String fieldName) throws SecurityException {
        throw new SecurityException(String.format("Access denied to target %s", receiver.getClass().getName()));
    }

    @Override
    public byte[] onLoadClassPathResource(String resourceName) throws SecurityException {
        throw new SecurityException(String.format("Venice Sandbox: Access denied to classpath resource '%s'", resourceName));
    }

    @Override
    public String onReadSystemProperty(String propertyName) throws SecurityException {
        throw new SecurityException(String.format("Venice Sandbox: Access denied to system property '%s'", propertyName));
    }

    @Override
    public void validateBlackListedVeniceFunction(String funcName) throws SecurityException {
        if (this.blacklistedVeniceFunctions.contains(funcName)) {
            throw new SecurityException(String.format("Access denied to Venice function %s. (reject-all sandbox)", funcName));
        }
    }
}

