/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.JsonFunctions;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.zip.ZipFileSystemUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.javainterop.LoadPathsFactory;
import com.github.jlangch.venice.util.NullInputStream;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AppRunner {
    public static String run(File appArchive, VncList cmdLineArgs, ILoadPaths loadPaths, PrintStream stdout, PrintStream stderr, Reader stdin) {
        ArrayList<File> mergedLoadPaths = new ArrayList<File>();
        mergedLoadPaths.add(appArchive.getAbsoluteFile());
        mergedLoadPaths.addAll(loadPaths.getPaths());
        ILoadPaths appLoadPaths = LoadPathsFactory.of(mergedLoadPaths, loadPaths.isUnlimitedAccess());
        AcceptAllInterceptor interceptor = new AcceptAllInterceptor(appLoadPaths);
        VncMap manifest = AppRunner.getManifest(appArchive);
        String appName = Coerce.toVncString(manifest.get(new VncString("app-name"))).getValue();
        String mainFile = Coerce.toVncString(manifest.get(new VncString("main-file"))).getValue();
        VeniceInterpreter venice = new VeniceInterpreter(interceptor);
        Env env = AppRunner.createEnv(venice, Arrays.asList(AppRunner.convertCliArgsToVar(cmdLineArgs == null ? VncList.empty() : cmdLineArgs), AppRunner.convertAppNameToVar(appName), AppRunner.convertAppArchiveToVar(appArchive)), stdout, stderr, stdin);
        String script = String.format("(do (load-file \"%s\") nil)", AppRunner.stripVeniceFileExt(mainFile));
        return venice.PRINT(venice.RE(script, appName, env));
    }

    private static VncMap getManifest(File app) {
        if (app.exists()) {
            try {
                VncString manifest = ZipFileSystemUtil.loadTextFileFromZip(app, new File("MANIFEST.MF"), "utf-8");
                return Coerce.toVncMap(JsonFunctions.read_str.apply(VncList.of(manifest)));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to load manifest from Venice application archive '%s'.", app.getPath()));
            }
        }
        throw new VncException(String.format("The Venice application archive '%s' does not exist", app.getPath()));
    }

    private static Env createEnv(IVeniceInterpreter venice, List<Var> vars, PrintStream stdout, PrintStream stderr, Reader stdin) {
        PrintStream stdout_ = stdout == null ? new PrintStream(new NullOutputStream(), true) : stdout;
        PrintStream stderr_ = stderr == null ? new PrintStream(new NullOutputStream(), true) : stderr;
        Reader stdin_ = stdin == null ? new InputStreamReader(new NullInputStream()) : stdin;
        return venice.createEnv(true, false, RunMode.APP).addGlobalVars(vars).setStdoutPrintStream(stdout_).setStderrPrintStream(stderr_).setStdinReader(stdin_);
    }

    private static Var convertAppNameToVar(String appName) {
        return new Var(new VncSymbol("*app-name*"), new VncString(appName), false);
    }

    private static Var convertAppArchiveToVar(File appArchive) {
        return new Var(new VncSymbol("*app-archive*"), new VncJavaObject(appArchive), false);
    }

    private static Var convertCliArgsToVar(VncList cmdLineArgs) {
        return new Var(new VncSymbol("*ARGV*"), cmdLineArgs, false);
    }

    private static String stripVeniceFileExt(String s) {
        return StringUtil.removeEnd(s, ".venice");
    }
}

