/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Namespaces {
    public static final String NS_CURRENT_NAME = "*ns*";
    public static final VncSymbol NS_CURRENT_SYMBOL = new VncSymbol("*ns*");
    public static final VncSymbol NS_USER = new VncSymbol("user");
    public static final VncSymbol NS_CORE = new VncSymbol("core");
    public static final Set<String> SYSTEM_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("core", "cidr", "csv", "dag", "io", "json", "math", "pdf", "sh", "str", "regex", "time", "repl")));
    public static final Set<String> RESERVED_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("local", "core", "cidr", "csv", "io", "json", "math", "pdf", "sh", "str", "regex", "time", "repl", "crypt", "xml", "bench", "docx", "excel", "component", "dag", "test", "shell", "xchart", "kira", "parsatron", "tc", "ring", "http", "jackson", "webdav", "maven")));

    public static VncSymbol lookupNS(VncVal ns, Env env) {
        if (ns == null || ns == Constants.Nil) {
            return NS_CORE;
        }
        if (Types.isVncSymbol(ns)) {
            VncSymbol ns_ = (VncSymbol)ns;
            if (Namespaces.isCurrentNSSymbol(ns_)) {
                VncVal val = env.getGlobalOrNil(ns_);
                return val == Constants.Nil ? NS_CORE : (VncSymbol)val;
            }
            return ns_;
        }
        throw new VncException(String.format("Cannot map type '%s' to VncSymbol to lookup namespace", Types.getType(ns)));
    }

    public static boolean isCoreNS(VncSymbol nsSym) {
        return NS_CORE.equals(nsSym);
    }

    public static boolean isCoreNS(String nsName) {
        return "core".equals(nsName);
    }

    public static boolean isCurrentNSSymbol(VncSymbol nsSym) {
        return NS_CURRENT_NAME.equals(nsSym.getName());
    }

    public static boolean isSystemNS(String nsName) {
        return SYSTEM_NAMESPACES.contains(nsName);
    }

    public static boolean isCurrentNSSymbol(String nsName) {
        return NS_CURRENT_NAME.equals(nsName);
    }

    public static VncSymbol getCurrentNS() {
        return ThreadContext.getCurrNS().getNS();
    }

    public static Namespace getCurrentNamespace() {
        return ThreadContext.getCurrNS();
    }

    public static void setCurrentNamespace(Namespace ns) {
        ThreadContext.setCurrNS(ns);
    }

    public static VncSymbol qualifySymbolWithCurrNS(VncSymbol sym) {
        if (sym == null) {
            return null;
        }
        if (sym.hasNamespace()) {
            return new VncSymbol(sym.getName(), MetaUtil.setNamespace(sym.getMeta(), sym.getNamespace()));
        }
        VncSymbol ns = Namespaces.getCurrentNS();
        VncVal newMeta = MetaUtil.setNamespace(sym.getMeta(), ns.getName());
        return Namespaces.isCoreNS(ns) ? new VncSymbol(sym.getName(), newMeta) : new VncSymbol(ns.getName(), sym.getName(), newMeta);
    }
}

