/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet;

import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItem;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import java.util.ArrayList;
import java.util.List;

public class DocSection {
    private final String title;
    private final String subtitle;
    private final String id;
    private final List<String> headers = new ArrayList<String>();
    private final String footerXmlStyled;
    private final List<DocSection> sections = new ArrayList<DocSection>();
    private final List<DocItem> items = new ArrayList<DocItem>();

    public DocSection(String title, String id) {
        this(title, null, id, null, null);
    }

    public DocSection(String title, String subtitle, String id) {
        this(title, subtitle, id, null, null);
    }

    public DocSection(String title, String subtitle, String id, String header, String footer) {
        this.title = title;
        this.subtitle = subtitle;
        this.id = id;
        if (header != null) {
            this.headers.add(header);
        }
        this.footerXmlStyled = DocSection.styleFooter(footer);
    }

    public String getTitle() {
        return this.title;
    }

    public String getFormattedTitle() {
        return this.subtitle == null ? this.title : this.title + "\u00a0\u00a0(" + this.subtitle + ")";
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public String getFooterXmlStyled() {
        return this.footerXmlStyled;
    }

    public void addSection(DocSection section) {
        if (section != null) {
            this.sections.add(section);
        }
    }

    public void addLiteralItem(String name, String text, String id) {
        DocSection s = new DocSection(name, id);
        this.addSection(s);
        s.addItem(new DocItem(text, null));
    }

    public List<DocSection> getSections() {
        return this.sections;
    }

    public boolean isSectionsEmpty() {
        return this.sections.isEmpty();
    }

    public void addItem(DocItem item) {
        if (item != null) {
            this.items.add(item);
        }
    }

    public List<DocItem> getItems() {
        return this.items;
    }

    public boolean isItemsEmpty() {
        return this.items.isEmpty();
    }

    public String toString() {
        return this.getFormattedTitle() + ", id=" + this.id;
    }

    private static String styleFooter(String footer) {
        return footer == null ? null : Markdown.parse(footer).renderToHtml();
    }
}

