/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.env;

import com.github.jlangch.venice.SymbolNotFoundException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.env.DynamicVar;
import com.github.jlangch.venice.impl.env.GlobalRefVar;
import com.github.jlangch.venice.impl.env.ReservedSymbols;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Env
implements Serializable {
    private static final long serialVersionUID = 9002640180394221858L;
    private final boolean allowShadowingGlobalVars = true;
    private final boolean failOnPrivateSymbolAccess = true;
    private final boolean globalVarLookupOptimization = true;
    private final Env outer;
    private final int level;
    private final Map<VncSymbol, Var> precompiledGlobalSymbols;
    private final Map<VncSymbol, Var> globalSymbols;
    private final Map<VncSymbol, Var> localSymbols;

    public Env() {
        this((Env)null);
    }

    public Env(Env outer) {
        if (outer == null) {
            this.outer = null;
            this.level = 0;
            this.precompiledGlobalSymbols = null;
            this.globalSymbols = new ConcurrentHashMap<VncSymbol, Var>(2048);
            this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>(64);
        } else {
            this.outer = outer;
            this.level = outer.level() + 1;
            this.precompiledGlobalSymbols = outer.precompiledGlobalSymbols;
            this.globalSymbols = outer.globalSymbols;
            this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>(64);
        }
    }

    private Env(Map<VncSymbol, Var> precompiledGlobalSymbols) {
        this.outer = null;
        this.level = 0;
        this.precompiledGlobalSymbols = precompiledGlobalSymbols;
        this.globalSymbols = new ConcurrentHashMap<VncSymbol, Var>(256);
        this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>(64);
    }

    public Env copyGlobalToPrecompiledSymbols() {
        return new Env(this.globalSymbols);
    }

    public Env parent() {
        return this.outer;
    }

    public int level() {
        return this.level;
    }

    public VncVal get(VncSymbol sym) {
        VncVal val = this.getOrElse(sym, null);
        if (val != null) {
            return val;
        }
        WithCallStack cs = new WithCallStack(CallFrame.from(sym));
        Throwable throwable = null;
        try {
            try {
                String symName = sym.getQualifiedName();
                throw new SymbolNotFoundException(symName.startsWith("\\") ? String.format("Symbol '%s' not found. Did you mean the char literal '#%s'?", symName, symName) : String.format("Symbol '%s' not found.", symName), symName);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public boolean isGlobal(VncSymbol sym) {
        Var dv = this.getGlobalVar(sym);
        return dv != null && !(dv instanceof DynamicVar);
    }

    public boolean isDynamic(VncSymbol sym) {
        Var dv = this.getGlobalVar(sym);
        return dv != null && dv instanceof DynamicVar;
    }

    public boolean isLocal(VncSymbol sym) {
        return sym.hasNamespace() ? false : this.findLocalVar(sym) != null;
    }

    public boolean isBound(VncSymbol sym) {
        if (sym.hasNamespace()) {
            return this.getGlobalVar(sym) != null;
        }
        Var v = this.findLocalVar(sym);
        return v != null ? true : this.getGlobalVar(sym) != null;
    }

    public VncVal getOrNil(VncSymbol sym) {
        return this.getOrElse(sym, Constants.Nil);
    }

    public VncVal getGlobalOrNil(VncSymbol sym) {
        Var v = this.getGlobalVar(sym);
        return v != null ? v.getVal() : Constants.Nil;
    }

    public VncVal getGlobalOrNull(VncSymbol sym) {
        Var v = this.getGlobalVar(sym);
        return v != null ? v.getVal() : null;
    }

    public Var getGlobalVarOrNull(VncSymbol sym) {
        return this.getGlobalVar(sym);
    }

    public Env setLocal(Var localVar) {
        VncSymbol sym = localVar.getName();
        if (ReservedSymbols.isReserved(sym)) {
            WithCallStack cs = new WithCallStack(CallFrame.from(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Rejected setting local var with name '%s'. Use another name, please.", sym.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        this.localSymbols.put(sym, localVar);
        return this;
    }

    public Env setGlobal(Var val) {
        VncSymbol sym = val.getName();
        if (ReservedSymbols.isSpecialForm(sym.getName())) {
            WithCallStack cs = new WithCallStack(CallFrame.from(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Rejected setting var %s with name of a special form", sym.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        Var v = this.getGlobalVar(sym);
        if (v != null && !v.isOverwritable()) {
            WithCallStack cs = new WithCallStack(CallFrame.from(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The existing global var '%s' must not be overwritten!", sym.getQualifiedName()));
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            catch (Throwable throwable6) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable6;
            }
        }
        this.setGlobalVar(sym, val);
        return this;
    }

    public Env addGlobalVars(List<Var> vars) {
        vars.forEach(v -> this.setGlobal((Var)v));
        return this;
    }

    public Env addLocalVars(List<Var> vars) {
        for (Var b : vars) {
            this.setLocal(b);
        }
        return this;
    }

    public List<Var> getLocalVars(int levelsUp) {
        Env env = this;
        for (int ii = 0; ii < levelsUp; ++ii) {
            env = env == null ? null : env.outer;
        }
        return env == null ? new ArrayList<Var>() : env.localSymbols.values().stream().filter(v -> !(v instanceof GlobalRefVar)).collect(Collectors.toList());
    }

    public void pushGlobalDynamic(VncSymbol sym, VncVal val) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        if (dv != null) {
            dv.pushVal(val);
        } else {
            DynamicVar nv = new DynamicVar(sym, Constants.Nil);
            this.setGlobalVar(sym, nv);
            nv.pushVal(val);
        }
    }

    public VncVal popGlobalDynamic(VncSymbol sym) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        return dv != null ? dv.popVal() : Constants.Nil;
    }

    public VncVal peekGlobalDynamic(VncSymbol sym) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        return dv != null ? dv.peekVal() : Constants.Nil;
    }

    public void setGlobalDynamic(VncSymbol sym, VncVal val) {
        Var gv = this.getGlobalVar(sym);
        if (gv == null) {
            DynamicVar nv = new DynamicVar(sym, Constants.Nil);
            this.setGlobalVar(sym, nv);
            nv.pushVal(val);
        } else if (gv instanceof DynamicVar) {
            DynamicVar nv = (DynamicVar)gv;
            nv.pushVal(val);
        } else {
            DynamicVar nv = new DynamicVar(sym, gv.getVal());
            this.setGlobalVar(sym, nv);
            nv.pushVal(val);
        }
    }

    public void replaceGlobalDynamic(VncSymbol sym, VncVal val) {
        DynamicVar nv = new DynamicVar(sym, Constants.Nil);
        this.setGlobalVar(sym, nv);
        nv.pushVal(val);
    }

    public void removeGlobalSymbol(VncSymbol sym) {
        this.globalSymbols.remove(sym);
    }

    public void removeGlobalSymbolsByNS(VncSymbol ns) {
        String nsName = ns.getName();
        this.globalSymbols.keySet().stream().filter(s -> nsName.equals(s.getNamespace())).forEach(s -> this.globalSymbols.remove(s));
    }

    public Env setStdoutPrintStream(PrintStream ps) {
        this.replaceGlobalDynamic(new VncSymbol("*out*"), VncJavaObject.from(ps != null ? ps : IOStreamUtil.nullPrintStream(), PrintStream.class));
        return this;
    }

    public Env setStderrPrintStream(PrintStream ps) {
        this.replaceGlobalDynamic(new VncSymbol("*err*"), VncJavaObject.from(ps != null ? ps : IOStreamUtil.nullPrintStream(), PrintStream.class));
        return this;
    }

    public Env setMacroExpandOnLoad(VncBoolean macroexpandOnLoad) {
        this.setGlobal(new Var(new VncSymbol("*macroexpand-on-load*"), macroexpandOnLoad, true));
        return this;
    }

    public Env setStdinReader(Reader rd) {
        if (rd == null) {
            this.replaceGlobalDynamic(new VncSymbol("*in*"), VncJavaObject.from(IOStreamUtil.nullBufferedReader(), Reader.class));
        } else if (rd instanceof BufferedReader) {
            this.replaceGlobalDynamic(new VncSymbol("*in*"), VncJavaObject.from(rd, Reader.class));
        } else {
            this.replaceGlobalDynamic(new VncSymbol("*in*"), VncJavaObject.from(new BufferedReader(rd), Reader.class));
        }
        return this;
    }

    private DynamicVar findGlobalDynamicVar(VncSymbol sym) {
        Var dv = this.getGlobalVar(sym);
        if (dv != null && dv instanceof DynamicVar) {
            return (DynamicVar)dv;
        }
        return null;
    }

    private VncVal getOrElse(VncSymbol sym, VncVal defaultVal) {
        if (sym.hasNamespace()) {
            Var glob = this.getGlobalVar(sym);
            return glob == null ? defaultVal : glob.getVal();
        }
        Var local = this.findLocalVar(sym);
        if (local != null) {
            if (local instanceof GlobalRefVar) {
                Var glob = this.getGlobalVar(sym);
                return glob == null ? defaultVal : glob.getVal();
            }
            return local.getVal();
        }
        Var glob = this.getGlobalVar(sym);
        if (glob != null) {
            this.localSymbols.put(sym, new GlobalRefVar(sym));
            return glob.getVal();
        }
        return defaultVal;
    }

    public Var findLocalVar(VncSymbol sym) {
        Var v = this.localSymbols.get(sym);
        if (v != null) {
            return v;
        }
        Env env = this.outer;
        while (env != null) {
            v = env.localSymbols.get(sym);
            if (v != null) {
                return v;
            }
            env = env.outer;
        }
        return null;
    }

    private Var getGlobalVar(VncSymbol sym) {
        Var v = null;
        String symNsName = sym.getNamespace();
        String symSimpleName = sym.getSimpleName();
        if (symNsName != null) {
            String realsNsName;
            v = "core".equals(symNsName) ? this.getGlobalVarRaw(new VncSymbol(symSimpleName)) : ((realsNsName = Namespaces.getCurrentNamespace().lookupByAlias(symNsName)) != null ? this.getGlobalVarRaw("core".equals(realsNsName) ? new VncSymbol(symSimpleName) : new VncSymbol(realsNsName, symSimpleName, Constants.Nil)) : this.getGlobalVarRaw(sym));
        } else {
            VncSymbol currNS = Namespaces.getCurrentNS();
            if (!Namespaces.isCoreNS(currNS)) {
                VncSymbol s = new VncSymbol(currNS.getName(), symSimpleName, Constants.Nil);
                v = this.getGlobalVarRaw(s);
            }
            if (v == null) {
                v = this.getGlobalVarRaw(sym);
            }
        }
        if (v == null) {
            return null;
        }
        this.rejectPrivateSymbolAccess(sym, v);
        return v;
    }

    private Var getGlobalVarRaw(VncSymbol sym) {
        Var v;
        if (this.precompiledGlobalSymbols != null && (v = this.precompiledGlobalSymbols.get(sym)) != null) {
            return v;
        }
        return this.globalSymbols.get(sym);
    }

    private void setGlobalVar(VncSymbol sym, Var value) {
        this.globalSymbols.put(sym, value);
    }

    public Map<VncSymbol, Var> getAllGlobalSymbols() {
        HashMap<VncSymbol, Var> all = new HashMap<VncSymbol, Var>();
        if (this.precompiledGlobalSymbols != null) {
            all.putAll(this.precompiledGlobalSymbols);
        }
        all.putAll(this.globalSymbols);
        return all;
    }

    public List<VncSymbol> getAllGlobalFunctionSymbols() {
        return this.getAllGlobalSymbols().entrySet().stream().filter(e -> ((Var)e.getValue()).getVal() instanceof VncFunction).map(e -> {
            VncFunction fn = (VncFunction)((Var)e.getValue()).getVal();
            return ((VncSymbol)e.getKey()).withMeta(VncHashMap.of(new VncKeyword("group"), new VncString(fn.getNamespace()), new VncKeyword("arglists"), fn.getArgLists(), new VncKeyword("doc"), fn.getDoc()));
        }).collect(Collectors.toList());
    }

    private void rejectPrivateSymbolAccess(VncSymbol sym, Var globalVar) {
        VncSymbol globalVarSym = globalVar.getName();
        if (globalVarSym.isPrivate()) {
            String symNS;
            String currNS = Namespaces.getCurrentNS().getName();
            String string = symNS = globalVarSym.hasNamespace() ? globalVarSym.getNamespace() : "core";
            if (!currNS.equals(symNS)) {
                CallStack callStack = ThreadContext.getCallStack();
                WithCallStack cs = new WithCallStack(new CallFrame("symbol", sym.getMeta()));
                Throwable throwable = null;
                try {
                    try {
                        throw new VncException(String.format("Illegal access of private symbol '%s/%s' accessed from namespace '%s'.\n%s", symNS, globalVarSym.getSimpleName(), currNS, callStack.toString()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }
}

