/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.env;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.WithCallStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ReservedSymbols {
    private static final Set<String> sepcial_forms = new HashSet<String>(Arrays.asList("binding", "bound?", "def", "defmacro", "defmethod", "defmulti", "defonce", "deftype", "deftype?", "deftype-of", "deftype-or", "def-dynamic", "do", "dobench", "doc", "dorun", "eval", "fn", "if", "import", "imports", "inspect", "let", "locking", "loop", "macroexpand", "macroexpand-all*", "modules", "namespace", "ns", "ns-list", "ns-remove", "ns-unmap", "print-highlight", "prof", "quasiquote", "quote", "recur", "resolve", "set!", "tail-pos", "try", "try-with", "var-get", "var-global?", "var-local?", "var-name", "var-ns", "var-thread-local?", ".:", "call-cc", "defprotocol", "defrecord"));
    private static final Set<String> reserved = ReservedSymbols.merge(sepcial_forms, Arrays.asList(".", "proxify", "*in*", "*out*", "*err*", "*version*", "*newline*", "*ns*", "*loaded-modules*", "*loaded-files*", "*run-mode*", "*macroexpand-on-load*", "*ansi-term*", "*app-name*", "*app-archive*", "*ARGV*", "*REPL*", "*repl-color-theme*"));

    public static boolean isReserved(VncSymbol symbol) {
        return symbol != null && reserved.contains(symbol.getName());
    }

    public static boolean isSpecialForm(VncSymbol symbol) {
        return symbol != null && sepcial_forms.contains(symbol.getName());
    }

    public static boolean isSpecialForm(String name) {
        return name != null && sepcial_forms.contains(name);
    }

    public static void validateNotReservedSymbol(VncSymbol symbol) {
        if (symbol != null && ReservedSymbols.isReserved(symbol)) {
            WithCallStack cs = new WithCallStack(new CallFrame(symbol.getQualifiedName(), symbol.getMeta()));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Reserved symbol '%s'. Redefinition is not allowed.", symbol.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
    }

    private static <T> HashSet<T> merge(Set<T> s1, Collection<T> s2) {
        HashSet<T> s = new HashSet<T>(s1);
        s.addAll(s2);
        return s;
    }
}

